/*  socks4.c - routines used to interact with socks5 proxy
    Copyright (C) 2005-2006  Jia Wang (skyroam@gmail.com) 
    
    This file is part of Proxyknife.

    Proxyknife is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Proxyknife is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <netdb.h>
#include <proxyknife.h>
#include <netdb.h>
extern int h_errno;

/* Send connect command (connect to serv) to socks4 tunnel without identd. 
 *
 * Return value:
 * 0: success!
 * -1: failure.
 *
 *  This should be committed after successful negotiation with socks5 proxy.
 * */
#define SOCKS4USER "anonymous"
        
        int
s4con (int sockfd, struct sockaddr *serv)
{
  char p[9+9];
  memset(p,0,sizeof(p));
  p[0]=4;/* version */
  p[1]=1;/* connect command */
  *(short int *) (p + 2) =
    (short int) (((struct sockaddr_in *) serv)->sin_port);
  *(struct in_addr *) (p + 4) = ((struct sockaddr_in *) serv)->sin_addr;
  memmove(p+8,SOCKS4USER,9);
  /* p[8+9]='\x0'; */
  /* p[8]='\x0'; *//* userid ,variable*/
  /* p[9]='\x0'; *//* NULL */
  
  if (write (sockfd, p, 10) == 10)
    {
      /* ATYP is expected as IPV4 . Need repaired here. */
      if (read (sockfd, p, 8) == 8)
	{			/* ATYP is not parsed  here. The chars unread
				   will not  the following GET and Verify. */
	  if ((p[0]==0)&&(p[1]==90))
	    return 0;
      else fprintf(stderr,"SOCKS4 server error reply:%02X %02X\n",
                      p[0],p[1]
                      );
	}
    }
  return -1;
}

/* Unfinished now */
/* ***************************inside thread **********************/

/* Build connection to remote server through free or username/password-
 * authentication socks5 proxy. 
 *
 * The time sending connect command to socks5 proxy is stored in *start.
 * The time receiving success  reply from socks5 proxy is stored in * end.
 * 
 * Return value:
 * 0: success!
 * -1: failure.
 * */
int
CONVIASOCKS4 (int sockfd, struct timeval *start,
	      struct timeval *end, struct thread_mem *thread_mem)
{
  int ret, len, offset;
  char *p;

  ret =
    connect (sockfd, (struct sockaddr *) &(my.myaddr),
	     sizeof (struct sockaddr));
  if (ret == -1)
    {
      perror ("CONVIASOCKS4:connect:Connect to myaddr");
      return -1;
    }

  /* build request */
  if (my.mytype != SOCKS4_CONNECT)
    {
      fprintf (stderr, "%s: " __FILE__ 
                      " CONVIASOCKS4:This message can't  be printed!\n",
	       progname);
      abort ();
      /* return -1; */
    }

  /* notice: user may be customized for the need of identd */
  /* send */
  gettimeofday (start, NULL);
  ret = s4con (sockfd, (struct sockaddr *) &(thread_mem->queue.proxyaddr));
  if (ret == -1)
    return -1;
  gettimeofday (end, NULL);
  return 0;
}


/* Negotiation with free socks4 proxy , build connection to target through 
 * free socks proxy. At last it call GET to send HTTP/1.0 GET request 
 * to target.
 *
 * The time sending connect command to socks4 proxy is stored in *start_CON.
 * The time receiving successfuly reply to this is stored in *end_CON.
 * 
 * Return value:
 *  >0: success!
 *  -1: failure.
 *  
 * Verify should be done immediately after this for correct delay.
 *  */
int
S4PCONGET (int sockfd, struct timeval *start_CON, struct timeval *end_CON,
	   struct timeval *start_GET, struct thread_mem *thread_mem)
{
  int ret;

  gettimeofday (start_CON, NULL);
  /*fprintf(stdout,"Verifying socks4 server %s...",
                  thread_mem->queue.testproxy
                  );*/
                  
  ret = s4con (sockfd, (struct sockaddr *) &(target.targetaddr));
  if (ret == -1)
    return -1;
  gettimeofday (end_CON, NULL);

  return GET (sockfd, start_GET, thread_mem);

}
