/* main program startup for Quizzer
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/*
 * quizzer.c
 * Guy Albertelli II 1996
 */
#include <stdio.h>
#include <tk.h>
#include <stdlib.h>
#include <pProj/capaCommon.h>
#include <unistd.h>
#include <quizzer.h>

extern Tcl_Interp *gInterp;

int Quizzer_Init(Tcl_Interp *interp);
int main(int argc, char**argv)
{
  char * rDisplay,*q,filename[BUFFER_SIZE],buffer[BUFFER_SIZE];
  int  found=1;

  gInterp=Tcl_CreateInterp();
  if (gInterp ==NULL)
  {
    fprintf(stderr,"Couldn't get a new Tcl Interp\n");
    return -1;
  }

  rDisplay = getenv("DISPLAY");
  
  if (rDisplay==NULL)
  {
    fprintf(stderr,"getenv for DISPLAY returned NULL\n");
    return -2;
  }
  
  if (Tcl_SetVar2 (gInterp, "env", "DISPLAY", rDisplay, TCL_GLOBAL_ONLY) == NULL) 
  {
    fprintf(stderr,"Couldn't set env(DISPLAY) = %s\n",rDisplay);
    return -3;
  }

  q = Tcl_Merge(argc-1, argv+1);
  Tcl_SetVar(gInterp, "argv", q, TCL_GLOBAL_ONLY);
  ckfree(q);
  sprintf(buffer, "%d", argc-1);
  Tcl_SetVar(gInterp, "argc", buffer, TCL_GLOBAL_ONLY);
  Tcl_SetVar(gInterp, "argv0", argv[0],TCL_GLOBAL_ONLY);
  Tcl_SetVar(gInterp, "tcl_interactive","0", TCL_GLOBAL_ONLY);

  if (Tcl_Init(gInterp) == TCL_ERROR) 
  {
    fprintf(stderr,"Tcl_Init error\n");
    fprintf(stderr,"%d\n",TCL_ERROR);
    fprintf(stderr,"%s\n",gInterp->result);
    return -4;
  }
  
  if (Tk_Init(gInterp) == TCL_ERROR) 
  {
    fprintf(stderr,"Tk_Init error\n");
    fprintf(stderr,"%d\n",TCL_ERROR);
    fprintf(stderr,"%s\n",gInterp->result);
    return -5;
  }

  Quizzer_Init(gInterp);

  sprintf(filename,"./utils.tcl");
  if( capa_access(filename, F_OK) == -1 ) {
    sprintf(filename,"/usr/local/bin/Quizzer/utils.tcl");
    if( capa_access(filename, F_OK) == -1 ) {
      sprintf(filename,"/usr/local/lib/CAPA45/utils.tcl");
      if( capa_access(filename, F_OK) == -1 ) {
	sprintf(filename,"/usr/local/lib/utils.tcl");
	if( capa_access(filename, F_OK) == -1 ) {
	  sprintf(filename,"/usr/local/lib/utils.tcl");
	  if( capa_access(filename, F_OK) == -1 ) {
	    sprintf(filename,"/usr/local/lib/CAPA45/Quizzer/utils.tcl");
	    if( capa_access(filename, F_OK) == -1 ) {
	      sprintf(filename,"/usr/lib/utils.tcl");
	      if( capa_access(filename, F_OK) == -1 ) { /* I gave up! */
		found=0;
	      } 
	    }
	  }
	} 
      }
    }
  }

  if( found ) {
    if (Tcl_EvalFile(gInterp, filename) != TCL_OK) 
      {
	fprintf(stderr,"%s\n",gInterp->result);
	return -6;
      }
  } else {
    fprintf(stderr,"Unable to find utils.tcl\n");
    exit(-7);
  }

  sprintf(filename,"./common.tcl");
  if( capa_access(filename, F_OK) == -1 ) {
    sprintf(filename,"/usr/local/bin/Quizzer/common.tcl");
    if( capa_access(filename, F_OK) == -1 ) {
      sprintf(filename,"/usr/local/lib/CAPA45/common.tcl");
      if( capa_access(filename, F_OK) == -1 ) {
	sprintf(filename,"/usr/local/lib/common.tcl");
	if( capa_access(filename, F_OK) == -1 ) {
	  sprintf(filename,"/usr/local/lib/common.tcl");
	  if( capa_access(filename, F_OK) == -1 ) {
	    sprintf(filename,"/usr/local/lib/CAPA45/Quizzer/common.tcl");
	    if( capa_access(filename, F_OK) == -1 ) {
	      sprintf(filename,"/usr/lib/common.tcl");
	      if( capa_access(filename, F_OK) == -1 ) { /* I gave up! */
		found=0;
	      } 
	    }
	  }
	} 
      }
    }
  }  
  if( found ) {
    if (Tcl_EvalFile(gInterp, filename) != TCL_OK) 
      {
	fprintf(stderr,"%s\n",gInterp->result);
	return -6;
      }
  } else {
    fprintf(stderr,"Unable to find common.tcl\n");
    exit(-7);
  }
  sprintf(filename,"./quizzer.tcl");
  if( capa_access(filename, F_OK) == -1 ) {
    sprintf(filename,"/usr/local/bin/Quizzer/quizzer.tcl");
    if( capa_access(filename, F_OK) == -1 ) {
      sprintf(filename,"/usr/local/lib/CAPA45/quizzer.tcl");
      if( capa_access(filename, F_OK) == -1 ) {
	sprintf(filename,"/usr/local/lib/quizzer.tcl");
	if( capa_access(filename, F_OK) == -1 ) {
	  sprintf(filename,"/usr/local/lib/quizzer.tcl");
	  if( capa_access(filename, F_OK) == -1 ) {
	    sprintf(filename,"/usr/local/lib/CAPA45/Quizzer/quizzer.tcl");
	    if( capa_access(filename, F_OK) == -1 ) {
	      sprintf(filename,"/usr/lib/quizzer.tcl");
	      if( capa_access(filename, F_OK) == -1 ) { /* I gave up! */
		found=0;
	      } 
	    }
	  }
	} 
      }
    }
  }

  /*
  fprintf(stderr,"HEY STILL IN DEVELOPEMENT MODE\n");
  if (Tcl_EvalFile(gInterp, "quizzer.tcl") 
      != TCL_OK) 
  {
    fprintf(stderr,"%s\n",gInterp->result);
    return -6;
  }
  */
  
  if( found ) {
    if (Tcl_EvalFile(gInterp, filename) != TCL_OK) 
    {
      fprintf(stderr,"%s\n",gInterp->result);
      return -6;
    }
    while(Tcl_DoOneEvent(TCL_ALL_EVENTS));
  } else {
	fprintf(stderr,"Unable to find quizzer.tcl\n");
	exit(-7);
  }
  return 0;
}



