/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var removedScripts = require("script_entries/removed_scripts").removedScripts;

var acceptedScripts = require("script_entries/accepted_scripts").acceptedScripts;

var scriptObject = {

    // can be an attribute, an inline script,
    // or an external script.
    type: null,

    // flagged whether it is unchecked, checked,
    // accepted, or rejected, ...
    status: null,

    // contains the dom element
    element: null,
    
    // the attribute name, if applicable.
    attribute: null,

    // the script text as a string.
    value: null,
    
    // the src url if external.
    url: null,
    
    // the script text if inline.
    text: null,

    init: function (props) {

	// check the required elements are present.
	if (props == undefined) {
	    throw "Error, missing script entry value in script_object.js";
	}

	// required properties
	if (props.type != undefined) {
	    this.type = props.type;
	} else {
	    throw "type is missing";

	}

	if (props.status != undefined) {

	    this.status = props.status;
	} else {
	   throw "status is missing";
	}

	if (props.element != undefined) {
	    this.element = props.element;
	} else {
	    throw "element is missing";
	}
	
	// conditional properties.
	this.url = (props.url) ? props.url : null;
	this.text = (props.text) ? props.text : null;
	this.jsAttributes = (props.jsAttributes) ? props.jsAttributes : null;
    },

    tagAsAccepted: function (pageURL, reason) {
	var content = this.findContentType();
	var inline = (this.url != undefined) ? false : true;
	
	this.element.setAttribute('data-librejs', 'accepted');

	/*if (reason != undefined) {
	    this.element.setAttribute('data-librejs-reason', reason);
	}*/
	
	acceptedScripts.addAScript(pageURL, {'inline': inline,
					     'contents': content
					    });

    },

    tagAsRemoved: function (pageURL, reason) {

	var content = this.findContentType();
	var inline = (this.url != undefined) ? false : true;

	this.element.setAttribute('data-librejs', 'rejected');

	/*if (reason != undefined) {
	    this.element.setAttribute('data-librejs-reason', reason);
	}*/
	
	removedScripts.addAScript(pageURL, {'inline': inline,
					    'contents': content});

    },

    /**
     * removeNarcissusBugLine
     *
     * Removes the line that is appended to all
     * inline scripts and prevent the bug that prevent
     * script tags with comments only from being checked.
     *
     */
    removeNarcissusBugLine: function (str) {
	return str.replace('\n\nthis.narcissusBugFixLibreJS', '');
    },

    /**
     * findContentType
     *
     * Figure out whether it's an external script,
     * an inline script, or an attribute from the property
     * that has been set, rather than blindly trusting the given
     * constant.
     */
    findContentType: function () {

	if (this.url != undefined) {

	    return this.url;

	} else if (this.text != undefined) {

	    return this.element.text; 

	} else if (this.jsAttributes != undefined) {
	    // return the array.
	    return JSON.stringify(this.jsAttributes);

	}
	
    }

};

exports.Script = function (props) {
    var obj = Object.create(scriptObject);
    obj.init(props);
    return obj;
};