/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.Environment;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class SeaOfGatesEngineOld
extends SeaOfGatesEngine {
    Rectangle2D[] threadAreas;
    int threadCount;
    List<SeaOfGatesEngine.NeededRoute> myList;
    int totalRoutes;
    int routesDone;
    Rectangle2D pendingArea;
    List<Runnable> pendingRunnables = new ArrayList<Runnable>();

    @Override
    protected void doRoutingParallel(int numberOfThreads, List<SeaOfGatesEngine.NeededRoute> allRoutes) {
        this.debug("Do routing parallel with raw threads");
        this.myList = new ArrayList<SeaOfGatesEngine.NeededRoute>(allRoutes);
        this.routesDone = 0;
        this.totalRoutes = allRoutes.size();
        RouteInThread[] threads = new RouteInThread[numberOfThreads];
        this.threadCount = numberOfThreads;
        this.threadAreas = new Rectangle2D[numberOfThreads];
        Semaphore outSem = new Semaphore(0);
        for (int i = 0; i < numberOfThreads; ++i) {
            threads[i] = new RouteInThread("Route #" + (i + 1), this.env, i, outSem);
            threads[i].start();
        }
        int timeOut = 20;
        while (true) {
            try {
                while (!outSem.tryAcquire(this.threadCount, timeOut, TimeUnit.MILLISECONDS)) {
                    this.flush();
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    private synchronized Runnable getNext(int threadNumber) {
        if (this.checkAbort()) {
            this.info("Sea-of-gates routing aborted thread " + threadNumber);
            return null;
        }
        this.threadAreas[threadNumber] = null;
        if (this.pendingRunnables.isEmpty()) {
            for (int i = 0; i < this.myList.size(); ++i) {
                SeaOfGatesEngine.NeededRoute nr = this.myList.get(i);
                boolean isBlocked = false;
                for (int t = 0; t < this.threadCount; ++t) {
                    if (this.threadAreas[t] == null || !this.threadAreas[t].intersects(nr.getBounds())) continue;
                    isBlocked = true;
                    break;
                }
                if (isBlocked) continue;
                this.trace("Thread " + (threadNumber + 1) + " routing " + nr.getName() + "...");
                this.setProgressNote(nr.getName());
                this.myList.remove(i);
                Runnable[] runnables = this.findPath(nr);
                if (runnables == null || runnables.length == 0) {
                    ++this.routesDone;
                    continue;
                }
                this.routesDone -= runnables.length - 1;
                this.pendingArea = nr.getBounds();
                this.pendingRunnables.addAll(Arrays.asList(runnables));
                break;
            }
        }
        if (this.pendingRunnables.isEmpty()) {
            return null;
        }
        this.threadAreas[threadNumber] = this.pendingArea;
        return this.pendingRunnables.remove(0);
    }

    private class RouteInThread
    extends Thread {
        private Semaphore whenDone;
        private Environment env;
        private int threadNumber;

        public RouteInThread(String name, Environment env, int threadNumber, Semaphore whenDone) {
            super(name);
            this.env = env;
            this.threadNumber = threadNumber;
            this.whenDone = whenDone;
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(this.env);
            while (true) {
                Runnable runnable;
                if ((runnable = SeaOfGatesEngineOld.this.getNext(this.threadNumber)) == null) break;
                runnable.run();
                ++SeaOfGatesEngineOld.this.routesDone;
                SeaOfGatesEngineOld.this.setProgressValue(SeaOfGatesEngineOld.this.routesDone, SeaOfGatesEngineOld.this.totalRoutes);
            }
            this.whenDone.release();
        }
    }
}

