/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.VerticalRoute;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class InteractiveRouter
extends Router {
    private List<Highlight2> startRouteHighlights = new ArrayList<Highlight2>();
    private boolean started;
    private EditWindow wnd;
    private ElectricObject badStartObject;
    private ElectricObject badEndObject;

    public InteractiveRouter() {
        this.verbose = true;
        this.started = false;
        this.badEndObject = null;
        this.badStartObject = null;
        this.wnd = null;
        this.tool = Routing.getRoutingTool();
    }

    public String toString() {
        return "Interactive Router";
    }

    protected abstract boolean planRoute(Route var1, Cell var2, RouteElementPort var3, Point2D var4, Point2D var5, Point2D var6, PolyMerge var7, VerticalRoute var8, boolean var9, boolean var10, boolean var11, Rectangle2D var12);

    public void startInteractiveRoute(EditWindow wnd) {
        this.wnd = wnd;
        this.startRouteHighlights.clear();
        for (Highlight2 h : wnd.getHighlighter().getHighlights()) {
            this.startRouteHighlights.add(h);
        }
        wnd.clearHighlighting();
        this.started = true;
    }

    public void cancelInteractiveRoute() {
        Highlighter highlighter = this.wnd.getHighlighter();
        highlighter.clear();
        highlighter.setHighlightList(this.startRouteHighlights);
        highlighter.finished();
        this.wnd = null;
        this.started = false;
    }

    public void makeRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, true, true);
        wnd.clearHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        this.createRoute(route, cell);
        this.started = false;
    }

    public boolean makeVerticalRoute(EditWindow wnd, PortInst startPort, ArcProto arc) {
        if (startPort.getPortProto().connectsTo(arc)) {
            return true;
        }
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Point2D.Double startLoc = new Point2D.Double(startPort.getPoly().getCenterX(), startPort.getPoly().getCenterY());
        Poly poly = InteractiveRouter.getConnectingSite(startPort, startLoc, -1.0);
        RouteElementPort startRE = RouteElementPort.existingPortInst(startPort, poly);
        Route route = new Route();
        route.add(startRE);
        route.setStart(startRE);
        VerticalRoute vroute = VerticalRoute.newRoute(startPort.getPortProto(), arc);
        if (!vroute.isSpecificationSucceeded()) {
            this.cancelInteractiveRoute();
            return false;
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        Router.ContactSize sizer = new Router.ContactSize(startPort, null, startLoc, startLoc, startLoc, startArc, endArc, false);
        Rectangle2D contactArea = sizer.getContactSize();
        Dimension2D.Double contactSize = new Dimension2D.Double(contactArea.getWidth(), contactArea.getHeight());
        int startAngle = sizer.getStartAngle();
        double startArcWidth = sizer.getStartWidth();
        Cell cell = wnd.getCell();
        Route vertRoute = vroute.buildRoute(cell, startLoc, contactSize, startAngle, null);
        for (RouteElement re : vertRoute) {
            if (!route.contains(re)) {
                route.add(re);
            }
            route.setEnd(vertRoute.getEnd());
        }
        if (route.replacePin(startRE, vertRoute.getStart(), null)) {
            route.remove(startRE);
            if (route.getStart() == startRE) {
                route.setStart(vertRoute.getStart());
            }
        } else {
            InteractiveRouter.addConnectingArc(route, cell, startRE, vertRoute.getStart(), startLoc, startLoc, startArc, startArcWidth, startAngle, true, true, null);
        }
        wnd.finishedHighlighting();
        wnd.getHighlighter().setHighlightList(this.startRouteHighlights);
        new MakeVerticalRouteJob(this, route, cell, true);
        this.started = false;
        return true;
    }

    public void highlightRoute(EditWindow wnd, Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        Route route = this.planRoute(cell, startObj, endObj, clicked, null, true, true);
        this.highlightRoute(wnd, route, cell);
    }

    public void highlightRoute(EditWindow wnd, Route route, Cell cell) {
        if (!this.started) {
            this.startInteractiveRoute(wnd);
        }
        wnd.clearHighlighting();
        for (RouteElement e : route) {
            e.addHighlightArea(wnd.getHighlighter());
        }
        wnd.finishedHighlighting();
    }

    public Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked, PolyMerge stayInside, boolean extendArcHead, boolean extendArcTail) {
        return this.planRoute(cell, startObj, endObj, clicked, stayInside, extendArcHead, extendArcTail, null);
    }

    public Route planRoute(Cell cell, ElectricObject startObj, ElectricObject endObj, Point2D clicked, PolyMerge stayInside, boolean extendArcHead, boolean extendArcTail, Rectangle2D contactArea) {
        PortProto endPort;
        EditingPreferences ep = cell.getEditingPreferences();
        Route route = new Route();
        if (cell == null) {
            return route;
        }
        if (startObj == endObj) {
            return route;
        }
        RouteElementPort startRE = null;
        RouteElementPort endRE = null;
        startObj = InteractiveRouter.filterRouteObject(startObj, clicked);
        endObj = InteractiveRouter.filterRouteObject(endObj, clicked);
        PortProto startPort = InteractiveRouter.getRoutePort(startObj);
        if (startPort == null) {
            return route;
        }
        if (endObj == null) {
            ArcProto useArc = InteractiveRouter.getArcToUse(startPort, null);
            if (useArc == null) {
                return route;
            }
            PrimitiveNode pn = useArc.findOverridablePinProto(ep);
            endPort = pn.getPort(0);
        } else {
            endPort = InteractiveRouter.getRoutePort(endObj);
        }
        VerticalRoute vroute = VerticalRoute.newRoute(startPort, endPort);
        if (!vroute.isSpecificationSucceeded()) {
            return new Route();
        }
        ArcProto startArc = vroute.getStartArc();
        ArcProto endArc = vroute.getEndArc();
        double startArcWidth = 0.0;
        double endArcWidth = 0.0;
        if (!ClickZoomWireListener.theOne.getUseFatWiringMode()) {
            startArcWidth = InteractiveRouter.getArcWidthToUse(startObj, startArc, 0, true);
            double d = endArcWidth = endObj == null ? startArcWidth : InteractiveRouter.getArcWidthToUse(endObj, endArc, 0, true);
            if (startArc == endArc) {
                if (startArcWidth > endArcWidth) {
                    endArcWidth = startArcWidth;
                }
                if (endArcWidth > startArcWidth) {
                    startArcWidth = endArcWidth;
                }
            }
        }
        if (extendArcHead) {
            boolean bl = extendArcHead = startArc.getDefaultInst(ep).isHeadExtended() || endArc.getDefaultInst(ep).isHeadExtended();
        }
        if (extendArcTail) {
            extendArcTail = startArc.getDefaultInst(ep).isTailExtended() || endArc.getDefaultInst(ep).isTailExtended();
        }
        Poly startPoly = InteractiveRouter.getConnectingSite(startObj, clicked, startArcWidth);
        Poly endPoly = InteractiveRouter.getConnectingSite(endObj, clicked, endArcWidth);
        Poly startPolyFull = InteractiveRouter.getConnectingSite(startObj, clicked, -1.0);
        Poly endPolyFull = InteractiveRouter.getConnectingSite(endObj, clicked, -1.0);
        Point2D.Double startPoint = new Point2D.Double(0.0, 0.0);
        Point2D.Double endPoint = new Point2D.Double(0.0, 0.0);
        InteractiveRouter.getConnectingPoints(startObj, endObj, clicked, startPoint, endPoint, startPoly, endPoly, startArc, endArc);
        PortInst existingStartPort = null;
        PortInst existingEndPort = null;
        boolean contactsOnEndObject = true;
        if (startObj instanceof PortInst) {
            existingStartPort = (PortInst)startObj;
            startRE = RouteElementPort.existingPortInst(existingStartPort, startPoly);
        }
        if (startObj instanceof ArcInst && (startRE = this.findArcConnectingPoint(route, (ArcInst)startObj, startPoint, stayInside)).isBisectArcPin()) {
            contactsOnEndObject = false;
        }
        if (startRE == null) {
            if (startObj != this.badStartObject) {
                System.out.println("  Can't route from " + startObj + ", no ports");
            }
            this.badStartObject = startObj;
            return route;
        }
        if (endObj != null) {
            if (endObj instanceof PortInst) {
                existingEndPort = (PortInst)endObj;
                endRE = RouteElementPort.existingPortInst(existingEndPort, endPoly);
            }
            if (endObj instanceof ArcInst && (endRE = this.findArcConnectingPoint(route, (ArcInst)endObj, endPoint, stayInside)).isBisectArcPin()) {
                contactsOnEndObject = true;
            }
            if (endRE == null) {
                if (endObj != this.badEndObject) {
                    System.out.println("  Can't route to " + endObj + ", no ports");
                }
                this.badEndObject = endObj;
                endObj = null;
            }
        }
        if (endObj == null) {
            ArcProto useArc = null;
            if (startObj instanceof PortInst) {
                PortInst startPi = (PortInst)startObj;
                useArc = InteractiveRouter.getArcToUse(startPi.getPortProto(), null);
            }
            if (startObj instanceof ArcInst) {
                ArcInst startAi = (ArcInst)startObj;
                useArc = startAi.getProto();
            }
            PrimitiveNode pn = useArc.findOverridablePinProto(ep);
            SizeOffset so = pn.getProtoSizeOffset();
            endRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), endPoint, pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset(), pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset());
        }
        if (startRE.isBisectArcPin()) {
            contactsOnEndObject = false;
        }
        if (endRE != null && endRE.isBisectArcPin()) {
            contactsOnEndObject = true;
        }
        if (existingEndPort != null && existingEndPort == existingStartPort) {
            return new Route();
        }
        Point2D cornerLoc = InteractiveRouter.getCornerLocation(startPoint, endPoint, clicked, startArc, endArc, contactsOnEndObject, stayInside, contactArea, startPolyFull, endPolyFull, ep);
        int startAngle = GenMath.figureAngle(startPoint, cornerLoc);
        int endAngle = GenMath.figureAngle(endPoint, cornerLoc);
        Router.ContactSize sizer = new Router.ContactSize(startObj, endObj, startPoint, endPoint, cornerLoc, startArc, endArc, false);
        contactArea = sizer.getContactSize();
        startAngle = sizer.getStartAngle();
        endAngle = sizer.getEndAngle();
        startArcWidth = sizer.getStartWidth();
        endArcWidth = sizer.getEndWidth();
        route.add(startRE);
        route.setStart(startRE);
        route.add(endRE);
        route.setEnd(endRE);
        if (startArc != endArc) {
            Dimension2D.Double contactSize = new Dimension2D.Double(contactArea.getWidth(), contactArea.getHeight());
            Route vertRoute = vroute.buildRoute(cell, cornerLoc, contactSize, startAngle, stayInside);
            for (RouteElement re : vertRoute) {
                if (route.contains(re)) continue;
                route.add(re);
            }
            if (route.replacePin(startRE, vertRoute.getStart(), stayInside)) {
                route.remove(startRE);
                if (route.getStart() == startRE) {
                    route.setStart(vertRoute.getStart());
                }
            } else {
                InteractiveRouter.addConnectingArc(route, cell, startRE, vertRoute.getStart(), startPoint, cornerLoc, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside);
            }
            if (route.replacePin(endRE, vertRoute.getEnd(), stayInside)) {
                route.remove(endRE);
                if (route.getEnd() == endRE) {
                    route.setEnd(vertRoute.getEnd());
                }
            } else {
                InteractiveRouter.addConnectingArc(route, cell, endRE, vertRoute.getEnd(), endPoint, cornerLoc, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside);
            }
        } else {
            if (route.replaceBisectPin(startRE, endRE)) {
                route.remove(startRE);
                return route;
            }
            if (route.replaceBisectPin(endRE, startRE)) {
                route.remove(endRE);
                route.setEnd(startRE);
                return route;
            }
            if (startArc.getAngleIncrement(ep) == 0 || DBMath.figureAngle(startPoint, endPoint) % (10 * startArc.getAngleIncrement(ep)) == 0) {
                InteractiveRouter.addConnectingArc(route, cell, startRE, endRE, startPoint, endPoint, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside);
            } else {
                PrimitiveNode pn = startArc.findOverridablePinProto(ep);
                SizeOffset so = pn.getProtoSizeOffset();
                double defwidth = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
                double defheight = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
                RouteElementPort pinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), cornerLoc, defwidth, defheight);
                route.add(pinRE);
                InteractiveRouter.addConnectingArc(route, cell, startRE, pinRE, startPoint, cornerLoc, startArc, startArcWidth, startAngle, extendArcHead, extendArcTail, stayInside);
                InteractiveRouter.addConnectingArc(route, cell, endRE, pinRE, endPoint, cornerLoc, endArc, endArcWidth, endAngle, extendArcHead, extendArcTail, stayInside);
            }
        }
        return route;
    }

    protected static ElectricObject filterRouteObject(ElectricObject routeObj, Point2D clicked) {
        if (routeObj instanceof NodeInst) {
            return ((NodeInst)routeObj).findClosestPortInst(clicked);
        }
        if (routeObj instanceof Export) {
            Export exp = (Export)routeObj;
            return exp.getOriginalPort();
        }
        return routeObj;
    }

    protected static PortProto getRoutePort(ElectricObject routeObj) {
        assert (!(routeObj instanceof NodeInst));
        if (routeObj instanceof ArcInst) {
            ArcInst ai = (ArcInst)routeObj;
            EditingPreferences ep = ai.getEditingPreferences();
            PrimitiveNode pn = ai.getProto().findOverridablePinProto(ep);
            return pn.getPort(0);
        }
        if (routeObj instanceof PortInst) {
            PortInst pi = (PortInst)routeObj;
            return pi.getPortProto();
        }
        return null;
    }

    protected static void getConnectingPoints(ElectricObject startObj, ElectricObject endObj, Point2D clicked, Point2D startPoint, Point2D endPoint, Poly startPoly, Poly endPoly, ArcProto startArc, ArcProto endArc) {
        Point2D[] points2;
        Point2D[] points1;
        Point2D intersection;
        boolean overlapY;
        double upperBoundX;
        double lowerBoundX;
        if (startPoly.getBox() == null && startPoly.getPoints().length != 2 || endPoly != null && endPoly.getBox() == null && endPoly.getPoints().length != 2) {
            startPoint.setLocation(startPoly.closestPoint(clicked));
            if (endPoly == null) {
                endPoint.setLocation(InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked));
            } else {
                endPoint.setLocation(endPoly.closestPoint(clicked));
            }
            return;
        }
        Rectangle2D startBounds = startPoly.getBounds2D();
        startPoint.setLocation(startBounds.getCenterX(), startBounds.getCenterY());
        if (startObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(startBounds.getMinX(), startBounds.getMaxX(), clicked.getX());
            double y = InteractiveRouter.getClosestValue(startBounds.getMinY(), startBounds.getMaxY(), clicked.getY());
            startPoint.setLocation(x, y);
        }
        if (endPoly == null) {
            EditingPreferences ep = startObj.getEditingPreferences();
            int angleIncrement = endArc.getAngleIncrement(ep);
            endPoint.setLocation(InteractiveRouter.getClosestAngledPoint(startPoint, clicked, angleIncrement));
            if (startArc.getTechnology() == Artwork.tech()) {
                endPoint.setLocation(clicked);
            }
            return;
        }
        Rectangle2D endBounds = endPoly.getBounds2D();
        endPoint.setLocation(endBounds.getCenterX(), endBounds.getCenterY());
        if (endObj instanceof ArcInst) {
            double x = InteractiveRouter.getClosestValue(endBounds.getMinX(), endBounds.getMaxX(), clicked.getX());
            double y = InteractiveRouter.getClosestValue(endBounds.getMinY(), endBounds.getMaxY(), clicked.getY());
            endPoint.setLocation(x, y);
        }
        boolean overlapX = (lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()));
        double lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
        double upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
        boolean bl = overlapY = lowerBoundY <= upperBoundY;
        if (ClickZoomWireListener.theOne.getUseFatWiringMode()) {
            Rectangle2D startObjBounds = InteractiveRouter.getBounds(startObj);
            Rectangle2D endObjBounds = InteractiveRouter.getBounds(endObj);
            boolean objsOverlap = false;
            if (startObjBounds != null && endObjBounds != null && startArc == endArc && startObjBounds.intersects(endObjBounds)) {
                objsOverlap = true;
            }
            if (!objsOverlap || !overlapX) {
                if (startObj instanceof PortInst) {
                    startBounds.setRect(startBounds.getCenterX(), startBounds.getY(), 0.0, startBounds.getHeight());
                }
                if (endObj instanceof PortInst) {
                    endBounds.setRect(endBounds.getCenterX(), endBounds.getY(), 0.0, endBounds.getHeight());
                }
            }
            if (!objsOverlap || !overlapY) {
                if (startObj instanceof PortInst) {
                    startBounds.setRect(startBounds.getX(), startBounds.getCenterY(), startBounds.getWidth(), 0.0);
                }
                if (endObj instanceof PortInst) {
                    endBounds.setRect(endBounds.getX(), endBounds.getCenterY(), endBounds.getWidth(), 0.0);
                }
            }
            overlapX = (lowerBoundX = Math.max(startBounds.getMinX(), endBounds.getMinX())) <= (upperBoundX = Math.min(startBounds.getMaxX(), endBounds.getMaxX()));
            lowerBoundY = Math.max(startBounds.getMinY(), endBounds.getMinY());
            upperBoundY = Math.min(startBounds.getMaxY(), endBounds.getMaxY());
            boolean bl2 = overlapY = lowerBoundY <= upperBoundY;
        }
        if (startPoly.getPoints().length == 2 && endPoly.getPoints().length == 2 && (intersection = InteractiveRouter.getIntersection(new Line2D.Double((points1 = startPoly.getPoints())[0], points1[1]), new Line2D.Double((points2 = endPoly.getPoints())[0], points2[1]))) != null) {
            if (Job.getDebug()) {
                System.out.println("===========================================================");
                System.out.println("Start Poly: " + points1[0] + ", " + points1[1]);
                System.out.println("End Poly: " + points2[0] + ", " + points2[1]);
                System.out.println("Intersection Point: " + intersection);
                System.out.println("===========================================================");
            }
            startPoint.setLocation(intersection);
            endPoint.setLocation(intersection);
            return;
        }
        if (lowerBoundX <= upperBoundX) {
            double x = InteractiveRouter.getClosestValue(lowerBoundX, upperBoundX, clicked.getX());
            startPoint.setLocation(x, startPoint.getY());
            endPoint.setLocation(x, endPoint.getY());
        } else if (startBounds.getMinX() > endBounds.getMaxX()) {
            startPoint.setLocation(startBounds.getMinX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMaxX(), endPoint.getY());
        } else {
            startPoint.setLocation(startBounds.getMaxX(), startPoint.getY());
            endPoint.setLocation(endBounds.getMinX(), endPoint.getY());
        }
        if (lowerBoundY <= upperBoundY) {
            double y = InteractiveRouter.getClosestValue(lowerBoundY, upperBoundY, clicked.getY());
            startPoint.setLocation(startPoint.getX(), y);
            endPoint.setLocation(endPoint.getX(), y);
        } else if (startBounds.getMinY() > endBounds.getMaxY()) {
            startPoint.setLocation(startPoint.getX(), startBounds.getMinY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMaxY());
        } else {
            startPoint.setLocation(startPoint.getX(), startBounds.getMaxY());
            endPoint.setLocation(endPoint.getX(), endBounds.getMinY());
        }
    }

    public static Point2D getIntersection(Line2D line1, Line2D line2) {
        if (!line1.intersectsLine(line2)) {
            return null;
        }
        double[] co1 = InteractiveRouter.getLineCoeffs(line1);
        double[] co2 = InteractiveRouter.getLineCoeffs(line2);
        double det = co1[0] * co2[1] - co2[0] * co1[1];
        double x = (co2[1] * co1[2] - co1[1] * co2[2]) / det;
        double y = (co1[0] * co2[2] - co2[0] * co1[2]) / det;
        return new Point2D.Double(x, y);
    }

    private static double[] getLineCoeffs(Line2D line) {
        double A = line.getP2().getY() - line.getP1().getY();
        double B = line.getP1().getX() - line.getP2().getX();
        double C = A * line.getP1().getX() + B * line.getP1().getY();
        return new double[]{A, B, C};
    }

    protected static Rectangle2D getBounds(ElectricObject obj) {
        NodeInst ni;
        NodeProto np;
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            return ai.getBounds();
        }
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            obj = pi.getNodeInst();
        }
        if (obj instanceof NodeInst && (np = (ni = (NodeInst)obj).getProto()) instanceof PrimitiveNode) {
            return ni.getBounds();
        }
        return null;
    }

    protected static Poly getConnectingSite(ElectricObject obj, Point2D clicked, double arcWidth) {
        PortInst pi;
        assert (clicked != null);
        if (obj instanceof NodeInst) {
            pi = ((NodeInst)obj).findClosestPortInst(clicked);
            if (pi == null) {
                return null;
            }
            obj = pi;
        }
        if (obj instanceof PortInst) {
            pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            PortProto pp = pi.getPortProto();
            boolean compressPort = false;
            if (!ni.isCellInstance()) {
                compressPort = true;
            }
            Poly poly = ni.getShapeOfPort(pp, clicked, compressPort, arcWidth);
            return poly;
        }
        if (obj instanceof ArcInst) {
            ArcInst arc = (ArcInst)obj;
            Point2D[] points = new Point2D[]{arc.getHeadLocation(), arc.getTailLocation()};
            Poly poly = new Poly(points);
            return poly;
        }
        return null;
    }

    protected static Rectangle2D getLayerArea(ElectricObject obj, Layer layer) {
        if (obj instanceof PortInst) {
            PortInst pi = (PortInst)obj;
            NodeInst ni = pi.getNodeInst();
            NodeProto np = ni.getProto();
            if (np instanceof Cell) {
                return null;
            }
            if (np instanceof PrimitiveNode) {
                PrimitiveNode pn = (PrimitiveNode)np;
                if (pn.getFunction() == PrimitiveNode.Function.PIN) {
                    Rectangle2D horiz = null;
                    Rectangle2D vert = null;
                    Iterator<Connection> it = pi.getConnections();
                    while (it.hasNext()) {
                        Connection conn = it.next();
                        ArcInst ai = conn.getArc();
                        if (ai.getProto().getLayerIterator().next() != layer) continue;
                        int angle = ai.getAngle();
                        if (angle % 1800 == 0) {
                            horiz = horiz == null ? ai.getBounds() : horiz.createUnion(ai.getBounds());
                        }
                        if ((angle + 900) % 1800 != 0) continue;
                        if (vert == null) {
                            vert = ai.getBounds();
                            continue;
                        }
                        vert = vert.createUnion(ai.getBounds());
                    }
                    return horiz.createIntersection(vert);
                }
                if (pn.getFunction() == PrimitiveNode.Function.CONTACT) {
                    Poly p = ni.getBaseShape();
                    return p.getBounds2D();
                }
            }
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            return ai.getBounds();
        }
        return null;
    }

    protected RouteElementPort findArcConnectingPoint(Route route, ArcInst arc, Point2D connectingPoint, PolyMerge stayInside) {
        EPoint head = arc.getHeadLocation();
        EPoint tail = arc.getTailLocation();
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail);
        if (head.equals(connectingPoint)) {
            return headRE;
        }
        if (tail.equals(connectingPoint)) {
            return tailRE;
        }
        return this.bisectArc(route, arc, connectingPoint, stayInside);
    }

    protected RouteElementPort bisectArc(Route route, ArcInst arc, Point2D bisectPoint, PolyMerge stayInside) {
        Cell cell = arc.getParent();
        EPoint head = arc.getHeadLocation();
        EPoint tail = arc.getTailLocation();
        EditingPreferences ep = cell.getEditingPreferences();
        PrimitiveNode pn = arc.getProto().findOverridablePinProto(ep);
        SizeOffset so = pn.getProtoSizeOffset();
        double width = pn.getDefWidth() - so.getHighXOffset() - so.getLowXOffset();
        double height = pn.getDefHeight() - so.getHighYOffset() - so.getLowYOffset();
        RouteElementPort newPinRE = RouteElementPort.newNode(cell, pn, pn.getPort(0), bisectPoint, width, height);
        newPinRE.setBisectArcPin(true);
        RouteElementPort headRE = RouteElementPort.existingPortInst(arc.getHeadPortInst(), head);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(arc.getTailPortInst(), tail);
        headRE.setShowHighlight(false);
        tailRE.setShowHighlight(false);
        String name1 = null;
        String name2 = null;
        String nameToUse = arc.getName();
        if (arc.getNameKey().isTempname()) {
            nameToUse = null;
        }
        if (head.distance(bisectPoint) > tail.distance(bisectPoint)) {
            name1 = nameToUse;
        } else {
            name2 = nameToUse;
        }
        RouteElementArc newHeadArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), headRE, newPinRE, head, bisectPoint, name1, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, arc.isHeadExtended(), arc.isTailExtended(), stayInside);
        RouteElementArc newTailArcRE = RouteElementArc.newArc(cell, arc.getProto(), arc.getLambdaBaseWidth(), newPinRE, tailRE, bisectPoint, tail, name2, arc.getTextDescriptor(ArcInst.ARC_NAME), arc, arc.isHeadExtended(), arc.isTailExtended(), stayInside);
        newHeadArcRE.setShowHighlight(false);
        newTailArcRE.setShowHighlight(false);
        RouteElementArc deleteArcRE = RouteElementArc.deleteArc(arc);
        route.add(deleteArcRE);
        route.add(headRE);
        route.add(tailRE);
        route.add(newHeadArcRE);
        route.add(newTailArcRE);
        return newPinRE;
    }

    protected static Point2D getCornerLocation(Point2D startLoc, Point2D endLoc, Point2D clicked, ArcProto startArc, ArcProto endArc, boolean contactsOnEndObj, PolyMerge stayInside, Rectangle2D contactArea, Poly startPolyFull, Poly endPolyFull, EditingPreferences ep) {
        boolean singleArc = false;
        if (startArc == endArc) {
            int inc = 10 * startArc.getAngleIncrement(ep);
            if (inc == 0) {
                singleArc = true;
            } else {
                int ang = GenMath.figureAngle(startLoc, endLoc);
                if (ang % inc == 0) {
                    singleArc = true;
                }
            }
        } else if (startLoc.getX() == endLoc.getX() || startLoc.getY() == endLoc.getY()) {
            singleArc = true;
        }
        if (singleArc) {
            if (contactsOnEndObj) {
                return new Point2D.Double(endLoc.getX(), endLoc.getY());
            }
            return new Point2D.Double(startLoc.getX(), startLoc.getY());
        }
        if (contactArea != null) {
            return new Point2D.Double(contactArea.getCenterX(), contactArea.getCenterY());
        }
        Point2D.Double cornerLoc = null;
        Point2D.Double pin1 = new Point2D.Double(startLoc.getX(), endLoc.getY());
        Point2D.Double pin2 = new Point2D.Double(endLoc.getX(), startLoc.getY());
        int clickedQuad = InteractiveRouter.findQuadrant(endLoc, clicked);
        int pin1Quad = InteractiveRouter.findQuadrant(endLoc, pin1);
        int pin2Quad = InteractiveRouter.findQuadrant(endLoc, pin2);
        int oppositeQuad = (clickedQuad + 2) % 4;
        cornerLoc = pin1;
        if (pin2Quad == clickedQuad) {
            cornerLoc = pin2;
        } else if (pin1Quad == clickedQuad) {
            cornerLoc = pin1;
        } else if (pin1Quad == oppositeQuad) {
            cornerLoc = pin2;
        }
        if (startPolyFull.intersects(endPolyFull)) {
            boolean usepin1 = false;
            boolean usepin2 = false;
            if (startPolyFull.contains(pin1) && endPolyFull.contains(pin1)) {
                usepin1 = true;
            }
            if (startPolyFull.contains(pin2) && endPolyFull.contains(pin2)) {
                usepin2 = true;
            }
            if (usepin1 && !usepin2) {
                cornerLoc = pin1;
            }
            if (usepin2 && !usepin1) {
                cornerLoc = pin2;
            }
        }
        ArcProto useArc = startArc;
        if (!contactsOnEndObj) {
            useArc = endArc;
        }
        if (stayInside != null && useArc != null) {
            double pinSize = useArc.getDefaultLambdaBaseWidth();
            Layer pinLayer = useArc.getLayerIterator().next();
            Rectangle2D.Double pin1Rect = new Rectangle2D.Double(((Point2D)pin1).getX() - pinSize / 2.0, ((Point2D)pin1).getY() - pinSize / 2.0, pinSize, pinSize);
            Rectangle2D.Double pin2Rect = new Rectangle2D.Double(((Point2D)pin2).getX() - pinSize / 2.0, ((Point2D)pin2).getY() - pinSize / 2.0, pinSize, pinSize);
            if (stayInside.contains(pinLayer, pin1Rect)) {
                cornerLoc = pin1;
            } else if (stayInside.contains(pinLayer, pin2Rect)) {
                cornerLoc = pin2;
            }
        }
        return cornerLoc;
    }

    protected static void updateContactArea(Rectangle2D contactArea, RouteElementPort re, Point2D cornerLoc, double arcWidth, int arcAngle) {
        if (arcAngle % 1800 == 0 && contactArea.getHeight() < arcWidth) {
            contactArea.setRect(contactArea.getX(), contactArea.getCenterY() - arcWidth / 2.0, contactArea.getWidth(), arcWidth);
        }
        if ((arcAngle + 900) % 1800 == 0 && contactArea.getWidth() < arcWidth) {
            contactArea.setRect(contactArea.getCenterX() - arcWidth / 2.0, contactArea.getY(), arcWidth, contactArea.getHeight());
        }
    }

    protected static void addConnectingArc(Route route, Cell cell, RouteElementPort startRE, RouteElementPort endRE, Point2D startPoint, Point2D endPoint, ArcProto arc, double width, int arcAngle, boolean extendArcHead, boolean extendArcTail, PolyMerge stayInside) {
        if (extendArcHead) {
            extendArcHead = InteractiveRouter.getExtendArcEnd(startRE, width, arc, arcAngle, extendArcHead);
        }
        if (extendArcTail) {
            extendArcTail = InteractiveRouter.getExtendArcEnd(endRE, width, arc, arcAngle, extendArcTail);
        }
        RouteElementArc reArc = RouteElementArc.newArc(cell, arc, width, startRE, endRE, startPoint, endPoint, null, null, null, extendArcHead, extendArcTail, stayInside);
        reArc.setArcAngle(arcAngle);
        route.add(reArc);
    }

    protected static boolean getExtendArcEnd(RouteElementPort re, double arcWidth, ArcProto arc, int arcAngle, boolean defExtends) {
        PrimitiveNode pn;
        NodeProto np = re.getNodeProto();
        if (np == null) {
            return defExtends;
        }
        if (np instanceof PrimitiveNode && (pn = (PrimitiveNode)np).getFunction() == PrimitiveNode.Function.CONTACT) {
            Dimension2D.Double size = re.getNodeSize();
            if (arcAngle % 1800 == 0 && arcWidth > ((Dimension2D)size).getHeight()) {
                return false;
            }
            if ((arcAngle + 900) % 1800 == 0 && arcWidth > ((Dimension2D)size).getWidth()) {
                return false;
            }
        }
        return defExtends;
    }

    protected static double getClosestValue(double min, double max, double clicked) {
        if (clicked >= max) {
            return max;
        }
        if (clicked <= min) {
            return min;
        }
        return clicked;
    }

    protected static Point2D getClosestOrthogonalPoint(Point2D startPoint, Point2D clicked) {
        Point2D.Double newPoint = Math.abs(startPoint.getX() - clicked.getX()) < Math.abs(startPoint.getY() - clicked.getY()) ? new Point2D.Double(startPoint.getX(), clicked.getY()) : new Point2D.Double(clicked.getX(), startPoint.getY());
        return newPoint;
    }

    public static Point2D getClosestAngledPoint(Point2D startPoint, Point2D clicked, int angleIncrement) {
        double yfinal;
        double xfinal;
        if ((angleIncrement = Math.abs(angleIncrement)) == 0) {
            return clicked;
        }
        if (angleIncrement == 90) {
            return InteractiveRouter.getClosestOrthogonalPoint(startPoint, clicked);
        }
        double angleInc = (double)angleIncrement * Math.PI / 180.0;
        double x = clicked.getX() - startPoint.getX();
        double y = clicked.getY() - startPoint.getY();
        double angle = Math.atan2(y, x);
        double nearest1 = (double)((int)(angle / angleInc)) * angleInc;
        double nearest2 = angle < 0.0 ? nearest1 - angleInc : nearest1 + angleInc;
        double tan1 = Math.tan(nearest1);
        if (tan1 == 0.0) {
            tan1 = 1.0E-6;
        }
        Point2D.Double n1_1 = new Point2D.Double(x, x * tan1);
        Point2D.Double n1_2 = new Point2D.Double(y / tan1, y);
        Point2D.Double n1 = n1_1.distance(x, y) < n1_2.distance(x, y) ? n1_1 : n1_2;
        double tan2 = Math.tan(nearest2);
        if (tan2 == 0.0) {
            tan2 = 1.0E-6;
        }
        Point2D.Double n2_1 = new Point2D.Double(x, x * tan2);
        Point2D.Double n2_2 = new Point2D.Double(y / tan2, y);
        Point2D.Double n2 = n2_1.distance(x, y) < n2_2.distance(x, y) ? n2_1 : n2_2;
        if (n2.distance(x, y) < n1.distance(x, y)) {
            xfinal = DBMath.round(((Point2D)n2).getX() + startPoint.getX());
            yfinal = DBMath.round(((Point2D)n2).getY() + startPoint.getY());
        } else {
            xfinal = DBMath.round(((Point2D)n1).getX() + startPoint.getX());
            yfinal = DBMath.round(((Point2D)n1).getY() + startPoint.getY());
        }
        return new Point2D.Double(xfinal, yfinal);
    }

    protected boolean withinBounds(double point, double bound1, double bound2) {
        double max;
        double min;
        if (bound1 < bound2) {
            min = bound1;
            max = bound2;
        } else {
            min = bound2;
            max = bound1;
        }
        return point >= min && point <= max;
    }

    protected boolean onSegment(Point2D point, Line2D line) {
        double maxY;
        double minY;
        double maxX;
        double minX;
        Point2D head = line.getP1();
        Point2D tail = line.getP2();
        if (head.getX() < tail.getX()) {
            minX = head.getX();
            maxX = tail.getX();
        } else {
            minX = tail.getX();
            maxX = head.getX();
        }
        if (head.getY() < tail.getY()) {
            minY = head.getY();
            maxY = tail.getY();
        } else {
            minY = tail.getY();
            maxY = head.getY();
        }
        return point.getX() >= minX && point.getX() <= maxX && point.getY() >= minY && point.getY() <= maxY;
    }

    protected static int findQuadrant(Point2D refPoint, Point2D pt) {
        double angle = Math.atan((pt.getY() - refPoint.getY()) / (pt.getX() - refPoint.getX()));
        if (pt.getX() < refPoint.getX()) {
            angle += Math.PI;
        }
        if (angle > -0.7853981633974483 && angle <= 0.7853981633974483) {
            return 0;
        }
        if (angle > 0.7853981633974483 && angle <= 2.356194490192345) {
            return 1;
        }
        if (angle > 2.356194490192345 && angle <= 3.9269908169872414) {
            return 2;
        }
        return 3;
    }

    private static class MakeVerticalRouteJob
    extends Router.CreateRouteJob {
        protected MakeVerticalRouteJob(Router router, Route route, Cell cell, boolean verbose) {
            super(router.toString(), route, cell, verbose, Routing.getRoutingTool());
        }

        public boolean doIt() throws JobException {
            PortInst pi;
            NodeInst ni;
            if (!super.doIt()) {
                return false;
            }
            RouteElementPort startRE = this.route.getStart();
            if (startRE.getAction() == RouteElement.RouteElementAction.existingPortInst && (ni = (pi = startRE.getPortInst()).getNodeInst()).getProto().getFunction() == PrimitiveNode.Function.PIN) {
                CircuitChangeJobs.Reconnect re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true);
                if (re != null) {
                    re.reconnectArcs();
                }
                if (!ni.hasExports()) {
                    ni.kill();
                }
            }
            return true;
        }
    }
}

