/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SpiceTab
extends PreferencePanel {
    private JPanel epicFrame;
    private JLabel epicLabel;
    private JTextField epicText;
    private JPanel execution;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel13;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JPanel modelCards;
    private JCheckBox overwriteOutputFile;
    private JPanel readingOutput;
    private JPanel spice;
    private JButton spiceBrowseHeaderFile;
    private JButton spiceBrowseTrailerFile;
    private JComboBox spiceEnginePopup;
    private JComboBox spiceGlobalTreatment;
    private ButtonGroup spiceHeader;
    private JTextField spiceHeaderCardExtension;
    private JTextField spiceHeaderCardFile;
    private JRadioButton spiceHeaderCardsFromFile;
    private JRadioButton spiceHeaderCardsWithExtension;
    private JComboBox spiceLevelPopup;
    private JTextField spiceNetworkDelimiter;
    private JRadioButton spiceNoHeaderCards;
    private JRadioButton spiceNoTrailerCards;
    private JComboBox spiceOutputFormatPopup;
    private JComboBox spiceParasitics;
    private JComboBox spicePrimitivesetPopup;
    private JComboBox spiceResistorShorting;
    private JButton spiceRunHelp;
    private JComboBox spiceRunPopup;
    private JCheckBox spiceRunProbe;
    private JTextField spiceRunProgram;
    private JTextField spiceRunProgramArgs;
    private ButtonGroup spiceTrailer;
    private JTextField spiceTrailerCardExtension;
    private JTextField spiceTrailerCardFile;
    private JRadioButton spiceTrailerCardsFromFile;
    private JRadioButton spiceTrailerCardsWithExtension;
    private JCheckBox spiceUseCellParameters;
    private JCheckBox spiceWriteEndStatement;
    private JCheckBox spiceWritePwrGndSubcircuit;
    private JCheckBox spiceWriteSubcktTopCell;
    private JCheckBox spiceWriteTransSizesInLambda;
    private JPanel upperLeft;
    private JPanel upperRight;
    private JTextField useDir;
    private JCheckBox useDirCheckBox;
    private JPanel writingSpice;

    public SpiceTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        EDialog.makeTextFieldSelectAllOnTab(this.epicText);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceRunProgram);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceRunProgramArgs);
        EDialog.makeTextFieldSelectAllOnTab(this.useDir);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceHeaderCardExtension);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceHeaderCardFile);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceTrailerCardExtension);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceTrailerCardFile);
        EDialog.makeTextFieldSelectAllOnTab(this.spiceNetworkDelimiter);
    }

    public JPanel getPanel() {
        return this.spice;
    }

    public String getName() {
        return "Spice";
    }

    public void init() {
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_2);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_3);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_H);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_P);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_G);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_S);
        this.spiceEnginePopup.addItem(Simulation.SpiceEngine.SPICE_ENGINE_H_ASSURA);
        this.spiceEnginePopup.setSelectedItem((Object)Simulation.getSpiceEngine());
        this.spiceLevelPopup.addItem("1");
        this.spiceLevelPopup.addItem("2");
        this.spiceLevelPopup.addItem("3");
        this.spiceLevelPopup.setSelectedItem(Simulation.getSpiceLevel());
        this.spiceResistorShorting.addItem("None");
        this.spiceResistorShorting.addItem("Normal only");
        this.spiceResistorShorting.addItem("Normal and Poly");
        this.spiceResistorShorting.setSelectedIndex(Simulation.getSpiceShortResistors());
        this.spiceParasitics.addItem(Simulation.SpiceParasitics.SIMPLE);
        this.spiceParasitics.addItem(Simulation.SpiceParasitics.RC_CONSERVATIVE);
        this.spiceParasitics.setSelectedItem((Object)Simulation.getSpiceParasiticsLevel());
        this.spiceGlobalTreatment.addItem("No special treatment");
        this.spiceGlobalTreatment.addItem("Use .GLOBAL block");
        this.spiceGlobalTreatment.addItem("Create .SUBCKT ports");
        this.spiceGlobalTreatment.setSelectedIndex(Simulation.getSpiceGlobalTreatment().getCode());
        String[] libFiles = LibFile.getSpicePartsLibraries();
        for (int i = 0; i < libFiles.length; ++i) {
            this.spicePrimitivesetPopup.addItem(libFiles[i]);
        }
        this.spicePrimitivesetPopup.setSelectedItem(Simulation.getSpicePartsLibrary());
        this.spiceWritePwrGndSubcircuit.setSelected(Simulation.isSpiceWritePwrGndInTopCell());
        this.spiceUseCellParameters.setSelected(Simulation.isSpiceUseCellParameters());
        this.spiceWriteTransSizesInLambda.setSelected(Simulation.isSpiceWriteTransSizeInLambda());
        this.spiceWriteSubcktTopCell.setSelected(Simulation.isSpiceWriteSubcktTopCell());
        this.spiceWriteEndStatement.setSelected(Simulation.isSpiceWriteFinalDotEnd());
        String spiceHeaderCardInitial = Simulation.getSpiceHeaderCardInfo();
        boolean noHeader = false;
        if (spiceHeaderCardInitial.startsWith("N O N E ")) {
            noHeader = true;
            spiceHeaderCardInitial = spiceHeaderCardInitial.substring("N O N E ".length());
        }
        if (spiceHeaderCardInitial.length() == 0) {
            noHeader = true;
        }
        if (spiceHeaderCardInitial.startsWith("Extension ")) {
            this.spiceHeaderCardsWithExtension.setSelected(true);
            this.spiceHeaderCardExtension.setText(spiceHeaderCardInitial.substring("Extension ".length()));
        } else {
            this.spiceHeaderCardsFromFile.setSelected(true);
            this.spiceHeaderCardFile.setText(spiceHeaderCardInitial);
        }
        if (noHeader) {
            this.spiceNoHeaderCards.setSelected(true);
        }
        String spiceTrailerCardInitial = Simulation.getSpiceTrailerCardInfo();
        boolean noTrailer = false;
        if (spiceTrailerCardInitial.startsWith("N O N E ")) {
            noTrailer = true;
            spiceTrailerCardInitial = spiceTrailerCardInitial.substring("N O N E ".length());
        }
        if (spiceTrailerCardInitial.length() == 0) {
            noTrailer = true;
        }
        if (spiceTrailerCardInitial.startsWith("Extension ")) {
            this.spiceTrailerCardsWithExtension.setSelected(true);
            this.spiceTrailerCardExtension.setText(spiceTrailerCardInitial.substring("Extension ".length()));
        } else {
            this.spiceTrailerCardsFromFile.setSelected(true);
            this.spiceTrailerCardFile.setText(spiceTrailerCardInitial);
        }
        if (noTrailer) {
            this.spiceNoTrailerCards.setSelected(true);
        }
        this.spiceBrowseHeaderFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseHeaderFileActionPerformed();
            }
        });
        this.spiceBrowseTrailerFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceBrowseTrailerFileActionPerformed();
            }
        });
        this.useDir.setText(Simulation.getSpiceRunDir());
        this.useDirCheckBox.setSelected(Simulation.getSpiceUseRunDir());
        this.overwriteOutputFile.setSelected(Simulation.getSpiceOutputOverwrite());
        this.spiceRunProbe.setSelected(Simulation.getSpiceRunProbe());
        this.spiceRunProgram.setText(Simulation.getSpiceRunProgram());
        this.spiceRunProgramArgs.setText(Simulation.getSpiceRunProgramArgs());
        String[] runChoices = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < runChoices.length; ++i) {
            this.spiceRunPopup.addItem(runChoices[i]);
        }
        this.spiceRunPopup.setSelectedItem(Simulation.getSpiceRunChoice());
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.Standard);
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.Raw);
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.RawSmart);
        this.spiceOutputFormatPopup.addItem(SpiceOutFormat.Epic);
        this.spiceOutputFormatPopup.setSelectedItem((Object)SpiceOutFormat.valueOf(Simulation.getSpiceOutputFormat()));
        this.epicText.setText(String.valueOf(Simulation.getSpiceEpicMemorySize()));
        this.spiceNetworkDelimiter.setText(Simulation.getSpiceExtractedNetDelimiter());
    }

    private void spiceBrowseTrailerFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceTrailerCardFile.setText(fileName);
        this.spiceTrailerCardsFromFile.setSelected(true);
    }

    private void spiceBrowseHeaderFileActionPerformed() {
        String fileName = OpenFile.chooseInputFile(FileType.ANY, null);
        if (fileName == null) {
            return;
        }
        this.spiceHeaderCardFile.setText(fileName);
        this.spiceHeaderCardsFromFile.setSelected(true);
    }

    public void term() {
        int sr;
        Simulation.SpiceEngine engine = (Simulation.SpiceEngine)((Object)this.spiceEnginePopup.getSelectedItem());
        if (Simulation.getSpiceEngine() != engine) {
            Simulation.setSpiceEngine(engine);
        }
        String stringNow = (String)this.spiceLevelPopup.getSelectedItem();
        if (!Simulation.getSpiceLevel().equals(stringNow)) {
            Simulation.setSpiceLevel(stringNow);
        }
        if ((sr = this.spiceResistorShorting.getSelectedIndex()) != Simulation.getSpiceShortResistors()) {
            Simulation.setSpiceShortResistors(sr);
        }
        Simulation.SpiceParasitics sp = (Simulation.SpiceParasitics)((Object)this.spiceParasitics.getSelectedItem());
        if (Simulation.getSpiceParasiticsLevel() != sp) {
            Simulation.setSpiceParasiticsLevel(sp);
        }
        Simulation.SpiceGlobal signal = Simulation.SpiceGlobal.find(this.spiceGlobalTreatment.getSelectedIndex());
        if (Simulation.getSpiceGlobalTreatment() != signal) {
            Simulation.setSpiceGlobalTreatment(signal);
        }
        stringNow = (String)this.spicePrimitivesetPopup.getSelectedItem();
        if (!Simulation.getSpicePartsLibrary().equals(stringNow)) {
            Simulation.setSpicePartsLibrary(stringNow);
        }
        boolean booleanNow = this.spiceWritePwrGndSubcircuit.isSelected();
        if (Simulation.isSpiceWritePwrGndInTopCell() != booleanNow) {
            Simulation.setSpiceWritePwrGndInTopCell(booleanNow);
        }
        booleanNow = this.spiceUseCellParameters.isSelected();
        if (Simulation.isSpiceUseCellParameters() != booleanNow) {
            Simulation.setSpiceUseCellParameters(booleanNow);
        }
        booleanNow = this.spiceWriteTransSizesInLambda.isSelected();
        if (Simulation.isSpiceWriteTransSizeInLambda() != booleanNow) {
            Simulation.setSpiceWriteTransSizeInLambda(booleanNow);
        }
        booleanNow = this.spiceWriteSubcktTopCell.isSelected();
        if (Simulation.isSpiceWriteSubcktTopCell() != booleanNow) {
            Simulation.setSpiceWriteSubcktTopCell(booleanNow);
        }
        booleanNow = this.spiceWriteEndStatement.isSelected();
        if (Simulation.isSpiceWriteFinalDotEnd() != booleanNow) {
            Simulation.setSpiceWriteFinalDotEnd(booleanNow);
        }
        String header = "N O N E ";
        header = this.spiceHeaderCardExtension.getText().length() > 0 ? header + "Extension " + this.spiceHeaderCardExtension.getText() : header + this.spiceHeaderCardFile.getText();
        if (this.spiceHeaderCardsWithExtension.isSelected()) {
            header = "Extension " + this.spiceHeaderCardExtension.getText();
        } else if (this.spiceHeaderCardsFromFile.isSelected()) {
            header = this.spiceHeaderCardFile.getText();
        }
        if (!Simulation.getSpiceHeaderCardInfo().equals(header)) {
            Simulation.setSpiceHeaderCardInfo(header);
        }
        String trailer = "N O N E ";
        trailer = this.spiceTrailerCardExtension.getText().length() > 0 ? trailer + "Extension " + this.spiceTrailerCardExtension.getText() : trailer + this.spiceTrailerCardFile.getText();
        if (this.spiceTrailerCardsWithExtension.isSelected()) {
            trailer = "Extension " + this.spiceTrailerCardExtension.getText();
        } else if (this.spiceTrailerCardsFromFile.isSelected()) {
            trailer = this.spiceTrailerCardFile.getText();
        }
        if (!Simulation.getSpiceTrailerCardInfo().equals(trailer)) {
            Simulation.setSpiceTrailerCardInfo(trailer);
        }
        stringNow = (String)this.spiceRunPopup.getSelectedItem();
        if (!Simulation.getSpiceRunChoice().equals(stringNow)) {
            Simulation.setSpiceRunChoice(stringNow);
        }
        stringNow = this.useDir.getText();
        if (!Simulation.getSpiceRunDir().equals(stringNow)) {
            Simulation.setSpiceRunDir(stringNow);
        }
        booleanNow = this.useDirCheckBox.isSelected();
        if (Simulation.getSpiceUseRunDir() != booleanNow) {
            Simulation.setSpiceUseRunDir(booleanNow);
        }
        booleanNow = this.overwriteOutputFile.isSelected();
        if (Simulation.getSpiceOutputOverwrite() != booleanNow) {
            Simulation.setSpiceOutputOverwrite(booleanNow);
        }
        booleanNow = this.spiceRunProbe.isSelected();
        if (Simulation.getSpiceRunProbe() != booleanNow) {
            Simulation.setSpiceRunProbe(booleanNow);
        }
        stringNow = this.spiceRunProgram.getText();
        if (!Simulation.getSpiceRunProgram().equals(stringNow)) {
            Simulation.setSpiceRunProgram(stringNow);
        }
        stringNow = this.spiceRunProgramArgs.getText();
        if (!Simulation.getSpiceRunProgramArgs().equals(stringNow)) {
            Simulation.setSpiceRunProgramArgs(stringNow);
        }
        SpiceOutFormat formatVal = (SpiceOutFormat)((Object)this.spiceOutputFormatPopup.getSelectedItem());
        if (!Simulation.getSpiceOutputFormat().equals((Object)formatVal)) {
            Simulation.setSpiceOutputFormat(formatVal.name());
        }
        if (formatVal == SpiceOutFormat.Epic) {
            Simulation.setSpiceEpicMemorySize(TextUtils.atoi(this.epicText.getText()));
        }
        stringNow = this.spiceNetworkDelimiter.getText();
        if (!Simulation.getSpiceExtractedNetDelimiter().equals(stringNow)) {
            Simulation.setSpiceExtractedNetDelimiter(stringNow);
        }
    }

    public void reset() {
        if (!Simulation.getFactorySpiceEngine().equals((Object)Simulation.getSpiceEngine())) {
            Simulation.setSpiceEngine(Simulation.getFactorySpiceEngine());
        }
        if (!Simulation.getFactorySpiceLevel().equals(Simulation.getSpiceLevel())) {
            Simulation.setSpiceLevel(Simulation.getFactorySpiceLevel());
        }
        if (Simulation.getFactorySpiceShortResistors() != Simulation.getSpiceShortResistors()) {
            Simulation.setSpiceShortResistors(Simulation.getFactorySpiceShortResistors());
        }
        if (!Simulation.getFactorySpiceParasiticsLevel().equals((Object)Simulation.getSpiceParasiticsLevel())) {
            Simulation.setSpiceParasiticsLevel(Simulation.getFactorySpiceParasiticsLevel());
        }
        if (Simulation.getFactorySpiceGlobalTreatment() != Simulation.getSpiceGlobalTreatment()) {
            Simulation.setSpiceGlobalTreatment(Simulation.getFactorySpiceGlobalTreatment());
        }
        if (!Simulation.getFactorySpicePartsLibrary().equals(Simulation.getSpicePartsLibrary())) {
            Simulation.setSpicePartsLibrary(Simulation.getFactorySpicePartsLibrary());
        }
        if (Simulation.isFactorySpiceWritePwrGndInTopCell() != Simulation.isSpiceWritePwrGndInTopCell()) {
            Simulation.setSpiceWritePwrGndInTopCell(Simulation.isFactorySpiceWritePwrGndInTopCell());
        }
        if (Simulation.isFactorySpiceUseCellParameters() != Simulation.isSpiceUseCellParameters()) {
            Simulation.setSpiceUseCellParameters(Simulation.isFactorySpiceUseCellParameters());
        }
        if (Simulation.isFactorySpiceWriteTransSizeInLambda() != Simulation.isSpiceWriteTransSizeInLambda()) {
            Simulation.setSpiceWriteTransSizeInLambda(Simulation.isFactorySpiceWriteTransSizeInLambda());
        }
        if (Simulation.isFactorySpiceWriteSubcktTopCell() != Simulation.isSpiceWriteSubcktTopCell()) {
            Simulation.setSpiceWriteSubcktTopCell(Simulation.isFactorySpiceWriteSubcktTopCell());
        }
        if (Simulation.isFactorySpiceWriteFinalDotEnd() != Simulation.isSpiceWriteFinalDotEnd()) {
            Simulation.setSpiceWriteFinalDotEnd(Simulation.isFactorySpiceWriteFinalDotEnd());
        }
        if (!Simulation.getFactorySpiceHeaderCardInfo().equals(Simulation.getSpiceHeaderCardInfo())) {
            Simulation.setSpiceHeaderCardInfo(Simulation.getFactorySpiceHeaderCardInfo());
        }
        if (!Simulation.getFactorySpiceTrailerCardInfo().equals(Simulation.getSpiceTrailerCardInfo())) {
            Simulation.setSpiceTrailerCardInfo(Simulation.getFactorySpiceTrailerCardInfo());
        }
        if (!Simulation.getFactorySpiceRunChoice().equals(Simulation.getSpiceRunChoice())) {
            Simulation.setSpiceRunChoice(Simulation.getFactorySpiceRunChoice());
        }
        if (!Simulation.getFactorySpiceRunProgram().equals(Simulation.getSpiceRunProgram())) {
            Simulation.setSpiceRunProgram(Simulation.getFactorySpiceRunProgram());
        }
        if (!Simulation.getFactorySpiceRunProgramArgs().equals(Simulation.getSpiceRunProgramArgs())) {
            Simulation.setSpiceRunProgramArgs(Simulation.getFactorySpiceRunProgramArgs());
        }
        if (Simulation.getFactorySpiceUseRunDir() != Simulation.getSpiceUseRunDir()) {
            Simulation.setSpiceUseRunDir(Simulation.getFactorySpiceUseRunDir());
        }
        if (!Simulation.getFactorySpiceRunDir().equals(Simulation.getSpiceRunDir())) {
            Simulation.setSpiceRunDir(Simulation.getFactorySpiceRunDir());
        }
        if (Simulation.getFactorySpiceOutputOverwrite() != Simulation.getSpiceOutputOverwrite()) {
            Simulation.setSpiceOutputOverwrite(Simulation.getFactorySpiceOutputOverwrite());
        }
        if (Simulation.getFactorySpiceRunProbe() != Simulation.getSpiceRunProbe()) {
            Simulation.setSpiceRunProbe(Simulation.getFactorySpiceRunProbe());
        }
        if (!Simulation.getFactorySpiceOutputFormat().equals(Simulation.getSpiceOutputFormat())) {
            Simulation.setSpiceOutputFormat(Simulation.getFactorySpiceOutputFormat());
        }
        if (Simulation.getFactorySpiceEpicMemorySize() != Simulation.getSpiceEpicMemorySize()) {
            Simulation.setSpiceEpicMemorySize(Simulation.getFactorySpiceEpicMemorySize());
        }
        if (Simulation.getFactorySpiceExtractedNetDelimiter() != Simulation.getSpiceExtractedNetDelimiter()) {
            Simulation.setSpiceExtractedNetDelimiter(Simulation.getFactorySpiceExtractedNetDelimiter());
        }
    }

    private void setSpiceRunOptionsEnabled(boolean enabled) {
        this.useDirCheckBox.setEnabled(enabled);
        this.overwriteOutputFile.setEnabled(enabled);
        this.spiceRunProgram.setEnabled(enabled);
        this.spiceRunProgramArgs.setEnabled(enabled);
        this.spiceRunHelp.setEnabled(enabled);
        this.spiceRunProbe.setEnabled(enabled);
        this.useDir.setEnabled(enabled);
        if (enabled && !this.useDirCheckBox.isSelected()) {
            this.useDir.setEnabled(false);
        }
    }

    private void initComponents() {
        this.spiceHeader = new ButtonGroup();
        this.spiceTrailer = new ButtonGroup();
        this.spice = new JPanel();
        this.readingOutput = new JPanel();
        this.jLabel10 = new JLabel();
        this.spiceOutputFormatPopup = new JComboBox();
        this.epicLabel = new JLabel();
        this.epicText = new JTextField();
        this.jLabel7 = new JLabel();
        this.spiceNetworkDelimiter = new JTextField();
        this.execution = new JPanel();
        this.spiceRunPopup = new JComboBox();
        this.spiceRunProgram = new JTextField();
        this.jLabel17 = new JLabel();
        this.useDirCheckBox = new JCheckBox();
        this.useDir = new JTextField();
        this.overwriteOutputFile = new JCheckBox();
        this.spiceRunHelp = new JButton();
        this.jLabel3 = new JLabel();
        this.spiceRunProgramArgs = new JTextField();
        this.spiceRunProbe = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.writingSpice = new JPanel();
        this.upperLeft = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel9 = new JLabel();
        this.spiceEnginePopup = new JComboBox();
        this.spiceLevelPopup = new JComboBox();
        this.jLabel13 = new JLabel();
        this.spicePrimitivesetPopup = new JComboBox();
        this.epicFrame = new JPanel();
        this.spiceResistorShorting = new JComboBox();
        this.jLabel4 = new JLabel();
        this.spiceParasitics = new JComboBox();
        this.jLabel6 = new JLabel();
        this.spiceGlobalTreatment = new JComboBox();
        this.upperRight = new JPanel();
        this.spiceWriteEndStatement = new JCheckBox();
        this.spiceWriteTransSizesInLambda = new JCheckBox();
        this.spiceUseCellParameters = new JCheckBox();
        this.spiceWriteSubcktTopCell = new JCheckBox();
        this.spiceWritePwrGndSubcircuit = new JCheckBox();
        this.modelCards = new JPanel();
        this.spiceHeaderCardExtension = new JTextField();
        this.spiceNoHeaderCards = new JRadioButton();
        this.spiceHeaderCardsWithExtension = new JRadioButton();
        this.spiceHeaderCardsFromFile = new JRadioButton();
        this.spiceNoTrailerCards = new JRadioButton();
        this.spiceTrailerCardsWithExtension = new JRadioButton();
        this.spiceTrailerCardsFromFile = new JRadioButton();
        this.spiceHeaderCardFile = new JTextField();
        this.spiceBrowseHeaderFile = new JButton();
        this.spiceTrailerCardExtension = new JTextField();
        this.spiceTrailerCardFile = new JTextField();
        this.spiceBrowseTrailerFile = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jSeparator5 = new JSeparator();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Spice Preferences");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpiceTab.this.closeDialog(evt);
            }
        });
        this.spice.setLayout(new GridBagLayout());
        this.spice.setToolTipText("Options for Spice deck generation");
        this.readingOutput.setLayout(new GridBagLayout());
        this.readingOutput.setBorder(BorderFactory.createTitledBorder("Reading Spice Output"));
        this.jLabel10.setText("Output format:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.readingOutput.add((Component)this.jLabel10, gridBagConstraints);
        this.spiceOutputFormatPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceOutputFormatPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.readingOutput.add((Component)this.spiceOutputFormatPopup, gridBagConstraints);
        this.epicLabel.setHorizontalAlignment(4);
        this.epicLabel.setText("Epic reader memory size: ");
        this.epicLabel.setHorizontalTextPosition(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.readingOutput.add((Component)this.epicLabel, gridBagConstraints);
        this.epicText.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.readingOutput.add((Component)this.epicText, gridBagConstraints);
        this.jLabel7.setText("Extracted network delimiter character:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        this.readingOutput.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.readingOutput.add((Component)this.spiceNetworkDelimiter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.readingOutput, gridBagConstraints);
        this.execution.setLayout(new GridBagLayout());
        this.execution.setBorder(BorderFactory.createTitledBorder("Running Spice"));
        this.spiceRunPopup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunPopupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.execution.add((Component)this.spiceRunPopup, gridBagConstraints);
        this.spiceRunProgram.setColumns(8);
        this.spiceRunProgram.setMinimumSize(new Dimension(100, 20));
        this.spiceRunProgram.setPreferredSize(new Dimension(92, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.spiceRunProgram, gridBagConstraints);
        this.jLabel17.setText("Run program:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.execution.add((Component)this.jLabel17, gridBagConstraints);
        this.useDirCheckBox.setText("Use dir:");
        this.useDirCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.useDirCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.execution.add((Component)this.useDirCheckBox, gridBagConstraints);
        this.useDir.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.execution.add((Component)this.useDir, gridBagConstraints);
        this.overwriteOutputFile.setText("Overwrite existing output file (no prompts)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.execution.add((Component)this.overwriteOutputFile, gridBagConstraints);
        this.spiceRunHelp.setText("Help");
        this.spiceRunHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SpiceTab.this.spiceRunHelpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.spiceRunHelp, gridBagConstraints);
        this.jLabel3.setText("With args:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.execution.add((Component)this.spiceRunProgramArgs, gridBagConstraints);
        this.spiceRunProbe.setText("Run probe");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        this.execution.add((Component)this.spiceRunProbe, gridBagConstraints);
        this.jLabel2.setText("After writing deck:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.execution.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.spice.add((Component)this.execution, gridBagConstraints);
        this.writingSpice.setLayout(new GridBagLayout());
        this.writingSpice.setBorder(BorderFactory.createTitledBorder("Writing Spice Deck"));
        this.upperLeft.setLayout(new GridBagLayout());
        this.jLabel5.setText("Parasitics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel1.setText("Spice engine:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel9.setText("Spice level:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel9, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceEnginePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceLevelPopup, gridBagConstraints);
        this.jLabel13.setText("Spice primitive set:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel13, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spicePrimitivesetPopup, gridBagConstraints);
        this.epicFrame.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.upperLeft.add((Component)this.epicFrame, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceResistorShorting, gridBagConstraints);
        this.jLabel4.setText("Resistor shorting:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceParasitics, gridBagConstraints);
        this.jLabel6.setText("Globals:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.upperLeft.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.upperLeft.add((Component)this.spiceGlobalTreatment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.writingSpice.add((Component)this.upperLeft, gridBagConstraints);
        this.upperRight.setLayout(new GridBagLayout());
        this.spiceWriteEndStatement.setText("Write .end statement");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteEndStatement, gridBagConstraints);
        this.spiceWriteTransSizesInLambda.setText("Write trans sizes in units");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteTransSizesInLambda, gridBagConstraints);
        this.spiceUseCellParameters.setText("Use cell parameters");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceUseCellParameters, gridBagConstraints);
        this.spiceWriteSubcktTopCell.setText("Write .subckt for top cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWriteSubcktTopCell, gridBagConstraints);
        this.spiceWritePwrGndSubcircuit.setText("Write VDD/GND in top cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.upperRight.add((Component)this.spiceWritePwrGndSubcircuit, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.writingSpice.add((Component)this.upperRight, gridBagConstraints);
        this.modelCards.setLayout(new GridBagLayout());
        this.spiceHeaderCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.modelCards.add((Component)this.spiceHeaderCardExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceNoHeaderCards);
        this.spiceNoHeaderCards.setText("No Header cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceNoHeaderCards, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsWithExtension);
        this.spiceHeaderCardsWithExtension.setText("Use Header cards from files with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceHeaderCardsWithExtension, gridBagConstraints);
        this.spiceHeader.add(this.spiceHeaderCardsFromFile);
        this.spiceHeaderCardsFromFile.setText("Use Header cards from file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceHeaderCardsFromFile, gridBagConstraints);
        this.spiceTrailer.add(this.spiceNoTrailerCards);
        this.spiceNoTrailerCards.setText("No Trailer cards");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceNoTrailerCards, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsWithExtension);
        this.spiceTrailerCardsWithExtension.setText("Use Trailer cards from files with extension:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceTrailerCardsWithExtension, gridBagConstraints);
        this.spiceTrailer.add(this.spiceTrailerCardsFromFile);
        this.spiceTrailerCardsFromFile.setText("Use Trailer cards from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.modelCards.add((Component)this.spiceTrailerCardsFromFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.modelCards.add((Component)this.spiceHeaderCardFile, gridBagConstraints);
        this.spiceBrowseHeaderFile.setText("Browse");
        this.spiceBrowseHeaderFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseHeaderFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.modelCards.add((Component)this.spiceBrowseHeaderFile, gridBagConstraints);
        this.spiceTrailerCardExtension.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        this.modelCards.add((Component)this.spiceTrailerCardExtension, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.modelCards.add((Component)this.spiceTrailerCardFile, gridBagConstraints);
        this.spiceBrowseTrailerFile.setText("Browse");
        this.spiceBrowseTrailerFile.setMinimumSize(new Dimension(78, 20));
        this.spiceBrowseTrailerFile.setPreferredSize(new Dimension(78, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.modelCards.add((Component)this.spiceBrowseTrailerFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.modelCards.add((Component)this.jSeparator4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.modelCards.add((Component)this.jSeparator5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.writingSpice.add((Component)this.modelCards, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.spice.add((Component)this.writingSpice, gridBagConstraints);
        this.getContentPane().add((Component)this.spice, new GridBagConstraints());
        this.pack();
    }

    private void spiceOutputFormatPopupActionPerformed(ActionEvent evt) {
        boolean vis = this.spiceOutputFormatPopup.getSelectedItem() == SpiceOutFormat.Epic;
        this.epicLabel.setEnabled(vis);
        this.epicText.setEnabled(vis);
    }

    private void spiceRunPopupActionPerformed(ActionEvent evt) {
        if (this.spiceRunPopup.getSelectedIndex() == 0) {
            this.setSpiceRunOptionsEnabled(false);
        } else {
            this.setSpiceRunOptionsEnabled(true);
        }
    }

    private void spiceRunHelpActionPerformed(ActionEvent evt) {
        String[] message = new String[]{"IMPORTANT: This executes a single program with the given args.  It does NOT run a command-line command.", "For example, 'echo blah > file' will NOT work. Encapsulate it in a script if you want to do such things.", "-----------------", "The following variables are available to use in the program name and arguments:", "   ${WORKING_DIR}:  The current working directory", "   ${USE_DIR}:  The Use Dir field, if specified (otherwise defaults to WORKING_DIR)", "   ${FILENAME}:  The output file name (with extension)", "   ${FILENAME_NO_EXT}:  The output file name (without extension)", "Example: Program: \"hspice\".  Args: \"${FILENAME}\""};
        JOptionPane.showMessageDialog(this, message, "Spice Run Help", 1);
    }

    private void useDirCheckBoxActionPerformed(ActionEvent evt) {
        this.useDir.setEnabled(this.useDirCheckBox.isSelected());
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SpiceOutFormat {
        Standard,
        Raw,
        RawSmart,
        Epic;

    }
}

