/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.Launcher;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.EpicAnalysis;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class EpicOutProcess
extends Simulate
implements Runnable {
    private Process readerProcess;
    private DataInputStream stdOut;
    private ArrayList<String> strings = new ArrayList();

    EpicOutProcess() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        EpicOutProcess.startProgressDialog("EPIC output", fileURL.getFile());
        Stimuli sd = null;
        boolean eof = false;
        try {
            this.readerProcess = this.invokeEpicReader(fileURL);
            this.stdOut = new DataInputStream(this.readerProcess.getInputStream());
            new Thread((Runnable)this, "EpicReaderErrors").start();
            sd = this.readEpicFile();
            sd.setCell(cell);
        }
        catch (EOFException e) {
            eof = true;
        }
        int exitCode = 0;
        if (this.readerProcess != null) {
            try {
                exitCode = this.readerProcess.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (eof || exitCode != 0) {
            String exitMsg = null;
            switch (exitCode) {
                case 0: {
                    exitMsg = "Ok";
                    break;
                }
                case 1: {
                    exitMsg = "File not found";
                    break;
                }
                case 2: {
                    exitMsg = "Out of memory";
                    break;
                }
                default: {
                    exitMsg = "Error";
                }
            }
            Job.getUserInterface().showErrorMessage("EpicReaderProcess exited with code " + exitCode + " (" + exitMsg + ")", "EpicReaderProcess");
        }
        EpicOutProcess.stopProgressDialog();
        this.strings = null;
        this.stdOut.close();
        this.stdOut = null;
        this.readerProcess = null;
        return sd;
    }

    private Stimuli readEpicFile() throws IOException {
        byte b;
        char separator = '.';
        Stimuli sd = new Stimuli();
        sd.setSeparatorChar(separator);
        EpicAnalysis an = new EpicAnalysis(sd);
        int numSignals = 0;
        ContextBuilder contextBuilder = new ContextBuilder();
        ArrayList<ContextBuilder> contextStack = new ArrayList<ContextBuilder>();
        contextStack.add(contextBuilder);
        int contextStackDepth = 1;
        boolean DEBUG = false;
        while ((b = this.stdOut.readByte()) != 70) {
            switch (b) {
                case 73: 
                case 86: {
                    String name = this.readString();
                    contextBuilder.strings.add(name);
                    byte type = b == 86 ? (byte)1 : 2;
                    contextBuilder.contexts.add(EpicAnalysis.getContext(type));
                    EpicAnalysis.EpicSignal s = new EpicAnalysis.EpicSignal(an, type, numSignals++);
                    s.setSignalName(name, null);
                    break;
                }
                case 68: {
                    String down = this.readString();
                    contextBuilder.strings.add(down);
                    if (contextStackDepth >= contextStack.size()) {
                        contextStack.add(new ContextBuilder());
                    }
                    contextBuilder = (ContextBuilder)contextStack.get(contextStackDepth++);
                    break;
                }
                case 85: {
                    EpicAnalysis.Context newContext = an.getContext(contextBuilder.strings, contextBuilder.contexts);
                    contextBuilder.clear();
                    contextBuilder = (ContextBuilder)contextStack.get(--contextStackDepth - 1);
                    contextBuilder.contexts.add(newContext);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            assert (contextBuilder == contextStack.get(contextStackDepth - 1));
        }
        assert (contextStackDepth == 1);
        an.setRootContext(an.getContext(contextBuilder.strings, contextBuilder.contexts));
        an.setTimeResolution(this.stdOut.readDouble());
        an.setVoltageResolution(this.stdOut.readDouble());
        an.setCurrentResolution(this.stdOut.readDouble());
        an.setMaxTime(this.stdOut.readDouble());
        List<AnalogSignal> signals = an.getSignals();
        assert (numSignals == signals.size());
        an.waveStarts = new int[numSignals + 1];
        int start = 0;
        for (int i = 0; i < numSignals; ++i) {
            int minV = this.stdOut.readInt();
            int maxV = this.stdOut.readInt();
            int len = this.stdOut.readInt();
            EpicAnalysis.EpicSignal s = (EpicAnalysis.EpicSignal)signals.get(i);
            s.setBounds(minV, maxV);
            an.waveStarts[i + 1] = start += len;
        }
        an.setWaveFile(new File(this.stdOut.readUTF()));
        return sd;
    }

    private void printDebug(int level, char cmd, String arg) {
        StringBuilder sb = new StringBuilder();
        while (level-- > 0) {
            sb.append(' ');
        }
        sb.append(cmd);
        if (arg != null) {
            sb.append(' ');
            sb.append(arg);
        }
        System.out.println(sb);
    }

    private String readString() throws IOException {
        int stringIndex = this.stdOut.readInt();
        if (stringIndex == -1) {
            return null;
        }
        if (stringIndex == this.strings.size()) {
            String s = this.stdOut.readUTF();
            this.strings.add(s);
        }
        return this.strings.get(stringIndex);
    }

    private Process invokeEpicReader(URL fileURL) {
        Runtime runtime = Runtime.getRuntime();
        String program = "java";
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            program = javaHome + File.separator + "bin" + File.separator + program;
        }
        int maxMemWanted = Simulation.getSpiceEpicMemorySize();
        URL electric = Launcher.class.getResource("Main.class");
        if (electric.getProtocol().equals("jar")) {
            String file = electric.getFile();
            file = file.replaceAll("file:", "");
            file = file.replaceAll("!.*", "");
        }
        String command = program;
        command = command + " -cp " + Launcher.getJarLocation();
        command = command + " -ss2m";
        command = command + " -ea";
        command = command + " -mx" + maxMemWanted + "m com.sun.electric.tool.io.input.EpicReaderProcess";
        command = command + " " + fileURL;
        Process process = null;
        try {
            process = runtime.exec(command);
            System.out.println("EpicReaderProcess launched with memory limit " + maxMemWanted + "m");
        }
        catch (IOException e) {
            System.out.println("EpicReaderProcess failed to launch");
        }
        return process;
    }

    public void run() {
        String progressKey = "**PROGRESS ";
        BufferedReader stdErr = new BufferedReader(new InputStreamReader(this.readerProcess.getErrorStream()));
        try {
            String line = null;
            while ((line = stdErr.readLine()) != null) {
                if (line.startsWith("**PROGRESS ")) {
                    if ((line = line.substring("**PROGRESS ".length())).startsWith("!")) {
                        EpicOutProcess.setProgressValue(0);
                        EpicOutProcess.setProgressNote(line.substring(1));
                        continue;
                    }
                    EpicOutProcess.setProgressValue(TextUtils.atoi(line));
                    continue;
                }
                System.out.println("EpicReader: " + line);
            }
            stdErr.close();
        }
        catch (IOException e) {
            ActivityLogger.logException(e);
        }
    }

    private static class ContextBuilder {
        ArrayList<String> strings = new ArrayList();
        ArrayList<EpicAnalysis.Context> contexts = new ArrayList();

        private ContextBuilder() {
        }

        void clear() {
            this.strings.clear();
            this.contexts.clear();
        }
    }
}

