/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.user.User;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Maze {
    private static final int SRMAXLAYERS = 64;
    private static final int MAXGRIDSIZE = 1000;
    private static final int BLOCKAGELIMIT = 10;
    private static final int HORILAYER = 0;
    private static final int VERTLAYER = 1;
    private static final int ALLLAYERS = 2;
    private static final int SR_GSET = 128;
    private static final int SR_GWAVE = 32;
    private static final int SR_GPORT = 16;
    private static final int SR_GMASK = 15;
    private static final int SR_GMAX = 15;
    private static final int SR_GSTART = 1;
    private static final int SRSUCCESS = 0;
    private static final int SRERROR = 1;
    private static final int SRROUTED = 2;
    private static final int SRBLOCKED = 3;
    private static final int SRUNROUTED = 4;
    private ArcProto mazeVertWire;
    private ArcProto mazeHorizWire;
    private NodeProto mazeSteinerNode;
    private Layer mazeVertLayer;
    private Layer mazeHorizLayer;
    private double mazeBloat;
    private SRREGION theRegion = null;
    private Netlist netList;
    private int mazeBoundary = 20;
    SRDIRECTION SRVERTPREF = new SRDIRECTION();
    SRDIRECTION SRHORIPREF = new SRDIRECTION();
    SRDIRECTION SRALL = new SRDIRECTION();
    SRPTYPE SRPFIXED = new SRPTYPE();
    SRPTYPE SRPROUTED = new SRPTYPE();

    public static void mazeRoute() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd == null) {
            return;
        }
        Netlist netList = cell.acquireUserNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return;
        }
        Set<Network> nets = wnd.getHighlightedNetworks();
        ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            Network net;
            ArcInst ai = it.next();
            if (ai.getProto() != Generic.tech().unrouted_arc || !nets.contains(net = netList.getNetwork(ai, 0))) continue;
            arcsToRoute.add(ai);
            nets.remove(net);
        }
        wnd.clearHighlighting();
        wnd.finishedHighlighting();
        new MazeRouteJob(cell, arcsToRoute);
    }

    public void routeSelected(Cell cell, List<ArcInst> arcsToRoute) {
        if (arcsToRoute.size() == 0) {
            this.netList = cell.acquireUserNetlist();
            HashSet<Network> nets = new HashSet<Network>();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                Network net;
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc || nets.contains(net = this.netList.getNetwork(ai, 0))) continue;
                arcsToRoute.add(ai);
                nets.add(net);
            }
        }
        for (ArcInst ai : arcsToRoute) {
            this.netList = cell.acquireUserNetlist();
            Network net = this.netList.getNetwork(ai, 0);
            if (!this.routeNet(net)) continue;
        }
    }

    private boolean routeNet(Network net) {
        int hy;
        HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
        HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
        List<Connection> netEnds = Routing.findNetEnds(net, arcsToDelete, nodesToDelete, this.netList, true);
        int count = netEnds.size();
        if (count == 0) {
            return false;
        }
        if (count != 2) {
            System.out.println("Error: Network " + net.describe(false) + " has " + count + " ends, but can only route nets with 2 ends");
            return true;
        }
        Cell cell = net.getParent();
        Rectangle2D routingBounds = null;
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            Network aNet = this.netList.getNetwork(ai, 0);
            if (aNet != net) continue;
            Rectangle2D arcBounds = ai.getBounds();
            if (routingBounds == null) {
                routingBounds = arcBounds;
                continue;
            }
            Rectangle2D.union(routingBounds, arcBounds, routingBounds);
        }
        if (routingBounds == null) {
            System.out.println("Internal error: no bounding area for routing");
            return true;
        }
        ArcProto routingArc = User.getUserTool().getCurrentArcProto();
        if (routingArc == Generic.tech().unrouted_arc) {
            routingArc = null;
        }
        if (routingArc != null) {
            for (int i = 0; i < count; ++i) {
                Connection con = netEnds.get(i);
                boolean found = con.getPortInst().getPortProto().getBasePort().connectsTo(routingArc);
                if (found) continue;
                routingArc = null;
                break;
            }
        }
        if (routingArc == null) {
            HashSet<ArcProto> arcsUsed = new HashSet<ArcProto>();
            for (int i = 0; i < count; ++i) {
                Connection con = netEnds.get(i);
                ArcProto[] connections = con.getPortInst().getPortProto().getBasePort().getConnections();
                for (int j = 0; j < connections.length; ++j) {
                    ArcProto ap = connections[j];
                    if (ap.getTechnology() == Generic.tech()) continue;
                    arcsUsed.add(ap);
                }
            }
            Iterator<Technology> it2 = Technology.getTechnologies();
            while (it2.hasNext()) {
                Technology tech = it2.next();
                if (tech == Generic.tech()) continue;
                Iterator<ArcProto> aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ArcProto ap = aIt.next();
                    if (!arcsUsed.contains(ap)) continue;
                    boolean allFound = true;
                    for (int i = 0; i < count; ++i) {
                        Connection con = netEnds.get(i);
                        boolean found = con.getPortInst().getPortProto().getBasePort().connectsTo(ap);
                        if (found) continue;
                        allFound = false;
                        break;
                    }
                    if (!allFound) continue;
                    routingArc = ap;
                    break;
                }
                if (routingArc == null) continue;
                break;
            }
        }
        if (routingArc == null) {
            System.out.println("Cannot find wire to route");
            return true;
        }
        this.mazeVertWire = routingArc;
        this.mazeHorizWire = routingArc;
        this.mazeSteinerNode = routingArc.findPinProto();
        this.mazeVertLayer = this.mazeVertWire.getLayer(0);
        this.mazeHorizLayer = this.mazeHorizWire.getLayer(0);
        this.mazeBloat = 0.0;
        double wid = 10.0;
        double len = 100.0;
        DRCTemplate rule = DRC.getSpacingRule(this.mazeVertLayer, null, this.mazeVertLayer, null, false, 0, wid, len);
        if (rule != null) {
            this.mazeBloat = rule.getValue(0) + this.mazeVertWire.getDefaultLambdaBaseWidth() / 2.0;
        }
        int lx = (int)routingBounds.getMinX();
        int hx = (int)routingBounds.getMaxX();
        int ly = (int)routingBounds.getMinY();
        SRREGION region = this.defineRegion(cell, net, lx, ly, hx, hy = (int)routingBounds.getMaxY(), arcsToDelete, nodesToDelete);
        if (region == null) {
            return true;
        }
        SRNET srnet = this.addNet(region, net);
        if (srnet == null) {
            System.out.println("Could not allocate internal net");
            return true;
        }
        for (int i = 0; i < count; ++i) {
            Connection con = netEnds.get(i);
            PortInst pi = con.getPortInst();
            double cXD = con.getLocation().getX();
            double cYD = con.getLocation().getY();
            SRPORT fsp = this.addPort(srnet, this.determineDir(pi.getNodeInst(), cXD, cYD), cXD, cYD, pi);
            if (fsp != null) continue;
            System.out.println("Port could not be defined");
            return true;
        }
        if (this.routeANet(srnet)) {
            System.out.println("Could not route net " + srnet.eNet.describe(false));
            return true;
        }
        if (this.extractPaths(cell, srnet)) {
            System.out.println("Could not create paths");
            return true;
        }
        for (ArcInst ai : arcsToDelete) {
            ai.kill();
        }
        cell.killNodes(nodesToDelete);
        return false;
    }

    private boolean routeANet(SRNET net) {
        boolean ret = false;
        for (int index = 0; index < 64; ++index) {
            int i;
            int prio;
            int prio2;
            int i2;
            SRLAYER layer = net.region.layers[index];
            if (layer == null) continue;
            layer.lx = layer.wid;
            layer.hx = -1;
            layer.ly = layer.hei;
            layer.hy = -1;
            int count = 0;
            for (int x = 0; x < layer.wid; ++x) {
                if ((layer.vused[x] & 0x80) != 0) {
                    if (count == 0) continue;
                    i2 = 1;
                    prio2 = count >> 1;
                    while (i2 <= count) {
                        layer.vused[x - i2] = (byte)Math.abs(prio2);
                        ++i2;
                        --prio2;
                    }
                    count = 0;
                    continue;
                }
                ++count;
            }
            if (count != 0) {
                prio = count >> 1;
                for (i = 1; i < count; ++i) {
                    layer.vused[layer.wid - i] = (byte)Math.abs(prio);
                    if (--prio != 0 || (count & 1) != 0) continue;
                    prio = -1;
                }
            }
            count = 0;
            for (int y = 0; y < layer.hei; ++y) {
                if ((layer.hused[y] & 0x80) != 0) {
                    if (count == 0) continue;
                    i2 = 1;
                    prio2 = count >> 1;
                    while (i2 <= count) {
                        layer.hused[y - i2] = (byte)Math.abs(prio2);
                        ++i2;
                        --prio2;
                    }
                    count = 0;
                    continue;
                }
                ++count;
            }
            if (count == 0) continue;
            prio = count >> 1;
            for (i = 1; i < count; ++i) {
                layer.hused[layer.hei - i] = (byte)Math.abs(prio);
                if (--prio != 0 || (count & 1) != 0) continue;
                prio = -1;
            }
        }
        int pCount = 0;
        SRPORT port = net.ports;
        while (port != null) {
            this.createWavefront(port);
            port = port.next;
            ++pCount;
        }
        int code = 1;
        do {
            if (++code > 15) {
                code = 1;
            }
            int blocked = 0;
            int status = 0;
            SRPORT port2 = null;
            port2 = net.ports;
            while (port2 != null) {
                if (port2.master == null) {
                    status = this.expandWavefront(port2, code);
                    if (status == 1) {
                        return true;
                    }
                    if (status == 2) break;
                    if (status == 3) {
                        ++blocked;
                    }
                }
                port2 = port2.next;
            }
            if (port2 != null && status == 2) {
                this.clearMaze(net);
                if (--pCount > 1) {
                    port2 = net.ports;
                    while (port2 != null) {
                        this.createWavefront(port2);
                        port2 = port2.next;
                    }
                }
                code = 1;
                continue;
            }
            if (blocked != pCount) continue;
            ret = true;
            this.clearMaze(net);
            break;
        } while (pCount > 1);
        SRPORT port3 = net.ports;
        while (port3 != null) {
            if (net.lastpath == null) {
                net.paths = port3.paths;
                if (net.paths != null) {
                    net.lastpath = port3.lastpath;
                }
            } else {
                net.lastpath.next = port3.paths;
                if (net.lastpath.next != null) {
                    net.lastpath = port3.lastpath;
                }
            }
            port3.paths = null;
            port3.lastpath = null;
            port3 = port3.next;
        }
        if (!ret) {
            net.routed = true;
        }
        return ret;
    }

    private void createWavefront(SRPORT port) {
        SRPORT master = port.master;
        if (master == null) {
            master = port;
        }
        int index = 0;
        int mask = 1;
        while (index < 64) {
            SRLAYER layer;
            if (((long)mask & port.layers) != 0L && (layer = port.net.region.layers[index]) != null) {
                int lx = this.getGridX(port.lx, layer);
                int ly = this.getGridY(port.ly, layer);
                int hx = this.getGridX(port.hx, layer);
                int hy = this.getGridY(port.hy, layer);
                if (lx < layer.wid && hx >= 0 && ly < layer.hei && hy >= 0) {
                    if (lx < 0) {
                        lx = 0;
                    }
                    if (hx >= layer.wid) {
                        hx = layer.wid - 1;
                    }
                    if (ly < 0) {
                        ly = 0;
                    }
                    if (hy >= layer.hei) {
                        hy = layer.hei - 1;
                    }
                    boolean onEdge = false;
                    for (int x = lx; x <= hx; ++x) {
                        for (int y = ly; y <= hy; ++y) {
                            this.addWavePoint(master, layer, x, y, 1);
                            if (x < layer.wid - 1 && layer.grids[x + 1][y] == 0) {
                                onEdge = true;
                            }
                            if (x > 0 && layer.grids[x - 1][y] == 0) {
                                onEdge = true;
                            }
                            if (y < layer.hei - 1 && layer.grids[x][y + 1] == 0) {
                                onEdge = true;
                            }
                            if (y <= 0 || layer.grids[x][y - 1] != 0) continue;
                            onEdge = true;
                        }
                    }
                    if (!onEdge) {
                        int spread;
                        int cx = (lx + hx) / 2;
                        int cy = (ly + hy) / 2;
                        PrimitivePort prP = port.pi.getPortProto().getBasePort();
                        int angRange = prP.getAngleRange();
                        int ang = prP.getAngle();
                        NodeInst ni = port.pi.getNodeInst();
                        ang += (ni.getAngle() + 5) / 10;
                        if (ni.isMirroredAboutXAxis() != ni.isMirroredAboutYAxis() && (ang = 270 - ang) < 0) {
                            ang += 360;
                        }
                        if (this.angleDiff(ang, 0) <= angRange) {
                            for (spread = 1; spread < 10 && hx + spread < layer.wid; ++spread) {
                                if (layer.grids[hx + spread][cy] == 0) {
                                    onEdge = true;
                                    break;
                                }
                                layer.grids[hx + spread][cy] = 0;
                            }
                        }
                        if (this.angleDiff(ang, 90) <= angRange) {
                            for (spread = 1; spread < 10 && hy + spread < layer.hei; ++spread) {
                                if (layer.grids[cx][hy + spread] == 0) {
                                    onEdge = true;
                                    break;
                                }
                                layer.grids[cx][hy + spread] = 0;
                            }
                        }
                        if (this.angleDiff(ang, 180) <= angRange) {
                            for (spread = 1; spread < 10 && lx - spread >= 0; ++spread) {
                                if (layer.grids[lx - spread][cy] == 0) {
                                    onEdge = true;
                                    break;
                                }
                                layer.grids[lx - spread][cy] = 0;
                            }
                        }
                        if (this.angleDiff(ang, 270) <= angRange) {
                            for (spread = 1; spread < 10 && ly - spread >= 0; ++spread) {
                                if (layer.grids[cx][ly - spread] == 0) {
                                    onEdge = true;
                                    break;
                                }
                                layer.grids[cx][ly - spread] = 0;
                            }
                        }
                        if (!onEdge) {
                            System.out.println("Node " + ni.describe(false) + ", port " + port.pi.getPortProto().getName() + " is blocked");
                            return;
                        }
                    }
                }
            }
            ++index;
            mask <<= 1;
        }
        SRPATH path = port.paths;
        while (path != null) {
            int x;
            int dx;
            if (path.x[0] == path.x[1]) {
                int dy = -1;
                if (path.y[0] < path.y[1]) {
                    dy = 1;
                }
                int x2 = path.x[0];
                int y = path.y[0];
                while (dy < 0 ? y >= path.y[1] : y <= path.y[1]) {
                    this.addWavePoint(master, path.layer, x2, y, 1);
                    y += dy;
                }
            } else if (path.y[0] == path.y[1]) {
                dx = -1;
                if (path.x[0] < path.x[1]) {
                    dx = 1;
                }
                int y = path.y[0];
                x = path.x[0];
                while (dx < 0 ? x >= path.x[1] : x <= path.x[1]) {
                    this.addWavePoint(master, path.layer, x, y, 1);
                    x += dx;
                }
            } else {
                dx = -1;
                if (path.x[0] < path.x[1]) {
                    dx = 1;
                }
                int dy = -1;
                if (path.y[0] < path.y[1]) {
                    dy = 1;
                }
                x = path.x[0];
                int y = path.y[0];
                while (dx < 0 ? x >= path.x[1] : x <= path.x[1]) {
                    this.addWavePoint(master, path.layer, x, y, 1);
                    x += dx;
                    y += dy;
                }
            }
            path = path.next;
        }
    }

    private void addWavePoint(SRPORT port, SRLAYER layer, int x, int y, int code) {
        SRWAVEPT wavePt = new SRWAVEPT();
        wavePt.x = x;
        wavePt.y = y;
        layer.grids[x][y] = (byte)(layer.grids[x][y] & 0xFFFFFFF0 | code | 0x20);
        wavePt.layer = layer;
        if (layer.lx > x) {
            layer.lx = x;
        }
        if (layer.hx < x) {
            layer.hx = x;
        }
        if (layer.ly > y) {
            layer.ly = y;
        }
        if (layer.hy < y) {
            layer.hy = y;
        }
        wavePt.prev = null;
        if (port.master != null) {
            wavePt.port = port.master;
            wavePt.next = port.master.wavefront;
            port.master.wavefront = wavePt;
        } else {
            wavePt.port = port;
            wavePt.next = port.wavefront;
            port.wavefront = wavePt;
        }
        if (wavePt.next != null) {
            wavePt.next.prev = wavePt;
        }
    }

    private int angleDiff(int ang1, int ang2) {
        int diff = Math.abs(ang1 - ang2);
        if (diff > 180) {
            diff = 360 - diff;
        }
        return diff;
    }

    private int expandWavefront(SRPORT port, int code) {
        SRWAVEPT wavePt = port.wavefront;
        if (wavePt == null) {
            return 3;
        }
        SRWAVEPT next = null;
        int status = 0;
        boolean found = false;
        int bx = 0;
        int by = 0;
        SRLAYER bLayer = null;
        SRWAVEPT bWavePt = new SRWAVEPT();
        wavePt = port.wavefront;
        while (wavePt != null) {
            boolean connected = false;
            SRLAYER layer = wavePt.layer;
            if (layer.dir == this.SRALL || layer.dir == this.SRHORIPREF) {
                int x = wavePt.x + 1;
                if (x != layer.wid && (status = this.examinePoint(port, layer, x, wavePt.y, code)) == 2) {
                    if (!found || (layer.hused[bWavePt.y] & 0x80) != 0 || (layer.hused[wavePt.y] & 0x80) == 0 && layer.hused[wavePt.y] < layer.hused[bWavePt.y]) {
                        bWavePt.x = wavePt.x;
                        bWavePt.y = wavePt.y;
                        bWavePt.layer = wavePt.layer;
                        bWavePt.port = wavePt.port;
                        bx = x;
                        by = wavePt.y;
                        bLayer = layer;
                    }
                    found = true;
                    connected = true;
                }
                if (!connected && (x = wavePt.x - 1) >= 0 && (status = this.examinePoint(port, layer, x, wavePt.y, code)) == 2) {
                    if (!found || (layer.hused[bWavePt.y] & 0x80) != 0 || (layer.hused[wavePt.y] & 0x80) == 0 && layer.hused[wavePt.y] < layer.hused[bWavePt.y]) {
                        bWavePt.x = wavePt.x;
                        bWavePt.y = wavePt.y;
                        bWavePt.layer = wavePt.layer;
                        bWavePt.port = wavePt.port;
                        bx = x;
                        by = wavePt.y;
                        bLayer = layer;
                    }
                    found = true;
                    connected = true;
                }
            }
            if (layer.dir == this.SRALL || layer.dir == this.SRVERTPREF) {
                int y = wavePt.y + 1;
                if (!connected && y != layer.hei && (status = this.examinePoint(port, layer, wavePt.x, y, code)) == 2) {
                    if (!found || (layer.vused[bWavePt.x] & 0x80) != 0 || (layer.vused[wavePt.x] & 0x80) == 0 && layer.vused[wavePt.x] < layer.vused[bWavePt.x]) {
                        bWavePt.x = wavePt.x;
                        bWavePt.y = wavePt.y;
                        bWavePt.layer = wavePt.layer;
                        bWavePt.port = wavePt.port;
                        bx = wavePt.x;
                        by = y;
                        bLayer = layer;
                    }
                    found = true;
                    connected = true;
                }
                if (!connected && (y = wavePt.y - 1) >= 0 && (status = this.examinePoint(port, layer, wavePt.x, y, code)) == 2) {
                    if (!found || (layer.vused[bWavePt.x] & 0x80) != 0 || (layer.vused[wavePt.x] & 0x80) == 0 && layer.vused[wavePt.x] < layer.vused[bWavePt.x]) {
                        bWavePt.x = wavePt.x;
                        bWavePt.y = wavePt.y;
                        bWavePt.layer = wavePt.layer;
                        bWavePt.port = wavePt.port;
                        bx = wavePt.x;
                        by = y;
                        bLayer = layer;
                    }
                    found = true;
                    connected = true;
                }
            }
            if (!connected && layer.up != null && (status = this.examinePoint(port, layer.up, wavePt.x, wavePt.y, code)) == 2) {
                if (!found) {
                    bWavePt.x = wavePt.x;
                    bWavePt.y = wavePt.y;
                    bWavePt.layer = wavePt.layer;
                    bWavePt.port = wavePt.port;
                    bx = wavePt.x;
                    by = wavePt.y;
                    bLayer = layer.up;
                }
                found = true;
                connected = true;
            }
            if (!connected && layer.down != null && (status = this.examinePoint(port, layer.down, wavePt.x, wavePt.y, code)) == 2) {
                if (!found) {
                    bWavePt.x = wavePt.x;
                    bWavePt.y = wavePt.y;
                    bWavePt.layer = wavePt.layer;
                    bWavePt.port = wavePt.port;
                    bx = wavePt.x;
                    by = wavePt.y;
                    bLayer = layer.down;
                }
                found = true;
                connected = true;
            }
            next = wavePt.next;
            if (wavePt.prev == null) {
                port.wavefront = wavePt.next;
                if (wavePt.next != null) {
                    wavePt.next.prev = null;
                }
            } else {
                wavePt.prev.next = wavePt.next;
                if (wavePt.next != null) {
                    wavePt.next.prev = wavePt.prev;
                }
            }
            if (!connected) {
                byte[] byArray = layer.grids[wavePt.x];
                int n = wavePt.y;
                byArray[n] = (byte)(byArray[n] & 0xFFFFFFDF);
            }
            wavePt = next;
        }
        if (found) {
            return this.initPath(port, bLayer, bWavePt, bx, by);
        }
        if (port.wavefront == null) {
            return 3;
        }
        return 0;
    }

    private int initPath(SRPORT port, SRLAYER layer, SRWAVEPT wavePt, int x, int y) {
        SRPORT target = null;
        SRWAVEPT tWavePt = null;
        target = port.net.ports;
        while (target != null && (target == port || target.master != null || (tWavePt = this.searchWavefront(target, layer, x, y)) == null)) {
            target = target.next;
        }
        if (target == null) {
            return 1;
        }
        if (port.lastpath != null) {
            port.lastpath.next = target.paths;
            if (port.lastpath.next != null) {
                port.lastpath = target.lastpath;
            }
        } else {
            port.paths = target.paths;
            port.lastpath = target.lastpath;
        }
        target.paths = null;
        target.lastpath = null;
        SRPATH path = null;
        if (wavePt.layer == tWavePt.layer) {
            path = this.getPath(port, layer, false, false, wavePt.x, wavePt.y, tWavePt.x, tWavePt.y);
        }
        if (this.findPaths(wavePt, path) != 0) {
            return 1;
        }
        if (this.findPaths(tWavePt, path) != 0) {
            return 1;
        }
        target.master = port;
        SRPORT sport = port.net.ports;
        while (sport != null) {
            if (sport.master == target) {
                sport.master = port;
            }
            sport = sport.next;
        }
        if (port.lastpath != null) {
            port.lastpath.next = target.paths;
            if (port.lastpath.next != null) {
                port.lastpath = target.lastpath;
            }
        } else {
            port.paths = target.paths;
            port.lastpath = target.lastpath;
        }
        target.paths = null;
        target.lastpath = null;
        return 2;
    }

    private int findPaths(SRWAVEPT wavePt, SRPATH path) {
        int sx = wavePt.x;
        int sy = wavePt.y;
        SRLAYER layer = wavePt.layer;
        int code = layer.grids[sx][sy] & 0xF;
        code = code == 1 ? 15 : --code;
        int pStart = 0;
        int ex = 0;
        int ey = 0;
        while (true) {
            int dy;
            int dx;
            block58: {
                dx = 0;
                dy = 0;
                while (true) {
                    int status;
                    if (pStart == 1) {
                        if (layer.up != null) {
                            ex = sx;
                            ey = sy;
                            status = this.testPoint(layer.up.grids[ex][ey], code);
                            if (status == 2) {
                                return 0;
                            }
                            if (status == 0) {
                                layer = layer.up;
                                code = code == 1 ? 15 : --code;
                                pStart = 2;
                                continue;
                            }
                        }
                        if (layer.down != null) {
                            ex = sx;
                            ey = sy;
                            status = this.testPoint(layer.down.grids[ex][ey], code);
                            if (status == 2) {
                                return 0;
                            }
                            if (status == 0) {
                                layer = layer.down;
                                code = code == 1 ? 15 : --code;
                                pStart = 2;
                                continue;
                            }
                        }
                    }
                    if ((layer.dir == this.SRALL || layer.dir == this.SRHORIPREF) && (ex = sx + 1) != layer.wid) {
                        ey = sy;
                        status = this.testPoint(layer.grids[ex][ey], code);
                        if (status == 2) {
                            if (path != null && path.layer == layer && path.y[0] == path.y[1] && path.y[0] == ey && Math.max(path.x[0], path.x[1]) == sx) {
                                if (path.x[0] == sx) {
                                    path.x[0] = ex;
                                    path.wx[0] = this.getWorldX(ex, layer);
                                } else {
                                    path.x[1] = ex;
                                    path.wx[1] = this.getWorldX(ex, layer);
                                }
                                this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                                return 0;
                            }
                            this.getPath(wavePt.port, layer, false, true, sx, sy, ex, ey);
                            return 0;
                        }
                        if (status == 0) {
                            dx = 1;
                            break block58;
                        }
                    }
                    if ((layer.dir == this.SRALL || layer.dir == this.SRVERTPREF) && (ey = sy - 1) >= 0) {
                        ex = sx;
                        status = this.testPoint(layer.grids[ex][ey], code);
                        if (status == 2) {
                            if (path != null && path.layer == layer && path.x[0] == path.x[1] && path.x[0] == ex && Math.min(path.y[0], path.y[1]) == sy) {
                                if (path.y[0] == sy) {
                                    path.y[0] = ey;
                                    path.wy[0] = this.getWorldY(ey, layer);
                                } else {
                                    path.y[1] = ey;
                                    path.wy[1] = this.getWorldY(ey, layer);
                                }
                                this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                                return 0;
                            }
                            this.getPath(wavePt.port, layer, false, true, sx, sy, ex, ey);
                            return 0;
                        }
                        if (status == 0) {
                            dy = -1;
                            break block58;
                        }
                    }
                    if ((layer.dir == this.SRALL || layer.dir == this.SRHORIPREF) && (ex = sx - 1) >= 0) {
                        ey = sy;
                        status = this.testPoint(layer.grids[ex][ey], code);
                        if (status == 2) {
                            if (path != null && path.layer == layer && path.y[0] == path.y[1] && path.y[0] == ey && Math.min(path.x[0], path.x[1]) == sx) {
                                if (path.x[0] == sx) {
                                    path.x[0] = ex;
                                    path.wx[0] = this.getWorldX(ex, layer);
                                } else {
                                    path.x[1] = ex;
                                    path.wx[1] = this.getWorldX(ex, layer);
                                }
                                this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                                return 0;
                            }
                            this.getPath(wavePt.port, layer, false, true, sx, sy, ex, ey);
                            return 0;
                        }
                        if (status == 0) {
                            dx = -1;
                            break block58;
                        }
                    }
                    if ((layer.dir == this.SRALL || layer.dir == this.SRVERTPREF) && (ey = sy + 1) != layer.hei) {
                        ex = sx;
                        status = this.testPoint(layer.grids[ex][ey], code);
                        if (status == 2) {
                            if (path != null && path.layer == layer && path.x[0] == path.x[1] && path.x[0] == ex && Math.max(path.y[0], path.y[1]) == sy) {
                                if (path.y[0] == sy) {
                                    path.y[0] = ey;
                                    path.wy[0] = this.getWorldY(ey, layer);
                                } else {
                                    path.y[1] = ey;
                                    path.wy[1] = this.getWorldY(ey, layer);
                                }
                                this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                                return 0;
                            }
                            this.getPath(wavePt.port, layer, false, true, sx, sy, ex, ey);
                            return 0;
                        }
                        if (status == 0) {
                            dy = 1;
                            break block58;
                        }
                    }
                    if (pStart != 0) break;
                    if (layer.up != null) {
                        ex = sx;
                        ey = sy;
                        status = this.testPoint(layer.up.grids[ex][ey], code);
                        if (status == 2) {
                            return 0;
                        }
                        if (status == 0) {
                            layer = layer.up;
                            if (code == 1) {
                                code = 15;
                                continue;
                            }
                            --code;
                            continue;
                        }
                    }
                    if (layer.down == null) break;
                    ex = sx;
                    ey = sy;
                    status = this.testPoint(layer.down.grids[ex][ey], code);
                    if (status == 2) {
                        return 0;
                    }
                    if (status != 0) break;
                    layer = layer.down;
                    if (code == 1) {
                        code = 15;
                        continue;
                    }
                    --code;
                }
                return 1;
            }
            pStart = 1;
            while (true) {
                int status;
                int ny;
                int nx;
                code = code == 1 ? 15 : --code;
                if (dx != 0) {
                    nx = ex + dx;
                    ny = ey;
                    status = this.testPoint(layer.grids[nx][ny], code);
                    if (status == 2) {
                        if (path != null && path.layer == layer && path.y[0] == path.y[1] && path.y[0] == sy && (dx < 0 && Math.min(path.x[0], path.x[1]) == sx || dx > 0 && Math.max(path.x[0], path.x[1]) == sx)) {
                            if (path.x[0] == sx) {
                                path.x[0] = nx;
                                path.wx[0] = this.getWorldX(nx, layer);
                            } else {
                                path.x[1] = nx;
                                path.wx[1] = this.getWorldX(nx, layer);
                            }
                            this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                            return 0;
                        }
                        this.getPath(wavePt.port, layer, false, true, sx, sy, nx, ny);
                        return 0;
                    }
                    if (status == 0) {
                        ex = nx;
                        continue;
                    }
                }
                if (dy == 0) break;
                nx = ex;
                ny = ey + dy;
                status = this.testPoint(layer.grids[nx][ny], code);
                if (status == 2) {
                    if (path != null && path.layer == layer && path.x[0] == path.x[1] && path.x[0] == sx && (dy < 0 && Math.min(path.y[0], path.y[1]) == sy || dy > 0 && Math.max(path.y[0], path.y[1]) == sy)) {
                        if (path.y[0] == sy) {
                            path.y[0] = ny;
                            path.wy[0] = this.getWorldY(ny, layer);
                        } else {
                            path.y[1] = ny;
                            path.wy[1] = this.getWorldY(ny, layer);
                        }
                        this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                        return 0;
                    }
                    this.getPath(wavePt.port, layer, false, true, sx, sy, nx, ny);
                    return 0;
                }
                if (status != 0) break;
                ey = ny;
            }
            if (path != null && path.layer == layer && (sy == ey && path.y[0] == path.y[1] && path.y[0] == ey && (path.x[0] == sx || path.x[1] == sx) || sx == ex && path.x[0] == path.x[1] && path.x[0] == ex && (path.y[0] == sy || path.y[1] == sy))) {
                if (sx == ex) {
                    if (sy == path.y[0]) {
                        path.y[0] = ey;
                        path.wy[0] = this.getWorldY(ey, layer);
                    } else {
                        path.y[1] = ey;
                        path.wy[1] = this.getWorldY(ey, layer);
                    }
                } else if (sx == path.x[0]) {
                    path.x[0] = ex;
                    path.wx[0] = this.getWorldX(ex, layer);
                } else {
                    path.x[1] = ex;
                    path.wx[1] = this.getWorldX(ex, layer);
                }
                this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
                path = null;
            } else {
                this.getPath(wavePt.port, layer, false, false, sx, sy, ex, ey);
            }
            sx = ex;
            sy = ey;
        }
    }

    private int testPoint(int pt, int code) {
        if ((pt & 0x20) == 0) {
            if ((pt & 0x80) != 0) {
                if ((pt & 0x10) != 0 && (pt & 0xF) == code) {
                    return 2;
                }
            } else if ((pt & 0xF) == code) {
                return 0;
            }
        }
        return 4;
    }

    private SRPATH getPath(SRPORT port, SRLAYER layer, boolean e1, boolean e2, int x1, int y1, int x2, int y2) {
        SRPATH path = new SRPATH();
        path.x[0] = x1;
        path.y[0] = y1;
        path.x[1] = x2;
        path.y[1] = y2;
        path.end[0] = e1;
        path.end[1] = e2;
        path.layer = layer;
        path.port = port;
        path.type = this.SRPROUTED;
        path.wx[0] = this.getWorldX(x1, layer);
        path.wy[0] = this.getWorldY(y1, layer);
        path.wx[1] = this.getWorldX(x2, layer);
        path.wy[1] = this.getWorldY(y2, layer);
        path.next = null;
        if (port.lastpath == null) {
            port.paths = path;
        } else {
            port.lastpath.next = path;
        }
        port.lastpath = path;
        this.setLine(path.layer, 144, path.wx[0], path.wy[0], path.wx[1], path.wy[1], true);
        return path;
    }

    private int examinePoint(SRPORT port, SRLAYER layer, int x, int y, int code) {
        if ((layer.grids[x][y] & 0x20) != 0) {
            if (this.searchWavefront(port, layer, x, y) == null) {
                return 2;
            }
        } else if (layer.grids[x][y] == 0) {
            this.addWavePoint(port, layer, x, y, code);
            return 0;
        }
        return 3;
    }

    private SRWAVEPT searchWavefront(SRPORT port, SRLAYER layer, int x, int y) {
        SRWAVEPT wavept = port.wavefront;
        while (wavept != null) {
            if (wavept.layer == layer && wavept.x == x && wavept.y == y) {
                return wavept;
            }
            wavept = wavept.next;
        }
        return null;
    }

    private void clearMaze(SRNET net) {
        for (int index = 0; index < 64; ++index) {
            SRLAYER layer = net.region.layers[index];
            if (layer == null) continue;
            int mask = -48;
            for (int x = layer.lx; x <= layer.hx; ++x) {
                for (int y = layer.ly; y <= layer.hy; ++y) {
                    layer.grids[x][y] = (byte)(layer.grids[x][y] & mask);
                }
            }
            layer.lx = layer.wid;
            layer.ly = layer.hei;
            layer.hx = -1;
            layer.hy = -1;
        }
        SRPORT port = net.ports;
        while (port != null) {
            port.wavefront = null;
            port = port.next;
        }
    }

    private SRREGION defineRegion(Cell cell, Network net, int lX, int lY, int hX, int hY, Set arcsToDelete, Set nodesToDelete) {
        SRREGION region = this.getRegion(lX -= this.mazeBoundary, lY -= this.mazeBoundary, hX += this.mazeBoundary, hY += this.mazeBoundary);
        if (region == null) {
            System.out.println("Could not allocate routing region (" + lX + "<=X<=" + hX + " " + lY + "<=Y<=" + hY + ")");
            return null;
        }
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
        Visitor wcVisitor = new Visitor(searchBounds, region, net);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)wcVisitor);
        return region;
    }

    private void drawArcInst(ArcInst ai, AffineTransform trans, SRREGION region) {
        if (ai.getProto() == Generic.tech().unrouted_arc) {
            return;
        }
        Technology tech = ai.getProto().getTechnology();
        for (Poly poly : tech.getShapeOfArc(ai)) {
            poly.transform(trans);
            Point2D[] points = poly.getPoints();
            if (points[0].getX() == points[1].getX()) {
                this.drawPoly(poly, region, 1);
                continue;
            }
            if (points[0].getY() == points[1].getY()) {
                this.drawPoly(poly, region, 0);
                continue;
            }
            this.drawPoly(poly, region, 2);
        }
    }

    private SRPORT addPort(SRNET net, int layers, double cX, double cY, PortInst pi) {
        SRPORT port = new SRPORT();
        port.cX = cX;
        port.cY = cY;
        port.lx = (int)cX;
        port.hx = (int)cX;
        port.ly = (int)cY;
        port.hy = (int)cY;
        port.layers = layers;
        port.wavefront = null;
        int index = 0;
        int mask = 1;
        while (index < 64) {
            if (layers != 0 & mask != 0 && net.region.layers[index] != null) {
                this.setBox(net.region.layers[index], 144, port.lx, port.ly, port.hx, port.hy, true);
            }
            ++index;
            mask <<= 1;
        }
        port.next = null;
        port.master = null;
        port.paths = null;
        port.lastpath = null;
        port.net = net;
        port.pi = pi;
        SRPORT lPort = net.ports;
        int index2 = 0;
        if (lPort == null) {
            net.ports = port;
        } else {
            index2 = 1;
            while (lPort.next != null) {
                ++index2;
                lPort = lPort.next;
            }
            lPort.next = port;
        }
        port.index = index2;
        return port;
    }

    private int determineDir(NodeInst ni, double cX, double cY) {
        double pDY;
        if (ni == null) {
            return 3;
        }
        double nCX = ni.getTrueCenterX();
        double nCY = ni.getTrueCenterY();
        if (nCX == cX && nCY == cY) {
            return 3;
        }
        double dX = ni.getBounds().getMaxX() - nCX;
        double dY = ni.getBounds().getMaxY() - nCY;
        double pDX = Math.abs(cX - nCX);
        double area = pDX * dY - (pDY = Math.abs(cY - nCY)) * dX;
        if (area > 0.0) {
            return 1;
        }
        if (area < 0.0) {
            return 2;
        }
        return 3;
    }

    private SRNET addNet(SRREGION region, Network eNet) {
        SRNET srNet = new SRNET();
        srNet.routed = false;
        srNet.eNet = eNet;
        srNet.ports = null;
        srNet.paths = null;
        srNet.lastpath = null;
        srNet.region = region;
        srNet.next = region.nets;
        region.nets = srNet;
        return srNet;
    }

    private void drawPoly(Poly obj, SRREGION region, int layer) {
        if (obj.getLayer() != this.mazeVertLayer && obj.getLayer() != this.mazeHorizLayer) {
            return;
        }
        Point2D[] points = obj.getPoints();
        if (obj.getStyle() == Poly.Type.CIRCLE || obj.getStyle() == Poly.Type.THICKCIRCLE || obj.getStyle() == Poly.Type.DISC) {
            double radius = points[0].distance(points[1]);
            Rectangle2D.Double circleBounds = new Rectangle2D.Double(points[0].getX() - radius, points[0].getY() - radius, radius * 2.0, radius * 2.0);
            this.drawBox(circleBounds, layer, region);
            return;
        }
        if (obj.getStyle() == Poly.Type.CIRCLEARC || obj.getStyle() == Poly.Type.THICKCIRCLEARC) {
            if (points.length == 0) {
                return;
            }
            if (points.length % 3 != 0) {
                return;
            }
            for (int i = 0; i < points.length; i += 3) {
                Point2D si = GenMath.computeArcCenter(points[i], points[i + 1], points[i + 2]);
                this.drawLine(points[i + 1], si, layer, region);
                this.drawLine(si, points[i + 2], layer, region);
            }
            return;
        }
        if (obj.getStyle() == Poly.Type.FILLED || obj.getStyle() == Poly.Type.CLOSED) {
            Rectangle2D objBounds = obj.getBox();
            if (objBounds != null) {
                this.drawBox(objBounds, layer, region);
                return;
            }
            for (int i = 1; i < points.length; ++i) {
                this.drawLine(points[i - 1], points[i], layer, region);
            }
            if (points.length > 2) {
                this.drawLine(points[points.length - 1], points[0], layer, region);
            }
            return;
        }
        if (obj.getStyle() == Poly.Type.OPENED || obj.getStyle() == Poly.Type.OPENEDT1 || obj.getStyle() == Poly.Type.OPENEDT1 || obj.getStyle() == Poly.Type.OPENEDT3) {
            Rectangle2D objBounds = obj.getBox();
            if (objBounds != null) {
                this.drawBox(objBounds, layer, region);
                return;
            }
            for (int i = 1; i < points.length; ++i) {
                this.drawLine(points[i - 1], points[i], layer, region);
            }
            return;
        }
        if (obj.getStyle() == Poly.Type.VECTORS) {
            for (int i = 1; i < points.length; i += 2) {
                this.drawLine(points[i - 1], points[i], layer, region);
            }
            return;
        }
    }

    private void drawBox(Rectangle2D box, int layer, SRREGION region) {
        int lX = (int)Math.floor(box.getMinX() - this.mazeBloat);
        int hX = (int)Math.ceil(box.getMaxX() + this.mazeBloat);
        int lY = (int)Math.floor(box.getMinY() - this.mazeBloat);
        int hY = (int)Math.ceil(box.getMaxY() + this.mazeBloat);
        if (layer == 0 || layer == 2) {
            this.setBox(region.layers[0], 128, lX, lY, hX, hY, false);
        }
        if (layer == 1 || layer == 2) {
            this.setBox(region.layers[1], 128, lX, lY, hX, hY, false);
        }
    }

    private void drawLine(Point2D from, Point2D to, int layer, SRREGION region) {
        double wX1 = from.getX();
        double wY1 = from.getY();
        double wX2 = to.getX();
        double wY2 = to.getY();
        if (layer == 0 || layer == 2) {
            this.setLine(region.layers[0], 128, wX1, wY1, wX2, wY2, false);
        }
        if (layer == 1 || layer == 2) {
            this.setLine(region.layers[1], 128, wX1, wY1, wX2, wY2, false);
        }
    }

    private void setLine(SRLAYER layer, int type, double wX1, double wY1, double wX2, double wY2, boolean orMode) {
        int dX;
        int dY;
        int[] x = new int[2];
        int[] y = new int[2];
        x[0] = this.getGridX((int)wX1, layer);
        x[1] = this.getGridX((int)wX2, layer);
        y[0] = this.getGridY((int)wY1, layer);
        y[1] = this.getGridY((int)wY2, layer);
        int lx = 1;
        int hx = 0;
        if (wX1 < wX2) {
            lx = 0;
            hx = 1;
        }
        int ly = 1;
        int hy = 0;
        if (wY1 < wY2) {
            ly = 0;
            hy = 1;
        }
        if (x[hx] < 0 || x[lx] >= layer.wid || y[hy] < 0 || y[ly] >= layer.hei) {
            return;
        }
        if (x[lx] < 0) {
            int n = lx;
            y[n] = y[n] - (y[hx] - y[lx]) * x[lx] / (x[hx] - x[lx]);
            x[lx] = 0;
        }
        if (x[hx] >= layer.wid) {
            int n = hx;
            y[n] = y[n] - (y[hx] - y[lx]) * (x[hx] - (layer.wid - 1)) / (x[hx] - x[lx]);
            x[hx] = layer.wid - 1;
        }
        if (y[ly] < 0) {
            int n = ly;
            x[n] = x[n] - (x[hy] - x[ly]) * y[ly] / (y[hy] - y[ly]);
            y[ly] = 0;
        }
        if (y[hy] >= layer.hei) {
            int n = hy;
            x[n] = x[n] - (x[hy] - x[ly]) * (y[hy] - (layer.hei - 1)) / (y[hy] - y[ly]);
            y[hy] = layer.hei - 1;
        }
        if ((dY = y[hy] - y[ly]) < (dX = x[hx] - x[lx])) {
            int e = (dY << 1) - dX;
            int yi = y[lx];
            int diff = 1;
            if (y[hx] < y[lx]) {
                diff = -1;
            }
            for (int xi = x[lx]; xi <= x[hx]; ++xi) {
                this.setPoint(layer, type, xi, yi, orMode);
                if (e > 0) {
                    yi += diff;
                    e = e + (dY << 1) - (dX << 1);
                    continue;
                }
                e += dY << 1;
            }
        } else {
            int e = (dX << 1) - dY;
            int xi = x[ly];
            int diff = 1;
            if (x[hy] < x[ly]) {
                diff = -1;
            }
            for (int yi = y[ly]; yi <= y[hy]; ++yi) {
                this.setPoint(layer, type, xi, yi, orMode);
                if (e > 0) {
                    xi += diff;
                    e = e + (dX << 1) - (dY << 1);
                    continue;
                }
                e += dX << 1;
            }
        }
    }

    private void setBox(SRLAYER layer, int type, int wX1, int wY1, int wX2, int wY2, boolean orMode) {
        int x;
        int lX = this.getGridX(wX1, layer);
        int lY = this.getGridY(wY1, layer);
        int hX = this.getGridX(wX2, layer);
        int hY = this.getGridY(wY2, layer);
        if (lX > hX) {
            x = lX;
            lX = hX;
            hX = x;
        }
        if (lY > hY) {
            int y = lY;
            lY = hY;
            hY = y;
        }
        if (hX < 0 || lX >= layer.wid || hY < 0 || lY >= layer.hei) {
            return;
        }
        if (lX < 0) {
            lX = 0;
        }
        if (hX >= layer.wid) {
            hX = layer.wid - 1;
        }
        if (lY < 0) {
            lY = 0;
        }
        if (hY >= layer.hei) {
            hY = layer.hei - 1;
        }
        for (x = lX; x <= hX; ++x) {
            for (int y = lY; y <= hY; ++y) {
                this.setPoint(layer, type, x, y, orMode);
            }
        }
    }

    private void setPoint(SRLAYER layer, int type, int x, int y, boolean orMode) {
        if (orMode) {
            byte[] byArray = layer.grids[x];
            int n = y;
            byArray[n] = (byte)(byArray[n] | type);
            int n2 = x;
            layer.vused[n2] = (byte)(layer.vused[n2] | type);
            int n3 = y;
            layer.hused[n3] = (byte)(layer.hused[n3] | type);
        } else {
            layer.grids[x][y] = (byte)type;
            layer.vused[x] = (byte)type;
            layer.hused[y] = (byte)type;
        }
    }

    private SRREGION getRegion(int wLX, int wLY, int wHX, int wHY) {
        if (wLX > wHX || wLY > wHY) {
            return null;
        }
        if (this.theRegion == null) {
            this.theRegion = new SRREGION();
            for (int index = 0; index < 64; ++index) {
                this.theRegion.layers[index] = null;
            }
            this.theRegion.nets = null;
        } else {
            this.cleanoutRegion(this.theRegion);
        }
        this.theRegion.lx = wLX;
        this.theRegion.hx = wHX;
        this.theRegion.ly = wLY;
        this.theRegion.hy = wHY;
        SRLAYER hlayer = this.addLayer(this.theRegion, 0, this.SRHORIPREF);
        if (hlayer == null) {
            System.out.println("Could not allocate horizontal layer");
            return null;
        }
        SRLAYER vlayer = this.addLayer(this.theRegion, 1, this.SRVERTPREF);
        if (vlayer == null) {
            System.out.println("Could not allocate vertical layer");
            return null;
        }
        return this.theRegion;
    }

    private void cleanoutRegion(SRREGION region) {
        region.nets = null;
    }

    private SRLAYER addLayer(SRREGION region, int index, SRDIRECTION direction) {
        SRLAYER alayer;
        SRLAYER layer = region.layers[index];
        if (layer == null) {
            region.layers[index] = layer = new SRLAYER();
            layer.grids = null;
            layer.vused = null;
            layer.hused = null;
        }
        layer.index = index;
        layer.mask = 1 << index;
        layer.dir = direction;
        int lX = region.lx - 1;
        int lY = region.ly - 1;
        int hX = region.hx + 1;
        int hY = region.hy + 1;
        layer.wid = hX - lX + 1;
        layer.hei = hY - lY + 1;
        layer.transx = lX;
        layer.transy = lY;
        if (layer.wid > 1000 || layer.hei > 1000) {
            System.out.println("This route is too large to solve (limit is 1000x1000 grid, this is " + layer.wid + "x" + layer.hei + ")");
            return null;
        }
        if (this.getWorldX(layer.wid - 1, layer) > region.hx) {
            --layer.wid;
        }
        if (this.getWorldY(layer.hei - 1, layer) > region.hy) {
            --layer.hei;
        }
        layer.grids = new byte[layer.wid][];
        layer.vused = new byte[layer.wid];
        for (int x = 0; x < layer.wid; ++x) {
            layer.grids[x] = new byte[layer.hei];
            for (int y = 0; y < layer.hei; ++y) {
                layer.grids[x][y] = 0;
            }
            layer.vused[x] = 0;
        }
        layer.hused = new byte[layer.hei];
        for (int y = 0; y < layer.hei; ++y) {
            layer.hused[y] = 0;
        }
        layer.down = null;
        layer.up = null;
        if (index != 0 && (alayer = region.layers[index - 1]) != null) {
            layer.down = alayer;
            alayer.up = layer;
        }
        if (index < 63 && (alayer = region.layers[index + 1]) != null) {
            layer.up = alayer;
            alayer.down = layer;
        }
        return layer;
    }

    private int getGridX(int Mv, SRLAYER Ml) {
        return Mv - Ml.transx;
    }

    private int getGridY(int Mv, SRLAYER Ml) {
        return Mv - Ml.transy;
    }

    private int getWorldX(int Mv, SRLAYER Ml) {
        return Mv + Ml.transx;
    }

    private int getWorldY(int Mv, SRLAYER Ml) {
        return Mv + Ml.transy;
    }

    private boolean extractPaths(Cell parent, SRNET net) {
        double fX = 0.0;
        double fY = 0.0;
        SRPATH path = net.paths;
        while (path != null) {
            if (path.type != this.SRPFIXED) {
                PortInst pi;
                Poly portPoly;
                Point2D closest;
                List<PortInst> portInstList;
                ArcProto ap;
                Point2D closest2;
                Poly portPoly2;
                SRPORT port = path.port;
                fX = path.wx[0];
                fY = path.wy[0];
                double oFX = fX;
                double oFY = fY;
                if (path.end[0] && port.pi != null) {
                    portPoly2 = port.pi.getPoly();
                    closest2 = portPoly2.closestPoint(new Point2D.Double(fX, fY));
                    if (closest2.getX() != oFX || closest2.getY() != oFY) {
                        this.adjustPath(net.paths, path, 0, closest2.getX() - oFX, closest2.getY() - oFY);
                    }
                } else {
                    ap = path.layer.index != 0 ? this.mazeVertWire : this.mazeHorizWire;
                    portInstList = this.findPort(parent, fX, fY, ap, net, true);
                    if (portInstList.size() > 0 && ((closest = (portPoly = (pi = portInstList.get(0)).getPoly()).closestPoint(new Point2D.Double(fX, fY))).getX() != oFX || closest.getY() != oFY)) {
                        this.adjustPath(net.paths, path, 0, closest.getX() - oFX, closest.getY() - oFY);
                    }
                }
                fX = oFX = path.wx[1];
                fY = oFY = path.wy[1];
                if (path.end[1] && port.pi != null) {
                    portPoly2 = port.pi.getPoly();
                    closest2 = portPoly2.closestPoint(new Point2D.Double(fX, fY));
                    if (closest2.getX() != oFX || closest2.getY() != oFY) {
                        this.adjustPath(net.paths, path, 1, closest2.getX() - oFX, closest2.getY() - oFY);
                    }
                } else {
                    ap = path.layer.index != 0 ? this.mazeVertWire : this.mazeHorizWire;
                    portInstList = this.findPort(parent, fX, fY, ap, net, true);
                    if (portInstList.size() > 0 && ((closest = (portPoly = (pi = portInstList.get(0)).getPoly()).closestPoint(new Point2D.Double(fX, fY))).getX() != oFX || closest.getY() != oFY)) {
                        this.adjustPath(net.paths, path, 1, closest.getX() - oFX, closest.getY() - oFY);
                    }
                }
            }
            path = path.next;
        }
        path = net.paths;
        while (path != null) {
            if (path.type != this.SRPFIXED) {
                PortInst tPi;
                PortInst fPi;
                ArcInst ai;
                ArcProto ap = path.layer.index != 0 ? this.mazeVertWire : this.mazeHorizWire;
                SRPORT port = path.port;
                List<Object> fromPortInstList = null;
                fX = path.wx[0];
                fY = path.wy[0];
                if (path.end[0] && port.pi != null) {
                    fromPortInstList = new ArrayList<PortInst>();
                    fromPortInstList.add(port.pi);
                } else {
                    fromPortInstList = this.findPort(parent, fX, fY, ap, net, false);
                    if (fromPortInstList.size() == 0) {
                        double yS;
                        double xS = this.mazeSteinerNode.getDefWidth();
                        NodeInst ni = NodeInst.makeInstance(this.mazeSteinerNode, new Point2D.Double(fX, fY), xS, yS = this.mazeSteinerNode.getDefHeight(), parent);
                        if (ni == null) {
                            System.out.println("Could not create pin");
                            return true;
                        }
                        fromPortInstList.add(ni.getPortInst(0));
                    }
                }
                List<Object> toPortInstList = null;
                double tX = path.wx[1];
                double tY = path.wy[1];
                if (path.end[1] && port.pi != null) {
                    toPortInstList = new ArrayList<PortInst>();
                    toPortInstList.add(port.pi);
                } else {
                    toPortInstList = this.findPort(parent, tX, tY, ap, net, false);
                    if (toPortInstList.size() == 0) {
                        double yS;
                        double xS = this.mazeSteinerNode.getDefWidth();
                        NodeInst ni = NodeInst.makeInstance(this.mazeSteinerNode, new Point2D.Double(tX, tY), xS, yS = this.mazeSteinerNode.getDefHeight(), parent);
                        if (ni == null) {
                            System.out.println("Could not create pin");
                            return true;
                        }
                        toPortInstList.add(ni.getPortInst(0));
                    }
                }
                if (fromPortInstList.size() > 0 && toPortInstList.size() > 0 && (ai = ArcInst.makeInstance(ap, fPi = (PortInst)fromPortInstList.get(0), tPi = (PortInst)toPortInstList.get(0), new Point2D.Double(fX, fY), new Point2D.Double(tX, tY), null)) == null) {
                    System.out.println("Could not create path (arc)");
                    return true;
                }
            }
            path = path.next;
        }
        return false;
    }

    private void adjustPath(SRPATH paths, SRPATH thisPath, int end, double dX, double dY) {
        SRPATH opath;
        double formerY;
        double formerX;
        double formerOther;
        double formerThis;
        if (dX != 0.0) {
            formerThis = thisPath.wx[end];
            formerOther = thisPath.wx[1 - end];
            int n = end;
            thisPath.wx[n] = thisPath.wx[n] + dX;
            if (formerThis == formerOther) {
                formerX = thisPath.wx[1 - end];
                formerY = thisPath.wy[1 - end];
                int n2 = 1 - end;
                thisPath.wx[n2] = thisPath.wx[n2] + dX;
                opath = paths;
                while (opath != null) {
                    if (opath.wx[0] == formerX && opath.wy[0] == formerY) {
                        this.adjustPath(paths, opath, 0, dX, 0.0);
                        break;
                    }
                    if (opath.wx[1] == formerX && opath.wy[1] == formerY) {
                        this.adjustPath(paths, opath, 1, dX, 0.0);
                        break;
                    }
                    opath = opath.next;
                }
            }
        }
        if (dY != 0.0) {
            formerThis = thisPath.wy[end];
            formerOther = thisPath.wy[1 - end];
            int n = end;
            thisPath.wy[n] = thisPath.wy[n] + dY;
            if (formerThis == formerOther) {
                formerX = thisPath.wx[1 - end];
                formerY = thisPath.wy[1 - end];
                int n3 = 1 - end;
                thisPath.wy[n3] = thisPath.wy[n3] + dY;
                opath = paths;
                while (opath != null) {
                    if (opath.wx[0] == formerX && opath.wy[0] == formerY) {
                        this.adjustPath(paths, opath, 0, 0.0, dY);
                        break;
                    }
                    if (opath.wx[1] == formerX && opath.wy[1] == formerY) {
                        this.adjustPath(paths, opath, 1, 0.0, dY);
                        break;
                    }
                    opath = opath.next;
                }
            }
        }
    }

    private List<PortInst> findPort(Cell cell, double x, double y, ArcProto ap, SRNET srnet, boolean forceFind) {
        ArrayList<PortInst> portInstList = new ArrayList<PortInst>();
        Point2D.Double searchPoint = new Point2D.Double(x, y);
        double bestDist = 0.0;
        PortInst closestPi = null;
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(x - 0.5, y - 0.5, 1.0, 1.0);
        Iterator<RTBounds> sea = cell.searchIterator(searchBounds);
        while (sea.hasNext()) {
            RTBounds geom = sea.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                Poly portPoly = pi.getPoly();
                if (portPoly.isInside(searchPoint)) {
                    if (!pi.getPortProto().getBasePort().connectsTo(ap)) continue;
                    portInstList.add(pi);
                    continue;
                }
                double dist = portPoly.polyDistance(new Rectangle2D.Double(x, y, 0.0, 0.0));
                if (closestPi != null && !(dist < bestDist)) continue;
                bestDist = dist;
                closestPi = pi;
            }
        }
        if (portInstList.size() == 0 && forceFind && closestPi != null && bestDist < 1.0) {
            portInstList.add(closestPi);
        }
        return portInstList;
    }

    private class Visitor
    extends HierarchyEnumerator.Visitor {
        private Rectangle2D searchBounds;
        private SRREGION region;
        private int notThisNetID;

        public Visitor(Rectangle2D searchBounds, SRREGION region, Network net) {
            this.searchBounds = searchBounds;
            this.region = region;
            this.notThisNetID = net.getNetIndex();
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Netlist nl = info.getNetlist();
            AffineTransform trans = info.getTransformToRoot();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                Network net = nl.getNetwork(ai, 0);
                int netID = info.getNetID(net);
                if (netID == this.notThisNetID) continue;
                Rectangle2D arcBounds = ai.getBounds();
                Rectangle2D.Double bounds = new Rectangle2D.Double(arcBounds.getMinX(), arcBounds.getMinY(), arcBounds.getWidth(), arcBounds.getHeight());
                DBMath.transformRect(bounds, trans);
                if (!bounds.intersects(this.searchBounds)) continue;
                Maze.this.drawArcInst(ai, trans, this.region);
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            AffineTransform trans = info.getTransformToRoot();
            Netlist nl = info.getNetlist();
            NodeInst ni = no.getNodeInst();
            Rectangle2D nodeBounds = ni.getBounds();
            Rectangle2D.Double bounds = new Rectangle2D.Double(nodeBounds.getMinX(), nodeBounds.getMinY(), nodeBounds.getWidth(), nodeBounds.getHeight());
            DBMath.transformRect(bounds, trans);
            if (!bounds.intersects(this.searchBounds)) {
                return false;
            }
            if (!ni.isCellInstance()) {
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, true, null);
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    int netID;
                    Poly poly = nodeInstPolyList[i];
                    PortProto pp = poly.getPort();
                    Network net = nl.getNetwork(no, pp, 0);
                    if (net != null && (netID = info.getNetID(net)) == this.notThisNetID) continue;
                    poly.transform(trans);
                    Maze.this.drawPoly(poly, this.region, 2);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MazeRouteJob
    extends Job {
        private Cell cell;
        private List<ArcInst> arcs;

        protected MazeRouteJob(Cell cell, List<ArcInst> arcs) {
            super("Maze Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.arcs = arcs;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Maze router = new Maze();
            router.routeSelected(this.cell, this.arcs);
            return true;
        }
    }

    static class SRWAVEPT {
        int x;
        int y;
        SRLAYER layer;
        SRPORT port;
        SRWAVEPT next;
        SRWAVEPT prev;

        SRWAVEPT() {
        }
    }

    static class SRPATH {
        int[] x = new int[2];
        int[] y = new int[2];
        double[] wx = new double[2];
        double[] wy = new double[2];
        SRLAYER layer;
        boolean[] end = new boolean[2];
        SRPTYPE type;
        SRPORT port;
        SRPATH next;

        SRPATH() {
        }
    }

    static class SRPORT {
        int index;
        long layers;
        double cX;
        double cY;
        int lx;
        int ly;
        int hx;
        int hy;
        PortInst pi;
        SRPORT master;
        SRPATH paths;
        SRPATH lastpath;
        SRWAVEPT wavefront;
        SRNET net;
        SRPORT next;

        SRPORT() {
        }
    }

    static class SRNET {
        boolean routed;
        Network eNet;
        SRREGION region;
        SRPORT ports;
        SRPATH paths;
        SRPATH lastpath;
        SRNET next;

        SRNET() {
        }
    }

    static class SRLAYER {
        byte[] hused;
        byte[] vused;
        int index;
        long mask;
        int transx;
        int transy;
        int wid;
        int hei;
        int lx;
        int ly;
        int hx;
        int hy;
        byte[][] grids;
        SRLAYER up;
        SRLAYER down;
        SRDIRECTION dir;

        SRLAYER() {
        }
    }

    static class SRREGION {
        int lx;
        int ly;
        int hx;
        int hy;
        SRLAYER[] layers = new SRLAYER[64];
        SRNET nets;

        SRREGION() {
        }
    }

    static class SRPTYPE {
        SRPTYPE() {
        }
    }

    static class SRDIRECTION {
        SRDIRECTION() {
        }
    }
}

