/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result.equivalence;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.NodaNets;
import com.sun.electric.tool.ncc.result.equivalence.InstancePathToNccContext;
import com.sun.electric.tool.ncc.result.equivalence.NccContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

class NetEquivalence
implements Serializable {
    static final long serialVersionUID = 0L;
    private final HierarchyEnumerator.NetNameProxy[][] equivNets;
    private final Cell[] nccRootCells;
    private final VarContext[] nccRootCtxts;
    private final int numDesigns;
    private final int numNets;
    private InstancePathToNccContext[] instToNetNccCtxt;
    private int lastDesignHit;

    private boolean nameMatch(HierarchyEnumerator.NetNameProxy prox, Network net) {
        Iterator<String> it = prox.leafNames();
        while (it.hasNext()) {
            String proxNm = it.next();
            if (!net.hasName(proxNm)) continue;
            return true;
        }
        return false;
    }

    private void pr(String s) {
        System.out.print(s);
    }

    private void prln(String s) {
        System.out.println(s);
    }

    private void buildNameTree() {
        if (this.instToNetNccCtxt != null) {
            return;
        }
        this.instToNetNccCtxt = new InstancePathToNccContext[this.numDesigns];
        for (int i = 0; i < this.numDesigns; ++i) {
            LayoutLib.error(this.equivNets[i].length != this.numNets, "designs don't have same numbers of nets?");
            this.instToNetNccCtxt[i] = new InstancePathToNccContext(this.equivNets[i]);
        }
    }

    public NetEquivalence(HierarchyEnumerator.NetNameProxy[][] equivNets, Cell[] nccRootCells, VarContext[] nccRootCtxts) {
        this.equivNets = equivNets;
        this.numDesigns = equivNets.length;
        this.numNets = equivNets[0].length;
        this.nccRootCells = nccRootCells;
        this.nccRootCtxts = nccRootCtxts;
    }

    private HierarchyEnumerator.NetNameProxy findEquivNet(VarContext vc, Network net, int designIndex) {
        LayoutLib.error(designIndex != 0 && designIndex != 1, "designIndex must be 0 or 1");
        this.buildNameTree();
        InstancePathToNccContext nameIndex = this.instToNetNccCtxt[designIndex];
        NccContext nc = nameIndex.findNccContext(vc);
        if (nc == null) {
            return null;
        }
        if (nc.getCell() != net.getParent()) {
            return null;
        }
        if (!nc.getContext().equals(vc)) {
            return null;
        }
        Iterator<Integer> it = nc.getIndices();
        while (it.hasNext()) {
            int index = it.next();
            HierarchyEnumerator.NetNameProxy prox = this.equivNets[designIndex][index];
            if (!this.nameMatch(prox, net)) continue;
            int equivDesign = designIndex == 0 ? 1 : 0;
            return this.equivNets[equivDesign][index];
        }
        return null;
    }

    private int countUnique() {
        HashSet<Network> networks = new HashSet<Network>();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < this.numNets; ++j) {
                networks.add(this.equivNets[i][j].getNet());
            }
        }
        return networks.size();
    }

    private NodaNets.NodaPortInst getPortFromUnshortedNet(Network n) {
        NodaNets noshortNets = new NodaNets(n.getParent(), false);
        Collection<NodaNets.NodaPortInst> ports = noshortNets.getPorts(n);
        Iterator<NodaNets.NodaPortInst> i$ = ports.iterator();
        if (i$.hasNext()) {
            NodaNets.NodaPortInst pi = i$.next();
            return pi;
        }
        LayoutLib.error(true, "No ports found on Network?");
        return null;
    }

    private Network netWhenResShorted(Network n) {
        if (n.getNetlist().getShortResistors()) {
            return null;
        }
        this.prln("    RK Debug: Try shorting resistors");
        NodaNets.NodaPortInst port = this.getPortFromUnshortedNet(n);
        NodaNets shortedNets = new NodaNets(n.getParent(), true);
        Nodable no = shortedNets.getNoda(port.getNodable().getName());
        for (NodaNets.NodaPortInst pi : shortedNets.getPorts(no)) {
            if (pi.getIndex() != port.getIndex() || pi.getPortProto() != port.getPortProto()) continue;
            return pi.getNet();
        }
        this.prln("    RK Debug: Shorting resistors fails");
        return null;
    }

    public HierarchyEnumerator.NetNameProxy findEquivalentNet(VarContext vc, Network net) {
        HierarchyEnumerator.NetNameProxy nnp = this.findEquivNet(vc, net, this.lastDesignHit);
        if (nnp != null) {
            return nnp;
        }
        int otherDesign = this.lastDesignHit == 0 ? 1 : 0;
        nnp = this.findEquivNet(vc, net, otherDesign);
        if (nnp != null) {
            this.lastDesignHit = otherDesign;
            return nnp;
        }
        if (!net.isExported()) {
            return null;
        }
        HierarchyEnumerator.NetNameProxy higherNet = TraceConnectivityUpThroughExports.findHighestNet(net, vc, this.nccRootCells[this.lastDesignHit], this.nccRootCtxts[this.lastDesignHit]);
        if (higherNet != null && (nnp = this.findEquivNet(higherNet.getContext(), higherNet.getNet(), this.lastDesignHit)) != null) {
            return nnp;
        }
        higherNet = TraceConnectivityUpThroughExports.findHighestNet(net, vc, this.nccRootCells[otherDesign], this.nccRootCtxts[otherDesign]);
        if (higherNet != null && (nnp = this.findEquivNet(higherNet.getContext(), higherNet.getNet(), this.lastDesignHit)) != null) {
            this.lastDesignHit = otherDesign;
            return nnp;
        }
        return null;
    }

    public HierarchyEnumerator.NetNameProxy findEquivalentNetShortingResistors(VarContext vc, Network net) {
        HierarchyEnumerator.NetNameProxy eqProx = this.findEquivalentNet(vc, net);
        if (eqProx == null) {
            if ((net = this.netWhenResShorted(net)) == null) {
                return null;
            }
            eqProx = this.findEquivalentNet(vc, net);
            if (eqProx == null) {
                return null;
            }
        }
        return eqProx;
    }

    void clearCache() {
        this.instToNetNccCtxt = null;
    }

    public int regressionTest() {
        LayoutLib.error(this.numDesigns != 2, "we must have exactly two designs");
        int numErrors = 0;
        for (int desNdx = 0; desNdx < this.numDesigns; ++desNdx) {
            int otherDesign = desNdx == 0 ? 1 : 0;
            for (int netNdx = 0; netNdx < this.numNets; ++netNdx) {
                Network fromNet;
                HierarchyEnumerator.NetNameProxy from = this.equivNets[desNdx][netNdx];
                VarContext fromVc = from.getContext();
                HierarchyEnumerator.NetNameProxy to = this.findEquivalentNet(fromVc, fromNet = from.getNet());
                if (to == this.equivNets[otherDesign][netNdx]) continue;
                ++numErrors;
                this.prln("      From: " + from.toString());
                this.prln("      To: " + (to == null ? "null" : to.toString()));
                this.prln("      Equiv: " + this.equivNets[otherDesign][netNdx]);
            }
        }
        this.pr("    Net equivalence regression " + (numErrors == 0 ? "passed. " : "failed. "));
        this.pr(" Equiv table size=" + this.numNets + ". ");
        this.pr(" Num unique Networks=" + this.countUnique() + ". ");
        if (numErrors != 0) {
            System.out.print(numErrors + " errors.");
        }
        this.pr("\n");
        return numErrors;
    }

    private static class TraceConnectivityUpThroughExports
    extends HierarchyEnumerator.Visitor {
        private final String netNm;
        private final ArrayList<VarContext> netCtxtArray;
        private int curCtxtNdx;
        private String nameOfNodableToDescendInto;
        private boolean doneEnumerating;
        private HierarchyEnumerator.NetNameProxy highestEquivNet;

        private static ArrayList<VarContext> buildContextArray(VarContext ctxt) {
            LinkedList<VarContext> ll = new LinkedList<VarContext>();
            LayoutLib.error(ctxt == null, "buildContextArray: null ctxt not allowed");
            while (true) {
                ll.addFirst(ctxt);
                if (ctxt == VarContext.globalContext) break;
                ctxt = ctxt.pop();
            }
            ArrayList<VarContext> al = new ArrayList<VarContext>();
            al.addAll(ll);
            return al;
        }

        private Network findNetworkNamed(Netlist nl, String nm) {
            Iterator<Network> netIt = nl.getNetworks();
            while (netIt.hasNext()) {
                Network net = netIt.next();
                if (!net.hasName(nm)) continue;
                return net;
            }
            return null;
        }

        private TraceConnectivityUpThroughExports(String netNm, ArrayList<VarContext> netCtxtArray, int curCtxtNdx) {
            this.netNm = netNm;
            this.netCtxtArray = netCtxtArray;
            this.curCtxtNdx = curCtxtNdx;
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo ci) {
            if (this.doneEnumerating) {
                return false;
            }
            if (no.getName().equals(this.nameOfNodableToDescendInto)) {
                ++this.curCtxtNdx;
                return true;
            }
            return false;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo ci) {
            if (this.doneEnumerating) {
                return false;
            }
            if (this.curCtxtNdx == this.netCtxtArray.size() - 1) {
                this.doneEnumerating = true;
                Netlist nl = ci.getNetlist();
                Network net = this.findNetworkNamed(nl, this.netNm);
                if (net == null) {
                    return false;
                }
                this.highestEquivNet = ci.getUniqueNetNameProxy(net, "/");
                return false;
            }
            this.nameOfNodableToDescendInto = this.netCtxtArray.get(this.curCtxtNdx + 1).getNodable().getName();
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo ci) {
        }

        public static HierarchyEnumerator.NetNameProxy findHighestNet(Network net, VarContext netCtxt, Cell nccRootCell, VarContext nccRootCtxt) {
            ArrayList<VarContext> nccRootCtxtArray = TraceConnectivityUpThroughExports.buildContextArray(nccRootCtxt);
            ArrayList<VarContext> netCtxtArray = TraceConnectivityUpThroughExports.buildContextArray(netCtxt);
            int nccRootDepth = nccRootCtxtArray.size();
            if (netCtxtArray.size() < nccRootDepth || !netCtxtArray.get(nccRootDepth - 1).equals(nccRootCtxt)) {
                return null;
            }
            TraceConnectivityUpThroughExports visitor = new TraceConnectivityUpThroughExports(net.getName(), netCtxtArray, nccRootDepth - 1);
            HierarchyEnumerator.enumerateCell(nccRootCell, nccRootCtxt, visitor);
            return visitor.highestEquivNet;
        }
    }
}

