/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewArcsTab
extends PreferencePanel {
    private HashMap<ArcProto, PrimArcInfo> initialNewArcsPrimInfo;
    private boolean newArcsDataChanging = false;
    private Technology selectedTech;
    private JLabel angleLabel;
    private JTextField arcAngle;
    private JCheckBox arcDirectional;
    private JCheckBox arcEndsExtend;
    private JCheckBox arcFixedAngle;
    private JLabel arcName;
    private JLabel arcName1;
    private JComboBox arcPin;
    private JComboBox arcProtoList;
    private JCheckBox arcRigid;
    private JCheckBox arcSlidable;
    private JTextField arcWidth;
    private JLabel arcWidthLabel;
    private JCheckBox incrementArcNames;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel8;
    private JSeparator jSeparator1;
    private JPanel newArc;
    private JLabel pinLabel;
    private JCheckBox playClickSounds;
    private JComboBox technologySelection;

    public NewArcsTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.newArc;
    }

    public String getName() {
        return "Arcs";
    }

    public void init() {
        this.initialNewArcsPrimInfo = new HashMap();
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            this.technologySelection.addItem(tech.getTechName());
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                PrimArcInfo pai = new PrimArcInfo();
                pai.initialRigid = pai.rigid = ap.isRigid();
                pai.initialFixedAngle = pai.fixedAngle = ap.isFixedAngle();
                pai.initialSlidable = pai.slidable = ap.isSlidable();
                pai.initialDirectional = pai.directional = ap.isDirectional();
                pai.initialEndsExtend = pai.endsExtend = ap.isExtended();
                pai.initialWid = pai.wid = ap.getDefaultWidth();
                pai.initialAngleIncrement = pai.angleIncrement = ap.getAngleIncrement();
                pai.initialPin = pai.pin = ap.findOverridablePinProto();
                this.initialNewArcsPrimInfo.put(ap, pai);
            }
        }
        this.technologySelection.setSelectedItem(Technology.getCurrent().getTechName());
        this.selectedTech = null;
        this.newArcsPrimPopupChanged();
        this.technologySelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimPopupChanged();
            }
        });
        this.arcProtoList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimPopupChanged();
            }
        });
        this.arcRigid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimDataChanged();
            }
        });
        this.arcFixedAngle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimDataChanged();
            }
        });
        this.arcSlidable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimDataChanged();
            }
        });
        this.arcDirectional.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimDataChanged();
            }
        });
        this.arcEndsExtend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimDataChanged();
            }
        });
        this.arcWidth.getDocument().addDocumentListener(new NewArcDocumentListener(this));
        this.arcAngle.getDocument().addDocumentListener(new NewArcDocumentListener(this));
        this.arcPin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewArcsTab.this.newArcsPrimDataChanged();
            }
        });
        this.playClickSounds.setSelected(User.isPlayClickSoundsWhenCreatingArcs());
        this.incrementArcNames.setSelected(User.isArcsAutoIncremented());
    }

    private void newArcsPrimPopupChanged() {
        String primName;
        PrimArcInfo pai;
        ArcProto ap;
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        if (tech != this.selectedTech) {
            this.selectedTech = tech;
            this.arcProtoList.removeAllItems();
            this.arcPin.removeAllItems();
            Iterator<Comparable<ArcProto>> it = tech.getArcs();
            while (it.hasNext()) {
                ap = it.next();
                this.arcProtoList.addItem(ap.getName());
            }
            it = tech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                this.arcPin.addItem(np.getName());
            }
        }
        if ((pai = this.initialNewArcsPrimInfo.get(ap = tech.findArcProto(primName = (String)this.arcProtoList.getSelectedItem()))) == null) {
            return;
        }
        this.newArcsDataChanging = true;
        this.arcRigid.setSelected(pai.rigid);
        this.arcFixedAngle.setSelected(pai.fixedAngle);
        this.arcSlidable.setSelected(pai.slidable);
        this.arcDirectional.setSelected(pai.directional);
        this.arcEndsExtend.setSelected(pai.endsExtend);
        this.arcWidth.setText(TextUtils.formatDouble(pai.wid));
        this.arcAngle.setText(Integer.toString(pai.angleIncrement));
        this.arcPin.setSelectedItem(pai.pin.getName());
        this.newArcsDataChanging = false;
    }

    private void newArcsPrimDataChanged() {
        if (this.newArcsDataChanging) {
            return;
        }
        String techName = (String)this.technologySelection.getSelectedItem();
        Technology tech = Technology.findTechnology(techName);
        if (tech == null) {
            return;
        }
        String primName = (String)this.arcProtoList.getSelectedItem();
        ArcProto ap = tech.findArcProto(primName);
        PrimArcInfo pai = this.initialNewArcsPrimInfo.get(ap);
        if (pai == null) {
            return;
        }
        pai.rigid = this.arcRigid.isSelected();
        pai.fixedAngle = this.arcFixedAngle.isSelected();
        pai.slidable = this.arcSlidable.isSelected();
        pai.directional = this.arcDirectional.isSelected();
        pai.endsExtend = this.arcEndsExtend.isSelected();
        pai.wid = TextUtils.atof(this.arcWidth.getText());
        pai.angleIncrement = TextUtils.atoi(this.arcAngle.getText());
        pai.pin = tech.findNodeProto((String)this.arcPin.getSelectedItem());
        PortProto pp = pai.pin.getPorts().next();
        if (!pp.connectsTo(ap)) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use " + pai.pin.getName() + " as a pin because it does not connect to " + ap.getName() + " arcs");
            pai.pin = pai.initialPin;
            this.arcPin.setSelectedItem(pai.pin.getName());
        }
    }

    public void term() {
        Iterator<Technology> tIt = Technology.getTechnologies();
        while (tIt.hasNext()) {
            Technology tech = tIt.next();
            Iterator<ArcProto> it = tech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                PrimArcInfo pai = this.initialNewArcsPrimInfo.get(ap);
                if (pai.rigid != pai.initialRigid) {
                    ap.setRigid(pai.rigid);
                }
                if (pai.fixedAngle != pai.initialFixedAngle) {
                    ap.setFixedAngle(pai.fixedAngle);
                }
                if (pai.slidable != pai.initialSlidable) {
                    ap.setSlidable(pai.slidable);
                }
                if (pai.directional != pai.initialDirectional) {
                    ap.setDirectional(pai.directional);
                }
                if (pai.endsExtend != pai.initialEndsExtend) {
                    ap.setExtended(pai.endsExtend);
                }
                if (pai.wid != pai.initialWid) {
                    ap.setDefaultWidth(pai.wid);
                }
                if (pai.angleIncrement != pai.initialAngleIncrement) {
                    ap.setAngleIncrement(pai.angleIncrement);
                }
                if (pai.pin == pai.initialPin) continue;
                ap.setPinProto(pai.pin);
            }
        }
        boolean currBoolean = this.playClickSounds.isSelected();
        if (currBoolean != User.isPlayClickSoundsWhenCreatingArcs()) {
            User.setPlayClickSoundsWhenCreatingArcs(currBoolean);
        }
        if ((currBoolean = this.incrementArcNames.isSelected()) != User.isArcsAutoIncremented()) {
            User.setArcsAutoIncremented(currBoolean);
        }
    }

    private void initComponents() {
        this.newArc = new JPanel();
        this.jPanel8 = new JPanel();
        this.arcWidthLabel = new JLabel();
        this.pinLabel = new JLabel();
        this.arcWidth = new JTextField();
        this.angleLabel = new JLabel();
        this.arcAngle = new JTextField();
        this.arcPin = new JComboBox();
        this.arcProtoList = new JComboBox();
        this.arcName = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.arcRigid = new JCheckBox();
        this.arcFixedAngle = new JCheckBox();
        this.arcDirectional = new JCheckBox();
        this.arcSlidable = new JCheckBox();
        this.arcEndsExtend = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.technologySelection = new JComboBox();
        this.arcName1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.playClickSounds = new JCheckBox();
        this.incrementArcNames = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                NewArcsTab.this.closeDialog(evt);
            }
        });
        this.newArc.setLayout(new GridBagLayout());
        this.jPanel8.setLayout(new GridBagLayout());
        this.jPanel8.setBorder(new TitledBorder("For New Arcs"));
        this.jPanel8.setDoubleBuffered(false);
        this.arcWidthLabel.setText("Default width:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcWidthLabel, gridBagConstraints);
        this.pinLabel.setText("Pin:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.pinLabel, gridBagConstraints);
        this.arcWidth.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcWidth, gridBagConstraints);
        this.angleLabel.setText("Placement angle:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.angleLabel, gridBagConstraints);
        this.arcAngle.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcAngle, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcPin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcProtoList, gridBagConstraints);
        this.arcName.setText("Arc Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.jSeparator1, gridBagConstraints);
        this.arcRigid.setText("Rigid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcRigid, gridBagConstraints);
        this.arcFixedAngle.setText("Fixed-angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcFixedAngle, gridBagConstraints);
        this.arcDirectional.setText("Directional");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcDirectional, gridBagConstraints);
        this.arcSlidable.setText("Slidable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcSlidable, gridBagConstraints);
        this.arcEndsExtend.setText("Ends extended");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcEndsExtend, gridBagConstraints);
        this.jLabel1.setText("Default State");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.technologySelection, gridBagConstraints);
        this.arcName1.setText("Technology:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel8.add((Component)this.arcName1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.newArc.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder("For All Arcs"));
        this.playClickSounds.setText("Play \"click\" sounds when arcs are created");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.playClickSounds, gridBagConstraints);
        this.incrementArcNames.setText("Duplicate/Array/Paste increments arc names");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.incrementArcNames, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.newArc.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.newArc, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class NewArcDocumentListener
    implements DocumentListener {
        NewArcsTab dialog;

        NewArcDocumentListener(NewArcsTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.newArcsPrimDataChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.newArcsPrimDataChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.newArcsPrimDataChanged();
        }
    }

    private static class PrimArcInfo {
        boolean initialRigid;
        boolean rigid;
        boolean initialFixedAngle;
        boolean fixedAngle;
        boolean initialSlidable;
        boolean slidable;
        boolean initialDirectional;
        boolean directional;
        boolean initialEndsExtend;
        boolean endsExtend;
        double initialWid;
        double wid;
        int initialAngleIncrement;
        int angleIncrement;
        PrimitiveNode initialPin;
        PrimitiveNode pin;

        private PrimArcInfo() {
        }
    }
}

