/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.TimedSignal;
import java.awt.geom.Rectangle2D;

public class DigitalSignal
extends TimedSignal {
    private int[] state;

    public DigitalSignal(Analysis an) {
        super(an);
    }

    public void buildState(int numEvents) {
        this.state = new int[numEvents];
    }

    public void setState(int index, int st) {
        this.state[index] = st;
        this.bounds = null;
    }

    public int getState(int index) {
        return this.state[index];
    }

    public int[] getStateVector() {
        return this.state;
    }

    public void setStateVector(int[] state) {
        this.state = state;
        this.bounds = null;
    }

    public int getNumEvents() {
        if (this.state == null) {
            return 0;
        }
        return this.state.length;
    }

    protected void calcBounds() {
        boolean first = true;
        double lowTime = 0.0;
        double highTime = 0.0;
        if (this.state != null) {
            for (int i = 0; i < this.state.length; ++i) {
                double time = this.getTime(i);
                if (first) {
                    first = false;
                    lowTime = highTime = time;
                    continue;
                }
                if (time < lowTime) {
                    lowTime = time;
                }
                if (!(time > highTime)) continue;
                highTime = time;
            }
        }
        this.bounds = new Rectangle2D.Double(lowTime, 0.0, highTime - lowTime, 1.0);
    }
}

