/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.basic;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.basic.CellContext;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CellUsage
extends HierarchyEnumerator.Visitor {
    private Map cellsInUse = new HashMap();
    private List cellsInRevTopoOrder = new ArrayList();
    private Map groupToAdditions = new HashMap();
    private Cell root;
    private Set singleUseCells;

    private void processCellGroupAdditions(CellContext cellCtxt) {
        NccCellAnnotations ann = NccCellAnnotations.getAnnotations(cellCtxt.cell);
        if (ann == null) {
            return;
        }
        Cell.CellGroup group = ann.getGroupToJoin();
        if (group == null) {
            return;
        }
        HashSet<CellContext> additions = (HashSet<CellContext>)this.groupToAdditions.get(group);
        if (additions == null) {
            additions = new HashSet<CellContext>();
            this.groupToAdditions.put(group, additions);
        }
        additions.add(cellCtxt);
    }

    public boolean enterCell(HierarchyEnumerator.CellInfo info) {
        Cell cell = info.getCell();
        if (this.root == null) {
            this.root = cell;
        }
        VarContext context = info.getContext();
        if (this.cellsInUse.containsKey(cell)) {
            return false;
        }
        CellContext cellCtxt = new CellContext(cell, context);
        this.cellsInUse.put(cell, cellCtxt);
        this.processCellGroupAdditions(cellCtxt);
        return true;
    }

    public void exitCell(HierarchyEnumerator.CellInfo info) {
        this.cellsInRevTopoOrder.add(info.getCell());
    }

    public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
        return true;
    }

    private void addUse(Set usedOnce, Set usedMoreThanOnce, Cell c) {
        if (usedMoreThanOnce.contains(c)) {
            return;
        }
        if (usedOnce.contains(c)) {
            usedOnce.remove(c);
            usedMoreThanOnce.add(c);
        } else {
            usedOnce.add(c);
        }
    }

    private void findSingleUseCells() {
        HashMap cellToUsedOnce = new HashMap();
        HashSet usedMoreThanOnce = new HashSet();
        Iterator it = this.cellsInReverseTopologicalOrder();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            HashSet usedOnce = new HashSet();
            Iterator ni = c.getNetlist(true).getNodables();
            while (ni.hasNext()) {
                NodeProto np = ((Nodable)ni.next()).getProto();
                if (!(np instanceof Cell)) continue;
                Cell child = (Cell)np;
                this.addUse(usedOnce, usedMoreThanOnce, child);
                if (!cellToUsedOnce.containsKey(child)) continue;
                Set childUsedOnce = (Set)cellToUsedOnce.get(child);
                Iterator ci = childUsedOnce.iterator();
                while (ci.hasNext()) {
                    this.addUse(usedOnce, usedMoreThanOnce, (Cell)ci.next());
                }
            }
            cellToUsedOnce.put(c, usedOnce);
            if (it.hasNext()) continue;
            this.singleUseCells = new HashSet();
            this.singleUseCells.add(c);
            this.singleUseCells.addAll(usedOnce);
        }
    }

    private CellUsage() {
    }

    public static CellUsage getCellUsage(CellContext root) {
        CellUsage visitor = new CellUsage();
        HierarchyEnumerator.enumerateCell(root.cell, root.context, visitor);
        visitor.findSingleUseCells();
        return visitor;
    }

    public boolean cellIsUsed(Cell cell) {
        return this.cellsInUse.containsKey(cell);
    }

    public boolean cellIsUsedOnce(Cell cell) {
        return this.singleUseCells.contains(cell);
    }

    public Iterator cellsInReverseTopologicalOrder() {
        return this.cellsInRevTopoOrder.iterator();
    }

    public CellContext getCellContext(Cell cell) {
        LayoutLib.error(!this.cellsInUse.containsKey(cell), "cell not found");
        return (CellContext)this.cellsInUse.get(cell);
    }

    public Set getGroupAdditions(Cell.CellGroup group) {
        Set additions = (Set)this.groupToAdditions.get(group);
        return additions != null ? additions : new HashSet();
    }

    public Cell getRoot() {
        return this.root;
    }
}

