/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class InstancePathToNccContext {
    private NccContext root;
    private Map varToNccContext = new HashMap();

    private NccContext getNccContext(VarContext vc) {
        NccContext nc = (NccContext)this.varToNccContext.get(vc);
        if (nc == null) {
            nc = new NccContext(vc);
            this.varToNccContext.put(vc, nc);
            if (vc == VarContext.globalContext) {
                this.root = nc;
            } else {
                NccContext parent = this.getNccContext(vc.pop());
                parent.addChild(nc);
            }
        }
        return nc;
    }

    private void addNameProxyIndex(HierarchyEnumerator.NameProxy np, int i) {
        NccContext nc = this.getNccContext(np.getContext());
        nc.addNameProxyIndex(np, i);
    }

    private List instNames(VarContext vc) {
        if (vc == VarContext.globalContext) {
            return new ArrayList();
        }
        List names = this.instNames(vc.pop());
        names.add(vc.getNodable().getName());
        return names;
    }

    public InstancePathToNccContext(HierarchyEnumerator.NameProxy[] objects) {
        int numObj = objects.length;
        for (int i = 0; i < numObj; ++i) {
            this.addNameProxyIndex(objects[i], i);
        }
    }

    public NccContext findNccContext(VarContext vc) {
        List names = this.instNames(vc);
        NccContext nc = this.root;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String instNm = (String)it.next();
            if ((nc = nc.findChild(instNm)) != null) continue;
            return null;
        }
        return nc;
    }
}

