/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.processing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.processing.SubcircuitInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HierarchyInfo {
    private String subcktName;
    private int cellGroupID = 0;
    private List cellsInCellGroup = new ArrayList();
    private boolean purgeCurrentCellGroup;
    private Map cellToSubcktInfo = new HashMap();

    public void beginNextCellGroup(String subcktName) {
        this.subcktName = subcktName;
        ++this.cellGroupID;
        this.purgeCurrentCellGroup = false;
        this.cellsInCellGroup.clear();
    }

    public void addSubcircuitInfo(Cell c, SubcircuitInfo subcktInfo) {
        if (this.purgeCurrentCellGroup) {
            return;
        }
        LayoutLib.error(this.cellToSubcktInfo.containsKey(c), "SubcircuitInfo already exists for Cell");
        this.cellsInCellGroup.add(c);
        this.cellToSubcktInfo.put(c, subcktInfo);
    }

    public void purgeCurrentCellGroup() {
        this.purgeCurrentCellGroup = true;
        Iterator it = this.cellsInCellGroup.iterator();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            LayoutLib.error(!this.cellToSubcktInfo.containsKey(c), "Cell not in map?");
            this.cellToSubcktInfo.remove(c);
        }
        this.cellsInCellGroup.clear();
    }

    public String currentSubcircuitName() {
        return this.subcktName;
    }

    public int currentSubcircuitID() {
        return this.cellGroupID;
    }

    public boolean treatAsPrimitive(Cell c) {
        return this.cellToSubcktInfo.containsKey(c);
    }

    public SubcircuitInfo getSubcircuitInfo(Cell c) {
        return (SubcircuitInfo)this.cellToSubcktInfo.get(c);
    }
}

