#! @SHELL@
# ifnames - print the identifiers used in C preprocessor conditionals
# Copyright 1994, 1995, 1999, 2000 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# Reads from stdin if no files are given.
# Writes to stdout.

# Written by David MacKenzie <djm@gnu.ai.mit.edu>
# and Paul Eggert <eggert@twinsun.com>.

me=`echo "$0" | sed -e 's,.*/,,'`

usage="\
Usage: $0 [OPTION] ...  [FILE] ...

Scan all of the C source FILES (or the standard input, if none are
given) and write to the standard output a sorted list of all the
identifiers that appear in those files in \`#if', \`#elif', \`#ifdef', or
\`#ifndef' directives.  Print each identifier on a line, followed by a
space-separated list of the files in which that identifier occurs.

  -h, --help      print this help, then exit
  -V, --version   print version number, then exit

Report bugs to <bug-autoconf@gnu.org>."

version="\
ifnames (@PACKAGE_NAME@) @VERSION@
Written by David J. MacKenzie and Paul Eggert.

Copyright 1994, 1995, 1999, 2000 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE."

help="\
Try \`$me --help' for more information."

while test $# -gt 0; do
  case "$1" in
  --help | -h )
    echo "$usage"; exit 0 ;;
  --version | -V )
    echo "$version"; exit 0 ;;
  --)     # Stop option processing.
    shift; break ;;
  -*)
    exec >&2
    echo "$me: invalid option $1"
    echo "$help"
    exit 1 ;;
  *) break ;;
  esac
done

# Variables.
: ${AWK=@AWK@}

$AWK '
  # Record that sym was found in FILENAME.
  function file_sym(sym,  i, fs)
  {
    if (sym ~ /^[A-Za-z_]/)
    {
      if (!found[sym,FILENAME])
      {
	found[sym,FILENAME] = 1

	# Insert FILENAME into files[sym], keeping the list sorted.
	i = 1
	fs = files[sym]
 	while (match(substr(fs, i), /^ [^ ]*/) \
 	       && substr(fs, i + 1, RLENGTH - 1) < FILENAME)
        {
 	  i += RLENGTH
	}
	files[sym] = substr(fs, 1, i - 1) " " FILENAME substr(fs, i)
      }
    }
  }

  {
    while (sub(/\\$/, "", $0) > 0)
    {
      if ((getline tmp) > 0)
	$0 = $0 tmp
      else
	break
    }
  }

  /^[\t ]*#/ {
    if (sub(/^[\t ]*#[\t ]*ifn?def[\t ]+/, "", $0))
    {
      sub(/[^A-Za-z_0-9].*/, "", $0)
      file_sym($0)
    }
    if (sub(/^[\t ]*#[\t ]*(el)?if[\t ]+/, "", $0))
    {
      # Remove comments.  Not perfect, but close enough.
      gsub(/\/\*[^\/]*(\*\/)?/, "", $0)

      for (i = split($0, field, /[^A-Za-z_0-9]+/);  1 <= i;  i--)
      {
	if (field[i] != "defined")
        {
	  file_sym(field[i])
	}
      }
    }
  }

  END {
    for (sym in files)
    {
      print sym files[sym]
    }
  }
' ${1+"$@"} | sort
