## --------------------------------------------------------- ##
## Find if ogonkify package should be installed		     ##
## Find what it needs.         demaille@inf.enst.fr          ##
## --------------------------------------------------------- ##

# serial 1

dnl 
AC_DEFUN(ad_ENABLE_PATHS,
  [AC_MSG_CHECKING(whether paths should be hardcoded)
   AC_ARG_ENABLE(paths,
     	         [  --enable-paths          hard code the path of the tools])
   test "$enable_paths" = "yes" || enable_paths=no
   AC_MSG_RESULT($enable_paths)])

dnl ad_CHECK_PROG(PROGRAM[, COMMENT ON FAILURE])
dnl defines $COM_PROGRAM to `#' if PROGRAM is not available, to `' otherwise
dnl and defines $PROGRAM to PROGRAM if paths should not be hardcoded,
dnl and to the path to PROGRAM otherwise.
AC_DEFUN(ad_CHECK_PROG,
  [if test "$enable_paths" = "no"; then
     AC_CHECK_PROG(COM_$1, $1, yes, no)
     $1="$1";
     if test "[$]COM_$1" = "yes"; then
       COM_$1="";
     else
       COM_$1="#";
     fi
   else
     AC_PATH_PROG($1, $1, [#])
     if test "$1" = "#"; then #  not found
       $1="$1" # let the name of the program as path
       COM_$1="#"
     else
       COM_$1=""
     fi
   fi
   if test "[$]COM_$1" = "#" && test -n "$2"; then
     AC_MSG_WARN([============================================================
$2]);
     AC_MSG_WARN([============================================================]);
   fi
   AC_SUBST($1)
   AC_SUBST(COM_$1)])

dnl ad_CHECK_PROG(PROGRAM[, COMMENT ON FAILURE])
dnl defines $COM_PROGRAM to `#' if PROGRAM is not available, to `' otherwise
dnl and defines $PROGRAM to PROGRAM if paths should not be hardcoded,
dnl and to the path to PROGRAM otherwise.
AC_DEFUN([ad_CHECK_PROGS],
[ad_FOREACH(AC_PROG, [$1], [ad_CHECK_PROG(AC_PROG, $2)])])

