/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include "action.h"
#include "common.h"
#include <QtGlobal>
#include <QVector>
#include <QObject>
#include <QScopedPointer>
#include <QSettings>

class Settings
{
private:
    Settings();
    static QScopedPointer <Settings> m_instance;

public:
    static Settings *instance();
    ~Settings();

#if 0
    bool load();
    bool loadActions();
    void loadAppSettings();
    void save();
#endif

#ifdef USE_LOGGING
    void setLogging(bool log = true);
    void setLogFile(const QString &file);
#endif
    void setUpdateInterval(const int interval);
    void setActionFile(const QString &file);
    void setRunAtStartupGlobal(bool run = true);
    void setRunAtStartCurrent(bool run = true);
    void setFirstRun(bool first = true);

#ifdef USE_LOGGING
    bool log() const;
    QString logFile() const;
    bool logEnabled() const;
#endif
    int updateInterval() const;
    QString actionFile() const;
    bool runAtStartUpGlobal() const;
    bool runAtStartUpCurrent() const;
    bool firstRun() const;

    int actionsCount() const;
    void actionsClear();
    QVector <Action> actions();
    void actionsAdd(Action action);

    Action operator[] (int i) const;

private:
    typedef enum {RUN_LOCAL, RUN_GLOBAL} run_t;

    void actionsLoad();
    void actionsSave();
    void setRunAtStartUp(run_t type = RUN_LOCAL, bool run = true);
    bool runAtStartUp(run_t type = RUN_LOCAL) const;

private:
    QSettings m_settings;
    QVector <Action> m_actions;
    bool m_actions_modified;
    bool m_actions_loaded;
};

#endif // SETTINGS_H
