/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#include "dataminer.h"

Data::Data()
{
}

Data::Data(QDateTime date, int level, bool ac):
	m_date_time(date),
	m_level(level),
	m_ac(ac)
{
}

Data::~Data()
{
}

void Data::setDateTime(QDateTime date)
{
	m_date_time = date;
}

void Data::setLevel(int level)
{
	m_level = level;
}

void Data::setAc(bool ac)
{
	m_ac = ac;
}

QDateTime Data::dateTime() const
{
	return m_date_time;
}

int Data::level() const
{
	return m_level;
}

bool Data::ac() const
{
	return m_ac;
}

//------------------------------------------------------------------------------

DataMiner::DataMiner()
{
}

DataMiner::~DataMiner()
{
}
