/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#include "csvminer.h"
#include <QFile>
#include <QRegExp>
#include <QStringList>

#include <iostream>

CsvMiner::CsvMiner():
	DataMiner()
{
}

CsvMiner::~CsvMiner()
{
}

void CsvMiner::load(const QString &filename)
{
	QFile fin(filename);
	if (!fin.exists())
		return;

	if (!fin.open(QIODevice::ReadOnly))
		return;

	QRegExp reg_line("(.*),(.*),(.*)\n");

	//read the file content
	m_data.clear();
	while (!fin.atEnd())
	{
		QByteArray line = fin.readLine();
		reg_line.indexIn(line.data());

		QStringList captured_texts = reg_line.capturedTexts();

		QDateTime date_time;
		date_time = QDateTime::fromString(captured_texts[1], "yyyy.MM.dd-hh:mm:ss");
		QString level = captured_texts[2];
		if (level[0] == '0')
			level.remove(0, 1);

		Data d;
		d.setDateTime(date_time);
		d.setLevel(level.toInt());
		d.setAc(captured_texts[3] == "conn");

		m_data.append(d);
	}

	fin.close();
}

QVector <Data> CsvMiner::data() const
{
	return m_data;
}
