/***************************************************************************
*   Copyright (C) 2010 by Peter Hatina                                    *
*   email: phatina (at) gmail.com                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU Lesser General Public License           *
*   version 2.1 as published by the Free Software Foundation              *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU Lesser General Public License for more details.                   *
*   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
***************************************************************************/

#ifndef _COMMON_H_
#define _COMMON_H_

#include <iostream>
#include <QtGlobal>
#include <QString>

#ifdef Q_OS_WIN32
/*
* Windows 7                                            _WIN32_WINNT_WIN7 (0x0601)
* Windows Server 2008                                  _WIN32_WINNT_WS08 (0x0600)
* Windows Vista                                        _WIN32_WINNT_VISTA (0x0600)
* Windows Server 2003 with SP1, Windows XP with SP2    _WIN32_WINNT_WS03 (0x0502)
* Windows Server 2003, Windows XP                      _WIN32_WINNT_WINXP (0x0501)
* Windows 2000                                         _WIN32_WINNT_WIN2K (0x0500)
*/

//currently win 7
#ifndef WINVER
#  define WINVER	0x0601
#endif

extern "C" {
#include "windows.h"
}
#endif

//------------------------------------------------------------------------------

class BasicException
{
public:
    BasicException(): m_message("An error occured while running the program!") {}
    BasicException(const QString &str): m_message(str) {}
    ~BasicException() {}

    void printMessage() { std::cout << m_message.toStdString() << std::endl; }

private:
    QString m_message;
};

class FileReadError: public BasicException
{
public:
    FileReadError(): BasicException("An error occured while reading a file!") {}
    ~FileReadError() {}
};

class FileWriteError: public BasicException
{
public:
    FileWriteError(): BasicException("An error occured while writing to a file!") {}
    ~FileWriteError() {}
};

class XMLSyntaxError: public BasicException
{
public:
    XMLSyntaxError(): BasicException("XML syntax error in config. file!") {}
    ~XMLSyntaxError() {}
};

class IndexError: public BasicException
{
public:
    IndexError(): BasicException("Array index error!") {}
    ~IndexError() {}
};

#endif
