/***************************************************************************
 *   Copyright (C) 2010 by Peter Hatina                                    *
 *   email: phatina (at) gmail.com                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License           *
 *   version 2.1 as published by the Free Software Foundation              *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU Lesser General Public License for more details.                   *
 *   http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.               *
 ***************************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

/*
 * Windows 7                                            _WIN32_WINNT_WIN7 (0x0601)
 * Windows Server 2008                                  _WIN32_WINNT_WS08 (0x0600)
 * Windows Vista                                        _WIN32_WINNT_VISTA (0x0600)
 * Windows Server 2003 with SP1, Windows XP with SP2    _WIN32_WINNT_WS03 (0x0502)
 * Windows Server 2003, Windows XP                      _WIN32_WINNT_WINXP (0x0501)
 * Windows 2000                                         _WIN32_WINNT_WIN2K (0x0500)
 */

//currently win 7
#define WINVER	0x0601
extern "C" {
#include "windows.h"
}

#include <QApplication>
#include <QWidget>

class Application : public QApplication
{
	Q_OBJECT
public:
	explicit Application(int &argc, char **argv);
	~Application();

#ifdef Q_OS_WIN32
	virtual bool winEventFilter(MSG *msg, long *res);
#endif

signals:
	void powerStatusChanged();
};

#endif // APPLICATION_H
