/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class LocalVariableSupport
extends AbstractSimpleVariableSupport {
    public LocalVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public LocalVariableSupport(JavaInfo javaInfo, SimpleName variable) {
        super(javaInfo, (Expression)variable);
    }

    @Override
    public final boolean isValidStatementForChild(Statement statement) {
        StatementTarget statementTarget = new StatementTarget(statement, true);
        NodeTarget nodeTarget = new NodeTarget(statementTarget);
        return this.isVisibleAtTarget(nodeTarget);
    }

    @Override
    public final boolean canConvertLocalToField() {
        return this.getDeclarationStatement().fragments().size() == 1;
    }

    @Override
    public final boolean canConvertFieldToLocal() {
        return false;
    }

    @Override
    public final void convertFieldToLocal() throws Exception {
        throw new IllegalStateException();
    }

    void ensureUniqueVariableDuringMove(int newPosition, Statement[] statementsToMove) throws Exception {
        ArrayList existingDeclarations = Lists.newArrayList();
        AstEditor editor = this.m_javaInfo.getEditor();
        CompilationUnit unit = editor.getAstUnit();
        VariableDeclaration declaration = this.m_declaration;
        existingDeclarations.addAll(AstNodeUtils.getVariableDeclarationsVisibleAt((ASTNode)unit, newPosition));
        existingDeclarations.addAll(AstNodeUtils.getVariableDeclarationsAfter((ASTNode)unit, declaration.getStartPosition()));
        boolean isInBlock = false;
        Statement[] statementArray = statementsToMove;
        int n = statementsToMove.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            isInBlock |= statement instanceof Block && AstNodeUtils.contains((ASTNode)statement, (ASTNode)declaration);
            ++n2;
        }
        if (!isInBlock) {
            existingDeclarations.addAll(AstNodeUtils.getVariableDeclarationsAfter((ASTNode)unit, newPosition));
        }
        existingDeclarations.remove(declaration);
        String oldName = this.getName();
        String newName = AstEditor.getUniqueVariableName(existingDeclarations, oldName);
        if (!oldName.equals(newName)) {
            this.setName(newName);
        }
    }

    protected final VariableDeclarationStatement getDeclarationStatement() {
        return (VariableDeclarationStatement)this.m_declaration.getParent();
    }

    protected final String addUniqueField(boolean isStatic, VariableDeclaration excludedVariable) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        String fieldName = this.m_utils.getUniqueFieldName(this.getName(), excludedVariable);
        Type type = this.getDeclarationStatement().getType();
        String modifiers = isStatic ? "private static " : "private ";
        String fieldSource = String.valueOf(modifiers) + editor.getSource((ASTNode)type) + " " + fieldName + ";";
        this.addField(fieldSource);
        return fieldName;
    }

    protected final void replaceDeclarationWithAssignment(AstEditor editor, VariableDeclaration oldFragment) throws Exception {
        VariableDeclarationStatement oldStatement = (VariableDeclarationStatement)oldFragment.getParent();
        Assert.isTrue((oldStatement.fragments().size() == 1 ? 1 : 0) != 0);
        int oldStart = oldStatement.getStartPosition();
        AST ast = this.m_variable.getAST();
        Assignment newAssignment = ast.newAssignment();
        oldFragment.setName(ast.newSimpleName("__foo"));
        newAssignment.setLeftHandSide(this.m_variable);
        Expression initializer = oldFragment.getInitializer();
        oldFragment.setInitializer(null);
        newAssignment.setRightHandSide(initializer);
        AstNodeUtils.setSourceRange((ASTNode)newAssignment, (ASTNode)newAssignment.getLeftHandSide(), (ASTNode)newAssignment.getRightHandSide());
        ExpressionStatement newStatement = ast.newExpressionStatement((Expression)newAssignment);
        AstNodeUtils.setSourceRange((ASTNode)newStatement, (ASTNode)newAssignment, 1);
        List<Statement> oldStatements = DomGenerics.statements((Block)oldStatement.getParent());
        int index = oldStatements.indexOf(oldStatement);
        oldStatements.set(index, (Statement)newStatement);
        editor.replaceSubstring(oldStart, this.m_variable.getStartPosition() - oldStart, "");
    }
}

