/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.packaging.internal.util;

import java.util.Map;
import org.eclipse.dali.packaging.PackagingPackage;
import org.eclipse.dali.packaging.Persistence;
import org.eclipse.dali.packaging.PersistenceUnit;
import org.eclipse.dali.packaging.PersistenceUnitTransactionType;
import org.eclipse.dali.packaging.Properties;
import org.eclipse.dali.packaging.Property;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;

public class PackagingValidator
extends EObjectValidator {
    public static final PackagingValidator INSTANCE = new PackagingValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.dali.packaging";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] VERSION__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"[0-9]+(\\.[0-9]+)*")}};

    protected EPackage getEPackage() {
        return PackagingPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validatePersistence((Persistence)value, diagnostics, context);
            }
            case 1: {
                return this.validatePersistenceUnit((PersistenceUnit)value, diagnostics, context);
            }
            case 2: {
                return this.validateProperties((Properties)value, diagnostics, context);
            }
            case 3: {
                return this.validateProperty((Property)value, diagnostics, context);
            }
            case 4: {
                return this.validatePersistenceUnitTransactionType((PersistenceUnitTransactionType)((Object)value), diagnostics, context);
            }
            case 5: {
                return this.validatePersistenceUnitTransactionTypeObject((PersistenceUnitTransactionType)((Object)value), diagnostics, context);
            }
            case 6: {
                return this.validateVersion((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatePersistence(Persistence persistence, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(persistence, diagnostics, context);
    }

    public boolean validatePersistenceUnit(PersistenceUnit persistenceUnit, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(persistenceUnit, diagnostics, context);
    }

    public boolean validateProperties(Properties properties, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(properties, diagnostics, context);
    }

    public boolean validateProperty(Property property, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(property, diagnostics, context);
    }

    public boolean validatePersistenceUnitTransactionType(PersistenceUnitTransactionType persistenceUnitTransactionType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validatePersistenceUnitTransactionTypeObject(PersistenceUnitTransactionType persistenceUnitTransactionTypeObject, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateVersion(String version, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateVersion_Pattern(version, diagnostics, context);
        return result;
    }

    public boolean validateVersion_Pattern(String version, DiagnosticChain diagnostics, Map context) {
        return this.validatePattern(PackagingPackage.Literals.VERSION, version, VERSION__PATTERN__VALUES, diagnostics, context);
    }
}

