/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.CascadeType;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.FetchType;
import org.eclipse.dali.core.PersistentAttribute;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.ReferencePersistentAttributeFlavorItemProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class ReferenceMappingComposite
extends Composite {
    protected boolean populating;
    protected EditingDomain editingDomain;
    protected DaliItemProviderAdapterFactory adapterFactory;
    protected ComboViewer fetchTypeComboViewer;
    protected ComboViewer cascadeTypeComboViewer;
    protected Combo targetEntityCombo;
    protected ReferencePersistentAttributeFlavor mappingType;
    private ReferencePersistentAttributeFlavorItemProvider mappingTypeItemProvider;
    private INotifyChangedListener mappingTypeListener;
    static /* synthetic */ Class class$0;

    public ReferenceMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.initialize(adapterFactory);
    }

    protected void initialize(DaliItemProviderAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.mappingTypeItemProvider = this.createReferenceMappingTypeItemProvider(adapterFactory);
    }

    protected abstract ReferencePersistentAttributeFlavorItemProvider createReferenceMappingTypeItemProvider(DaliItemProviderAdapterFactory var1);

    protected ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ReferenceMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FetchType fetchType = (FetchType)selection.getFirstElement();
                    ReferenceMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ReferenceMappingComposite.this.editingDomain, (Object)ReferenceMappingComposite.this.mappingType, (Object)DaliPackage.eINSTANCE.getReferencePersistentAttributeFlavor_FetchType(), (Object)fetchType));
                }
            }
        });
        return viewer;
    }

    protected ComboViewer buildCascadeTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(CascadeType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ReferenceMappingComposite.this.populating) {
                    return;
                }
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    CascadeType cascadeType = (CascadeType)selection.getFirstElement();
                    ReferenceMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ReferenceMappingComposite.this.editingDomain, (Object)ReferenceMappingComposite.this.mappingType, (Object)DaliPackage.eINSTANCE.getReferencePersistentAttributeFlavor_CascadeType(), (Object)cascadeType));
                }
            }
        });
        return viewer;
    }

    protected Combo buildTargetEntityCombo(Composite parent) {
        final Combo combo = new Combo(parent, 2052);
        combo.add("Default ()");
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ReferenceMappingComposite.this.populating) {
                    return;
                }
                String targetEntityName = ((Combo)e.getSource()).getText();
                if (targetEntityName.equals(combo.getItem(0)) || targetEntityName.equals("")) {
                    targetEntityName = null;
                } else if (!ReferenceMappingComposite.this.mappingType.isValidTargetEntity(targetEntityName)) {
                    return;
                }
                ReferenceMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)ReferenceMappingComposite.this.editingDomain, (Object)ReferenceMappingComposite.this.mappingType, (Object)DaliPackage.eINSTANCE.getReferencePersistentAttributeFlavor_SpecifiedTargetEntity(), (Object)targetEntityName));
            }
        });
        return combo;
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.mappingType != null) {
            this.mappingTypeItemProvider.removeListener(this.getMappingTypeListener());
            this.mappingType.eAdapters().remove((Object)this.mappingTypeItemProvider);
        }
        if (model == null) {
            return;
        }
        this.mappingType = (ReferencePersistentAttributeFlavor)((PersistentAttribute)model).getFlavor();
        this.mappingTypeItemProvider.addListener(this.getMappingTypeListener());
        this.mappingType.eAdapters().add((Object)this.mappingTypeItemProvider);
        if (this.mappingType.getFetchType() == FetchType.DEFAULT_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.DEFAULT_LITERAL));
            }
        } else if (this.mappingType.getFetchType() == FetchType.EAGER_LITERAL) {
            if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.EAGER_LITERAL));
            }
        } else if (((StructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchType.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchType.LAZY_LITERAL));
        }
        this.cascadeTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)this.mappingType.getCascadeType()));
        String targetEntity = this.mappingType.getSpecifiedTargetEntity();
        this.targetEntityCombo.setItem(0, "Default (" + this.mappingType.getDefaultTargetEntity() + ")");
        if (targetEntity != null) {
            if (!this.targetEntityCombo.getText().equals(targetEntity)) {
                this.targetEntityCombo.setText(targetEntity);
            }
        } else if (this.targetEntityCombo.getSelectionIndex() != 0) {
            this.targetEntityCombo.select(0);
        }
        this.populating = false;
    }

    private INotifyChangedListener getMappingTypeListener() {
        if (this.mappingTypeListener == null) {
            this.mappingTypeListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    ReferenceMappingComposite.this.mappingTypeChanged(notification);
                }
            };
        }
        return this.mappingTypeListener;
    }

    protected void mappingTypeChanged(Notification notification) {
        if (notification.getFeatureID(ReferencePersistentAttributeFlavor.class) == 0) {
            final FetchType fetchType = (FetchType)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (((StructuredSelection)ReferenceMappingComposite.this.fetchTypeComboViewer.getSelection()).getFirstElement() != fetchType) {
                        ReferenceMappingComposite.this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)fetchType));
                    }
                }
            });
        } else if (notification.getFeatureID(ReferencePersistentAttributeFlavor.class) == 1) {
            final CascadeType cascadeType = (CascadeType)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (((StructuredSelection)ReferenceMappingComposite.this.cascadeTypeComboViewer.getSelection()).getFirstElement() != cascadeType) {
                        ReferenceMappingComposite.this.cascadeTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)cascadeType));
                    }
                }
            });
        } else if (notification.getFeatureID(ReferencePersistentAttributeFlavor.class) == 3) {
            final String targetEntity = notification.getNewStringValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (targetEntity == null) {
                        if (ReferenceMappingComposite.this.targetEntityCombo.getSelectionIndex() != 0) {
                            ReferenceMappingComposite.this.targetEntityCombo.select(0);
                        }
                    } else if (!ReferenceMappingComposite.this.targetEntityCombo.getText().equals(targetEntity)) {
                        ReferenceMappingComposite.this.targetEntityCombo.setText(targetEntity);
                    }
                }
            });
        } else if (notification.getFeatureID(ReferencePersistentAttributeFlavor.class) == 2) {
            final String defaultTargetEntity = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    int selectionIndex = ReferenceMappingComposite.this.targetEntityCombo.getSelectionIndex();
                    ReferenceMappingComposite.this.targetEntityCombo.setItem(0, "Default (" + defaultTargetEntity + ")");
                    if (selectionIndex == 0) {
                        ReferenceMappingComposite.this.targetEntityCombo.select(0);
                    }
                }
            });
        }
    }

    protected Button buildTargetEntitySelectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceMappingComposite.this.browse();
            }
        });
        return button;
    }

    protected void browse() {
        BusyIndicator.showWhile((Display)this.targetEntityCombo.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ReferenceMappingComposite.this.doOpenSelectionDialog();
            }
        });
    }

    private void doOpenSelectionDialog() {
        SelectionDialog dialog;
        try {
            dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)256, (boolean)false, (String)"");
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
        dialog.setTitle("Select Type");
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getResult()[0];
            this.targetEntityCombo.setText(type.getFullyQualifiedName('$'));
        }
    }

    public boolean setFocus() {
        super.setFocus();
        return this.targetEntityCombo.setFocus();
    }

    public void dispose() {
        super.dispose();
        this.mappingTypeItemProvider.removeListener(this.getMappingTypeListener());
    }
}

