/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.Generator;
import org.eclipse.dali.core.TableGenerator;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.GeneratorItemProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public abstract class GeneratorComposite
extends Composite {
    protected boolean populating;
    protected EditingDomain editingDomain;
    protected DaliItemProviderAdapterFactory adapterFactory;
    protected ITextViewer nameViewer;
    private Generator generator;
    private INotifyChangedListener generatorListener;
    protected GeneratorItemProvider generatorItemProvider;
    static /* synthetic */ Class class$0;

    public GeneratorComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.initialize(adapterFactory);
    }

    protected void initialize(DaliItemProviderAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        this.generatorItemProvider = this.createGeneratorItemProvider(adapterFactory);
    }

    protected abstract GeneratorItemProvider createGeneratorItemProvider(DaliItemProviderAdapterFactory var1);

    protected ITextViewer buildNameViewer(Composite parent) {
        final TextViewer textViewer = new TextViewer(parent, 2052);
        textViewer.setDocument((IDocument)new Document());
        textViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (GeneratorComposite.this.populating) {
                    return;
                }
                String name = textViewer.getDocument().get();
                if (name.equals("")) {
                    if (GeneratorComposite.this.getGenerator().getSpecifiedName() == null) {
                        return;
                    }
                    name = null;
                }
                GeneratorComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)GeneratorComposite.this.editingDomain, (Object)GeneratorComposite.this.getGenerator(), (Object)DaliPackage.eINSTANCE.getGenerator_SpecifiedName(), (Object)name));
            }
        });
        return textViewer;
    }

    public void populate(EObject model) {
        this.populating = true;
        if (this.generator != null) {
            this.generatorItemProvider.removeListener(this.getGeneratorListener());
            this.generator.eAdapters().remove((Object)this.generatorItemProvider);
        }
        if (model == null) {
            this.generator = null;
            this.clear();
            this.setVisible(false);
            this.populating = false;
            return;
        }
        this.setVisible(true);
        this.generator = (Generator)model;
        this.generatorItemProvider.addListener(this.getGeneratorListener());
        this.generator.eAdapters().add((Object)this.generatorItemProvider);
        this.populateNameViewer();
        this.populating = false;
    }

    private INotifyChangedListener getGeneratorListener() {
        if (this.generatorListener == null) {
            this.generatorListener = new INotifyChangedListener(){

                public void notifyChanged(Notification notification) {
                    GeneratorComposite.this.generatorChanged(notification);
                }
            };
        }
        return this.generatorListener;
    }

    protected void generatorChanged(Notification notification) {
        if (notification.getFeatureID(TableGenerator.class) == 0) {
            final String name = notification.getNewStringValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (GeneratorComposite.this.nameViewer.getDocument().get() == null || !GeneratorComposite.this.nameViewer.getDocument().get().equals(name)) {
                        if (name == null) {
                            GeneratorComposite.this.clearNameViewer();
                        } else {
                            GeneratorComposite.this.nameViewer.getDocument().set(name);
                        }
                    }
                }
            });
        }
    }

    private void populateNameViewer() {
        String name = this.getGenerator().getSpecifiedName();
        if (name != null) {
            if (!this.nameViewer.getDocument().get().equals(name)) {
                this.nameViewer.getDocument().set(name);
            }
        } else {
            this.clearNameViewer();
        }
    }

    protected Generator getGenerator() {
        return this.generator;
    }

    protected void clear() {
        this.clearNameViewer();
    }

    protected void clearNameViewer() {
        this.nameViewer.getDocument().set("");
    }
}

