/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.iterators.NullIterator;
import org.eclipse.dali.internal.utility.iterators.SingleElementIterator;

public class TreeIterator
implements Iterator {
    private Iterator currentIterator;
    private Collection iterators;
    private Midwife midwife;

    public TreeIterator(Iterator roots) {
        this(roots, Midwife.NULL_INSTANCE);
    }

    public TreeIterator(Object root) {
        this(root, Midwife.NULL_INSTANCE);
    }

    public TreeIterator(Object root, Midwife midwife) {
        this(new SingleElementIterator(root), midwife);
    }

    public TreeIterator(Iterator roots, Midwife midwife) {
        this.currentIterator = roots;
        this.iterators = new LinkedList();
        this.midwife = midwife;
    }

    public boolean hasNext() {
        if (this.currentIterator.hasNext()) {
            return true;
        }
        for (Iterator iterator : this.iterators) {
            if (!iterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    public Object next() {
        if (this.currentIterator.hasNext()) {
            return this.nextInternal();
        }
        Iterator stream = this.iterators.iterator();
        while (stream.hasNext()) {
            this.currentIterator = (Iterator)stream.next();
            if (this.currentIterator.hasNext()) break;
            stream.remove();
        }
        return this.nextInternal();
    }

    private Object nextInternal() {
        Object next = this.currentIterator.next();
        this.iterators.add(this.children(next));
        return next;
    }

    public void remove() {
        this.currentIterator.remove();
    }

    protected Iterator children(Object next) {
        return this.midwife.children(next);
    }

    public String toString() {
        return String.valueOf(ClassTools.shortClassNameForObject(this)) + '(' + this.currentIterator + ')';
    }

    public static interface Midwife {
        public static final Midwife NULL_INSTANCE = new Midwife(){

            public Iterator children(Object next) {
                return NullIterator.instance();
            }
        };

        public Iterator children(Object var1);
    }
}

