/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.vjet.dsf.DsfTraceId;
import org.eclipse.vjet.dsf.common.trace.DataModelCtx;
import org.eclipse.vjet.dsf.common.trace.TraceCtx;
import org.eclipse.vjet.dsf.common.trace.event.TraceId;
import org.eclipse.vjet.dsf.common.trace.introspect.JavaBeanTraceIntrospector;
import org.eclipse.vjet.dsf.common.tracer.ITracer;
import org.eclipse.vjet.dsf.common.xml.IIndenter;
import org.eclipse.vjet.dsf.common.xml.IXmlStreamWriter;
import org.eclipse.vjet.dsf.common.xml.XmlStreamWriter;
import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.logger.Logger;

public class DataModelHelper {
    public static final String DataModelScope = "DataModel";
    private static Logger s_logger = Logger.getInstance(DataModelHelper.class);
    private static DataModelHelper s_singleton = new DataModelHelper();

    private DataModelHelper() {
    }

    public static DataModelHelper getInstance() {
        return s_singleton;
    }

    public static boolean isTraceOn() {
        return TraceCtx.ctx().getTraceManager().isTraceOn();
    }

    public void traceDataModel(Object model) {
        this.traceDataModel(null, model);
    }

    public void traceDataModel(DNode component, Object model) {
        TraceCtx ctx = TraceCtx.ctx();
        DataModelCtx dmCtx = DataModelCtx.getCtx();
        if (model != null) {
            ITracer tracer = ctx.getTracer(DataModelScope);
            tracer.traceDataModel((TraceId)DsfTraceId.DATAMODEL, (Object)this, model);
            if (component != null) {
                dmCtx.addComponentAndModel(component, model);
            }
        }
    }

    public void resetHelperCtx() {
        DataModelCtx.setCtx(null);
    }

    public String getDataModelAsXml(DNode component, boolean encode) {
        DataModelCtx ctx = DataModelCtx.getCtx();
        Map<DNode, Object> map = ctx.getComponentModelMap();
        Object model = map.get(component);
        return this.getDataModelAsXmlDirect(model, encode);
    }

    public String getDataModelAsXmlDirect(Object model, boolean encode) {
        if (model == null) {
            return null;
        }
        JavaBeanTraceIntrospector introspector = JavaBeanTraceIntrospector.getDefault();
        StringWriter strWriter = new StringWriter();
        XmlStreamWriter xmlWriter = new XmlStreamWriter((Writer)strWriter, IIndenter.COMPACT);
        introspector.writeState(model, (IXmlStreamWriter)xmlWriter);
        xmlWriter.flush();
        String s = strWriter.toString();
        if ("".equals(s)) {
            s = null;
        }
        if (encode && s != null) {
            s = new String(Base64.encodeBase64((byte[])s.getBytes()));
        }
        return s;
    }

    public String decodeDataModelStr(String encodedXmlStr) {
        if (encodedXmlStr == null) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((byte[])encodedXmlStr.getBytes());
        return new String(bytes);
    }

    public Object getDataModel(DNode component) {
        DataModelCtx ctx = DataModelCtx.getCtx();
        Map<DNode, Object> map = ctx.getComponentModelMap();
        return map.get(component);
    }

    public <T> T getProxy(Class<T> modelInterface, Object model) {
        ClassLoader classLoader = model.getClass().getClassLoader();
        Class[] interfaces = new Class[]{modelInterface};
        JavaBeanInvocationHandler handler = new JavaBeanInvocationHandler(model);
        Object proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
        return (T)proxy;
    }

    public Object getProxy(Object model) {
        ClassLoader classLoader = model.getClass().getClassLoader();
        Class<?>[] interfaces = model.getClass().getInterfaces();
        JavaBeanInvocationHandler handler = new JavaBeanInvocationHandler(model);
        Object proxy = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)handler);
        return proxy;
    }

    protected static class JavaBeanInvocationHandler
    implements InvocationHandler {
        private Object model;

        public JavaBeanInvocationHandler(Object javaBean) {
            this.model = javaBean;
        }

        @Override
        public Object invoke(Object proxy, Method m, Object[] args) {
            Object result = null;
            try {
                DataModelCtx ctx = DataModelCtx.getCtx();
                IXmlStreamWriter writer = ctx.getWriter();
                JavaBeanTraceIntrospector introspector = JavaBeanTraceIntrospector.getDefault();
                result = introspector.doInvocation(writer, this.model, m, args);
                if (DataModelHelper.isTraceOn() && result != null && writer != null) {
                    writer.writeStartElement(this.model.getClass().getSimpleName());
                    writer.writeAttribute("method", m.getName());
                    introspector.writeState(result, writer);
                    writer.writeEndElement();
                }
            }
            catch (Exception e) {
                s_logger.log((Throwable)e);
            }
            return result;
        }
    }
}

