/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.common.binding;

import java.util.Map;
import org.eclipse.vjet.dsf.common.binding.BaseValueBinding;
import org.eclipse.vjet.dsf.common.binding.IMapValueBinding;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;

public class MapValueBinding<K, T>
extends BaseValueBinding<T>
implements IMapValueBinding<K, T> {
    private static final long serialVersionUID = 1L;
    private Map<K, T> m_data;
    private K m_key;

    public MapValueBinding(Map<K, T> map, K key, Class<T> valueType) {
        super(valueType);
        this.setMap(map);
        this.setKey(key);
    }

    @Override
    public void setMap(Map<K, T> map) {
        this.assertNotNull(map, "Binding Map target must not be null");
        this.m_data = map;
    }

    @Override
    public Map<K, T> getMap() {
        return this.m_data;
    }

    @Override
    public void setKey(K key) {
        this.m_key = key;
    }

    @Override
    public K getKey() {
        return this.m_key;
    }

    @Override
    public T getValue() {
        this.assertState();
        return this.getMap().get(this.getKey());
    }

    @Override
    public void setValue(T value) {
        this.assertState();
        this.getMap().put(this.getKey(), value);
    }

    protected final void assertState() {
        if (this.m_data == null) {
            throw new DsfRuntimeException("Map target must not be null");
        }
    }

    public String toString() {
        return this.m_key + " on: " + this.m_data;
    }
}

