/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.util;

import org.eclipse.vjet.dsf.dom.DNode;
import org.eclipse.vjet.dsf.html.dom.DArea;
import org.eclipse.vjet.dsf.html.dom.DBase;
import org.eclipse.vjet.dsf.html.dom.DBody;
import org.eclipse.vjet.dsf.html.dom.DCaption;
import org.eclipse.vjet.dsf.html.dom.DCol;
import org.eclipse.vjet.dsf.html.dom.DColGroup;
import org.eclipse.vjet.dsf.html.dom.DDd;
import org.eclipse.vjet.dsf.html.dom.DDel;
import org.eclipse.vjet.dsf.html.dom.DDl;
import org.eclipse.vjet.dsf.html.dom.DDt;
import org.eclipse.vjet.dsf.html.dom.DFieldSet;
import org.eclipse.vjet.dsf.html.dom.DForm;
import org.eclipse.vjet.dsf.html.dom.DFrame;
import org.eclipse.vjet.dsf.html.dom.DFrameSet;
import org.eclipse.vjet.dsf.html.dom.DHead;
import org.eclipse.vjet.dsf.html.dom.DHtml;
import org.eclipse.vjet.dsf.html.dom.DHtmlDocument;
import org.eclipse.vjet.dsf.html.dom.DLegend;
import org.eclipse.vjet.dsf.html.dom.DLi;
import org.eclipse.vjet.dsf.html.dom.DLink;
import org.eclipse.vjet.dsf.html.dom.DMap;
import org.eclipse.vjet.dsf.html.dom.DMeta;
import org.eclipse.vjet.dsf.html.dom.DNoFrames;
import org.eclipse.vjet.dsf.html.dom.DObject;
import org.eclipse.vjet.dsf.html.dom.DOl;
import org.eclipse.vjet.dsf.html.dom.DOptGroup;
import org.eclipse.vjet.dsf.html.dom.DOption;
import org.eclipse.vjet.dsf.html.dom.DParam;
import org.eclipse.vjet.dsf.html.dom.DSelect;
import org.eclipse.vjet.dsf.html.dom.DStyle;
import org.eclipse.vjet.dsf.html.dom.DTBody;
import org.eclipse.vjet.dsf.html.dom.DTFoot;
import org.eclipse.vjet.dsf.html.dom.DTHead;
import org.eclipse.vjet.dsf.html.dom.DTable;
import org.eclipse.vjet.dsf.html.dom.DTd;
import org.eclipse.vjet.dsf.html.dom.DTh;
import org.eclipse.vjet.dsf.html.dom.DTitle;
import org.eclipse.vjet.dsf.html.dom.DTr;
import org.eclipse.vjet.dsf.html.dom.IDFlow;
import org.eclipse.vjet.dsf.html.dom.IDFormControl;
import org.w3c.dom.Node;

public class NodeToDHtmlDocument {
    public static DHtmlDocument createHtmlDocumentContaining(Node component) {
        return NodeToDHtmlDocument.createHtmlDocumentContaining(component, true);
    }

    public static DHtmlDocument createHtmlDocumentContaining(Node component, boolean clone) {
        Node actualRoot = component;
        while (actualRoot.getParentNode() != null) {
            actualRoot = actualRoot.getParentNode();
        }
        DHtmlDocument doc = null;
        if (actualRoot instanceof DHtmlDocument) {
            doc = (DHtmlDocument)((Object)actualRoot);
            return doc;
        }
        doc = new DHtmlDocument();
        if (actualRoot instanceof DHtml) {
            doc.appendChild(actualRoot);
            return doc;
        }
        DHtml html = new DHtml();
        doc.appendChild((Node)((Object)html));
        if (actualRoot instanceof DHead) {
            html.appendChild(actualRoot);
            return doc;
        }
        DHead head = new DHead();
        html.add((DNode)head);
        if (actualRoot instanceof DTitle || actualRoot instanceof DBase || actualRoot instanceof DLink || actualRoot instanceof DMeta || actualRoot instanceof DStyle) {
            head.appendChild(actualRoot);
            return doc;
        }
        DTitle title = new DTitle("Generated by V4");
        head.add((DNode)title);
        if (actualRoot instanceof DBody || actualRoot instanceof DFrameSet) {
            html.appendChild(actualRoot);
            return doc;
        }
        if (actualRoot instanceof DFrame || actualRoot instanceof DNoFrames) {
            DFrameSet fs = new DFrameSet();
            fs.appendChild(actualRoot);
            html.appendChild((Node)((Object)fs));
            return doc;
        }
        DBody body = new DBody();
        html.add((DNode)body);
        Node forBodyParenting = NodeToDHtmlDocument.getSuitableForBodyParenting(actualRoot);
        body.appendChild(forBodyParenting);
        return doc;
    }

    private static Node getSuitableForBodyParenting(Node c) {
        if (c instanceof IDFormControl) {
            DForm form = new DForm();
            form.appendChild(c);
            return form;
        }
        if (c instanceof DArea) {
            DMap map = new DMap();
            map.appendChild(c);
            return map;
        }
        if (c instanceof DCaption || c instanceof DCol || c instanceof DColGroup) {
            DTable table = new DTable().setHtmlWidth("500").setHtmlBorder("3");
            table.appendChild(c);
            return table;
        }
        if (c instanceof DDd) {
            DDt ddt = new DDt();
            ddt.appendChild(c);
            return ddt;
        }
        if (c instanceof DLi) {
            DOl dol = new DOl();
            dol.setHtmlType("1");
            dol.appendChild(c);
            return dol;
        }
        if (c instanceof DDt) {
            DDl ddl = new DDl();
            ddl.appendChild(c);
            return ddl;
        }
        if (c instanceof DLegend) {
            DForm form = new DForm();
            DFieldSet fieldset = new DFieldSet();
            form.appendChild((Node)((Object)fieldset));
            fieldset.appendChild(c);
            return form;
        }
        if (c instanceof DSelect) {
            DForm form = new DForm();
            form.appendChild(c);
            return form;
        }
        if (c instanceof DOptGroup) {
            DForm form = new DForm();
            DSelect s = new DSelect();
            form.appendChild((Node)((Object)s));
            s.appendChild(c);
            return form;
        }
        if (c instanceof DOption) {
            DForm form = new DForm();
            DSelect s = new DSelect();
            DOptGroup g = new DOptGroup();
            form.appendChild((Node)((Object)s));
            s.appendChild((Node)((Object)g));
            g.appendChild(c);
            return form;
        }
        if (c instanceof DParam) {
            DObject object = new DObject();
            object.appendChild(c);
            return object;
        }
        if (c instanceof DTBody || c instanceof DTHead || c instanceof DTFoot) {
            DTable table = new DTable();
            table.appendChild(c);
            return table;
        }
        if (c instanceof DTr) {
            DTable table = new DTable().setHtmlBorder("3");
            table.appendChild(c);
            return table;
        }
        if (c instanceof DTd || c instanceof DTh) {
            DTable table = new DTable().setHtmlBorder("3");
            DTr tr = new DTr();
            table.appendChild((Node)((Object)tr));
            tr.appendChild(c);
            return table;
        }
        if (c instanceof IDFlow || c instanceof DDel) {
            return c;
        }
        return c;
    }
}

