/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.serializer;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.vjet.dsf.common.context.DsfCtx;
import org.eclipse.vjet.dsf.json.serializer.SerializationException;
import org.eclipse.vjet.dsf.serializer.VjoSerializableSerializer;
import org.eclipse.vjet.dsf.serializer.VjoSerializationCtx;
import org.eclipse.vjet.dsf.serializer.VjoSetSerializedResult;

public class VjoSetSerializer
extends VjoSerializableSerializer {
    private String m_vjoSetUtil = "$sU";

    public String getVjoSetUtil() {
        return this.m_vjoSetUtil;
    }

    public VjoSetSerializer setVjoSetUtil(String util) {
        this.m_vjoSetUtil = util;
        return this;
    }

    @Override
    public boolean canSerialize(Object obj) {
        Class<?> type = obj.getClass();
        return Set.class.isAssignableFrom(type);
    }

    @Override
    protected void preSerialize(Object toSerialize) {
        super.preSerialize(toSerialize);
        VjoSerializationCtx.ctx().setHasVjoSet(true);
    }

    @Override
    public Object doSerialize(Object obj) throws SerializationException {
        VjoSetSerializedResult vjoSet = new VjoSetSerializedResult();
        vjoSet.setVjoId(DsfCtx.ctx().ids().nextJsCompId());
        vjoSet.setVjoSetUtil(this.getVjoSetUtil());
        Class<?> type = obj.getClass();
        if (Set.class.isAssignableFrom(type)) {
            Set set = (Set)obj;
            Iterator it = set.iterator();
            while (it.hasNext()) {
                vjoSet.addVjoObject(this.getOwner().serialize(it.next()));
            }
        }
        return vjoSet;
    }
}

