/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.liveconnect;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.liveconnect.DLCFutureResult;

public class DLCFutureResultMgr {
    private Map<String, DLCFutureResult> m_futureResults = new HashMap<String, DLCFutureResult>();
    private int m_counter = 0;

    DLCFutureResult create() {
        return new DLCFutureResult(String.valueOf(this.getId()), this);
    }

    synchronized void setResult(String requestId, String result) {
        DLCFutureResult futureResult = this.m_futureResults.get(requestId);
        if (futureResult == null) {
            System.err.println("No result for " + requestId + " : " + result);
        } else {
            futureResult.set(result);
        }
    }

    synchronized void addFuture(DLCFutureResult future) {
        this.m_futureResults.put(future.getRequestId(), future);
    }

    synchronized void removeFuture(DLCFutureResult future) {
        this.m_futureResults.remove(future.getRequestId());
        this.notify();
    }

    synchronized void waitForAllDone() {
        while (!this.m_futureResults.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized int getId() {
        return this.m_counter++;
    }
}

