/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdi;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jsdi.ISession;
import org.eclipse.vjet.dsf.jsdi.IValue;
import org.eclipse.vjet.dsf.jsdi.IVariable;
import org.eclipse.vjet.dsf.jsdi.VariableType;

public class Value
implements IValue,
Serializable {
    private static final long serialVersionUID = 1L;
    private VariableType m_type;
    private String m_typeName;
    private Object m_value;
    private Map<String, IVariable> m_members = null;

    public static Value forPrimitive(Object primitiveValue) {
        if (primitiveValue == null) {
            return new Value(VariableType.NULL, "null", primitiveValue);
        }
        if (primitiveValue == UNDEFINED) {
            return new Value(VariableType.UNDEFINED, "undefined", primitiveValue);
        }
        if (primitiveValue instanceof Boolean) {
            return new Value(VariableType.BOOLEAN, "Boolean", primitiveValue);
        }
        if (primitiveValue instanceof Double) {
            return new Value(VariableType.NUMBER, "Number", primitiveValue);
        }
        if (primitiveValue instanceof String) {
            return new Value(VariableType.STRING, "String", primitiveValue);
        }
        return null;
    }

    public Value(VariableType type, String typeName, Object value) {
        this.m_type = type;
        this.m_typeName = typeName;
        this.m_value = value;
    }

    @Override
    public long getId() {
        if (this.m_value instanceof Long) {
            return (Long)this.m_value;
        }
        return -1L;
    }

    @Override
    public int getMemberCount(ISession session) {
        this.loadMembers(session);
        return this.m_members == null ? 0 : this.m_members.size();
    }

    @Override
    public IVariable getMember(String name, ISession session) {
        this.loadMembers(session);
        if (this.m_members != null) {
            return this.m_members.get(name);
        }
        return null;
    }

    @Override
    public IVariable getMember(int childIndex, ISession session) {
        this.loadMembers(session);
        int count = 0;
        for (IVariable variable : this.m_members.values()) {
            if (childIndex == count) {
                return variable;
            }
            ++count;
        }
        return null;
    }

    @Override
    public IVariable[] getMembers(ISession session) {
        int count = this.getMemberCount(session);
        IVariable[] memberArr = new IVariable[count];
        if (count > 0) {
            count = 0;
            Iterator<IVariable> itr = this.m_members.values().iterator();
            while (itr.hasNext()) {
                memberArr[count++] = itr.next();
            }
        }
        return memberArr;
    }

    @Override
    public VariableType getType() {
        return this.m_type;
    }

    @Override
    public String getTypeName() {
        return this.m_typeName;
    }

    @Override
    public String getObjectValueAsString(ISession session) {
        if (this.m_type != VariableType.OBJECT) {
            return Value.getValueAsString(this.m_value);
        }
        try {
            return session.getObjectValueAsString(this.getId());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getValueAsString(Object value) {
        long longValue;
        double doubleValue;
        if (value == null) {
            return "null";
        }
        if (value instanceof Double && (doubleValue = ((Double)value).doubleValue()) == (double)(longValue = (long)doubleValue)) {
            return Long.toString(longValue);
        }
        return value.toString();
    }

    public void addMember(IVariable v) {
        if (this.m_members == null) {
            this.m_members = new LinkedHashMap<String, IVariable>();
        }
        this.m_members.put(v.getName(), v);
    }

    public boolean membersObtained() {
        return this.getId() == -1L || this.m_members != null;
    }

    public void setMembersObtained(boolean obtained) {
        if (obtained) {
            if (this.m_members == null) {
                this.m_members = Collections.emptyMap();
            }
        } else {
            this.m_members = null;
        }
    }

    private void loadMembers(ISession session) {
        if (this.m_members != null) {
            return;
        }
        long id = this.getId();
        if (id == -1L) {
            return;
        }
        try {
            IVariable[] members;
            IVariable[] iVariableArray = members = session.loadMembers(id);
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable member = iVariableArray[n2];
                this.addMember(member);
                ++n2;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.setMembersObtained(true);
    }
}

