/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;

final class PropertySetCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger m_debugger;

    PropertySetCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        String name = options.get("-n");
        int num = Integer.parseInt(options.get("-d"));
        String value = Base64Helper.decodeString(options.get("--"));
        if (num >= 0) {
            DBGPDebugFrame fr = this.m_debugger.m_stackmanager.getStackFrame(num);
            fr.setValue(name, value);
        } else {
            boolean parseBoolean;
            if (name.equals("suspendOnEntry")) {
                parseBoolean = Boolean.valueOf(value);
                this.m_debugger.setSuspendOnEntry(parseBoolean);
            }
            if (name.equals("suspendOnExit")) {
                parseBoolean = Boolean.valueOf(value);
                this.m_debugger.setSuspendOnExit(parseBoolean);
            }
            this.m_debugger.setProperty(name, value);
        }
        this.m_debugger.printResponse("<response command=\"property_set\"\r\n transaction_id=\"" + options.get("-i") + "\" success=\"1\" " + ">\r\n" + "</response>\r\n");
    }
}

