/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dap.proxy;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.vjet.dsf.dap.proxy.NativeJsHelper;
import org.eclipse.vjet.dsf.dap.util.IterableJs;
import org.mozilla.mod.javascript.IJsJavaProxy;
import org.mozilla.mod.javascript.NativeArray;
import org.mozilla.mod.javascript.Scriptable;

public class Array
implements IJsJavaProxy,
IterableJs<Integer> {
    private NativeArray m_nativeArr;
    private static final Object[] EMPTY_ARGS = new Object[0];

    public Array(Scriptable nativeObj) {
        this.m_nativeArr = (NativeArray)nativeObj;
        this.m_nativeArr.put("_js_java_proxy", (Scriptable)this.m_nativeArr, (Object)this);
    }

    public Array() {
        this(0);
    }

    public Array(int initLength) {
        this((Scriptable)NativeJsHelper.createNativeArray(initLength));
    }

    public Array(Object ... values) {
        this(values.length);
        int i = 0;
        while (i < values.length) {
            this.put(i, values[i]);
            ++i;
        }
    }

    public Object get(int index) {
        Object value = this.m_nativeArr.get(index, (Scriptable)this.m_nativeArr);
        if (value == null || value == Scriptable.NOT_FOUND) {
            return value;
        }
        return NativeJsHelper.convert(Object.class, value);
    }

    public void put(int index, Object value) {
        this.m_nativeArr.put(index, (Scriptable)this.m_nativeArr, NativeJsHelper.toNative(value));
    }

    public int getLength() {
        return (int)this.m_nativeArr.getLength();
    }

    public Object pop() {
        return NativeJsHelper.convert(Object.class, NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"pop", (Object[])EMPTY_ARGS));
    }

    public int push(Object ... elements) {
        return NativeJsHelper.convert(Integer.class, NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"push", (Object[])NativeJsHelper.toNatives(elements)));
    }

    public Object shift() {
        return NativeJsHelper.convert(Object.class, NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"shift", (Object[])EMPTY_ARGS));
    }

    public int unshift(Object ... elements) {
        return NativeJsHelper.convert(Integer.class, NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"unshift", (Object[])NativeJsHelper.toNatives(elements)));
    }

    public Array reverse() {
        NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"reverse", (Object[])EMPTY_ARGS);
        return this;
    }

    public Array slice(int start) {
        return this.slice(start, this.getLength());
    }

    public Array slice(int start, int end) {
        Object[] args = new Object[]{start, end};
        Object obj = NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"slice", (Object[])NativeJsHelper.toNatives(args));
        return new Array((Scriptable)obj);
    }

    public Array sort() {
        NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"sort", (Object[])EMPTY_ARGS);
        return this;
    }

    public Array splice(int index, int howmany, Object ... elements) {
        Object[] args = new Object[2 + elements.length];
        args[0] = index;
        args[1] = howmany;
        int i = 2;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            args[i++] = elem;
            ++n2;
        }
        Object obj = NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"splice", (Object[])NativeJsHelper.toNatives(args));
        return new Array((Scriptable)obj);
    }

    public Array concat(Array ... arraies) {
        Object[] args = new Object[arraies.length];
        int i = 0;
        Array[] arrayArray = arraies;
        int n = arraies.length;
        int n2 = 0;
        while (n2 < n) {
            Array other = arrayArray[n2];
            args[i++] = other.m_nativeArr;
            ++n2;
        }
        return new Array((Scriptable)NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"concat", (Object[])args));
    }

    public String join(String separator) {
        return NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"join", (Object[])new Object[]{separator}).toString();
    }

    public String join() {
        return this.join(",");
    }

    public String toString() {
        return NativeArray.callMethod((Scriptable)this.m_nativeArr, (String)"toString", (Object[])EMPTY_ARGS).toString();
    }

    public Scriptable getJsNative() {
        return this.m_nativeArr;
    }

    @Override
    public Iterator<Integer> iterator() {
        Object[] ids = this.m_nativeArr.getIds();
        ArrayList<Integer> valueList = new ArrayList<Integer>(ids.length);
        Object[] objectArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            valueList.add(Integer.valueOf(id.toString()));
            ++n2;
        }
        return valueList.iterator();
    }

    public static <T> Array make(T[] values) {
        Array arr = new Array(values);
        int i = 0;
        while (i < values.length) {
            arr.put(i, values[i]);
            ++i;
        }
        return arr;
    }

    public static Array make(int[] values) {
        Array arr = new Array(new Object[]{values});
        int i = 0;
        while (i < values.length) {
            arr.put(i, values[i]);
            ++i;
        }
        return arr;
    }

    public static Array make(double[] values) {
        Array arr = new Array(new Object[]{values});
        int i = 0;
        while (i < values.length) {
            arr.put(i, values[i]);
            ++i;
        }
        return arr;
    }

    public static Array make(boolean[] values) {
        Array arr = new Array(new Object[]{values});
        int i = 0;
        while (i < values.length) {
            arr.put(i, values[i]);
            ++i;
        }
        return arr;
    }
}

