/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.lookup;

import java.util.Hashtable;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    public ReferenceBinding[] mixins = Binding.NO_MIXINS;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    public ReferenceBinding[] memberTypes = Binding.NO_MEMBER_TYPES;
    public Scope scope;
    public ClassScope classScope;
    char[] genericReferenceTypeSignature;
    public SourceTypeBinding nextType;

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, Scope scope) {
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        this.fileName = scope.referenceCompilationUnit().getFileName();
        if (scope instanceof ClassScope) {
            this.classScope = (ClassScope)scope;
            if (this.classScope.referenceContext != null) {
                this.modifiers = this.classScope.referenceContext.modifiers;
                this.sourceName = this.classScope.referenceContext.name;
            }
        }
        this.scope = scope;
        this.fields = Binding.NO_FIELDS;
        this.computeId();
    }

    protected SourceTypeBinding() {
    }

    @Override
    public int kind() {
        return 4;
    }

    @Override
    public char[] computeUniqueKey(boolean isLeaf) {
        return null;
    }

    @Override
    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        return false;
    }

    @Override
    public ReferenceBinding[] memberTypes() {
        if (this.nextType == null) {
            return this.memberTypes;
        }
        ReferenceBinding[] moreTypes = this.nextType.memberTypes();
        ReferenceBinding[] combinedTypes = new ReferenceBinding[this.memberTypes.length + moreTypes.length];
        System.arraycopy(this.memberTypes, 0, combinedTypes, 0, this.memberTypes.length);
        System.arraycopy(moreTypes, 0, combinedTypes, this.memberTypes.length, moreTypes.length);
        return combinedTypes;
    }

    public FieldBinding getUpdatedFieldBinding(FieldBinding targetField, ReferenceBinding newDeclaringClass) {
        Hashtable<ReferenceBinding, FieldBinding> fieldMap = new Hashtable<ReferenceBinding, FieldBinding>(5);
        FieldBinding updatedField = new FieldBinding(targetField, newDeclaringClass);
        fieldMap.put(newDeclaringClass, updatedField);
        return updatedField;
    }

    @Override
    public boolean hasMemberTypes() {
        boolean hasMembers;
        boolean bl = hasMembers = this.memberTypes != null && this.memberTypes.length > 0;
        if (!hasMembers && this.nextType != null) {
            hasMembers = this.nextType.hasMemberTypes();
        }
        return hasMembers;
    }

    public void setFields(FieldBinding[] fields) {
        this.fields = fields;
    }

    public void setMethods(MethodBinding[] methods) {
        this.methods = methods;
    }

    public int sourceEnd() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceEnd;
        }
        return 0;
    }

    public int sourceStart() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceStart;
        }
        return 0;
    }

    @Override
    public ReferenceBinding superclass() {
        if (this.nextType == null) {
            return this.superclass;
        }
        if (this.superclass != null && this.superclass.id != 1) {
            return this.superclass;
        }
        return this.nextType.superclass();
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            buffer.append("NoId");
        } else {
            buffer.append(this.id);
        }
        buffer.append(")\n");
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            buffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.enclosingType() != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append('\n').append(this.fields[i] != null ? this.fields[i].toString() : "NULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            buffer.append("\n/*   methods   */");
            i = 0;
            length = this.methods.length;
            while (i < length) {
                buffer.append('\n').append(this.methods[i] != null ? this.methods[i].toString() : "NULL METHOD");
                ++i;
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append('\n').append(this.memberTypes[i] != null ? this.memberTypes[i].toString() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    @Override
    public void cleanup() {
        this.scope = null;
        this.classScope = null;
    }

    public boolean contains(ReferenceBinding binding) {
        if (binding == this) {
            return true;
        }
        if (this.nextType != null) {
            return this.nextType.contains(binding);
        }
        return false;
    }

    public void addNextType(SourceTypeBinding type) {
        SourceTypeBinding binding = this;
        while (binding.nextType != null) {
            binding = binding.nextType;
        }
        binding.nextType = type;
    }
}

