/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.mod.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.mod.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.mod.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.GlobalBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.HashtableOfPackage;
import org.eclipse.mod.wst.jsdt.internal.oaametadata.LibraryAPIs;

public class LookupEnvironment
implements ProblemReasons,
TypeConstants {
    static final int BUILD_FIELDS_AND_METHODS = 4;
    static final int BUILD_TYPE_HIERARCHY = 1;
    static final int CHECK_AND_SET_IMPORTS = 2;
    static final int CONNECT_TYPE_HIERARCHY = 3;
    static final ProblemReferenceBinding TheNotFoundType = new ProblemReferenceBinding(CharOperation.NO_CHAR, null, 1);
    private Map accessRestrictions;
    ImportBinding[] defaultImports;
    public PackageBinding defaultPackage;
    HashtableOfPackage knownPackages;
    private int lastCompletedUnitIndex = -1;
    private int lastUnitIndex = -1;
    public INameEnvironment nameEnvironment;
    public CompilerOptions globalOptions;
    public ProblemReporter problemReporter;
    private int stepCompleted;
    public ITypeRequestor typeRequestor;
    private ArrayBinding[][] uniqueArrayBindings;
    public CompilationUnitDeclaration unitBeingCompleted = null;
    public Object missingClassFileLocation = null;
    private CompilationUnitDeclaration[] units = new CompilationUnitDeclaration[4];
    HashSet acceptedCompilationUnits = new HashSet();

    public LookupEnvironment(ITypeRequestor typeRequestor, CompilerOptions globalOptions, ProblemReporter problemReporter, INameEnvironment nameEnvironment) {
        this.typeRequestor = typeRequestor;
        this.globalOptions = globalOptions;
        this.problemReporter = problemReporter;
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.nameEnvironment = nameEnvironment;
        this.knownPackages = new HashtableOfPackage();
        this.uniqueArrayBindings = new ArrayBinding[5][];
        this.uniqueArrayBindings[0] = new ArrayBinding[50];
        this.accessRestrictions = new HashMap(3);
    }

    public ReferenceBinding askForType(char[][] compoundName) {
        NameEnvironmentAnswer answer = this.nameEnvironment.findType(compoundName, this.typeRequestor);
        if (answer == null) {
            return null;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), this.computePackageFrom(compoundName), answer.getAccessRestriction());
        } else if (answer.isCompilationUnit()) {
            ICompilationUnit compilationUnit = answer.getCompilationUnit();
            String fileName = new String(compilationUnit.getFileName());
            if (!this.acceptedCompilationUnits.contains(fileName)) {
                this.acceptedCompilationUnits.add(fileName);
                this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
            }
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), this.computePackageFrom(compoundName), answer.getAccessRestriction());
        } else if (answer.isMetaData()) {
            LibraryAPIs metadata = answer.getLibraryMetadata();
            if (!this.acceptedCompilationUnits.contains(metadata.fileName)) {
                this.acceptedCompilationUnits.add(metadata.fileName);
                this.typeRequestor.accept(metadata);
            }
        }
        return this.getCachedType(compoundName);
    }

    ReferenceBinding askForType(PackageBinding packageBinding, char[] name) {
        return (ReferenceBinding)this.askForBinding(packageBinding, name, 16388);
    }

    void addUnitsContainingBinding(PackageBinding packageBinding, char[] name, int mask, String excludePath) {
        NameEnvironmentAnswer answer;
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return;
            }
            packageBinding = this.defaultPackage;
        }
        if ((answer = this.nameEnvironment.findBinding(name, packageBinding.compoundName, mask, this.typeRequestor, true, excludePath)) == null) {
            return;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), packageBinding, answer.getAccessRestriction());
        } else if (answer.isCompilationUnit()) {
            ICompilationUnit compilationUnit = answer.getCompilationUnit();
            String fileName = new String(compilationUnit.getFileName());
            if (!this.acceptedCompilationUnits.contains(fileName)) {
                this.acceptedCompilationUnits.add(fileName);
                this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
            }
        } else if (answer.isCompilationUnits()) {
            ICompilationUnit[] compilationUnits = answer.getCompilationUnits();
            int i = 0;
            while (i < compilationUnits.length) {
                String fileName = new String(compilationUnits[i].getFileName());
                if (!this.acceptedCompilationUnits.contains(fileName)) {
                    this.acceptedCompilationUnits.add(fileName);
                    this.typeRequestor.accept(compilationUnits[i], answer.getAccessRestriction());
                }
                ++i;
            }
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), packageBinding, answer.getAccessRestriction());
        }
    }

    Binding askForBinding(GlobalBinding globalBinding, char[] name, int mask) {
        return null;
    }

    Binding askForBinding(PackageBinding packageBinding, char[] name, int mask) {
        if (packageBinding == null) {
            if (this.defaultPackage == null) {
                return null;
            }
            packageBinding = this.defaultPackage;
        }
        if (mask == 16384 && (name == null || name.length == 0) && this.defaultPackage.compoundName.length == 0) {
            return this.defaultPackage;
        }
        NameEnvironmentAnswer answer = this.nameEnvironment.findBinding(name, packageBinding.compoundName, mask, this.typeRequestor, false, null);
        if (answer == null) {
            return null;
        }
        if (answer.isBinaryType()) {
            this.typeRequestor.accept(answer.getBinaryType(), packageBinding, answer.getAccessRestriction());
        } else if (answer.isCompilationUnit()) {
            ICompilationUnit compilationUnit = answer.getCompilationUnit();
            String fileName = new String(compilationUnit.getFileName());
            if (!this.acceptedCompilationUnits.contains(fileName)) {
                this.acceptedCompilationUnits.add(fileName);
                this.typeRequestor.accept(compilationUnit, answer.getAccessRestriction());
            }
        } else if (answer.isSourceType()) {
            this.typeRequestor.accept(answer.getSourceTypes(), packageBinding, answer.getAccessRestriction());
        } else if (answer.isMetaData()) {
            LibraryAPIs metadata = answer.getLibraryMetadata();
            if (!this.acceptedCompilationUnits.contains(metadata.fileName)) {
                this.acceptedCompilationUnits.add(metadata.fileName);
                this.typeRequestor.accept(metadata);
            }
        }
        return packageBinding.getBinding0(name, mask);
    }

    public TypeBinding computeBoxingType(TypeBinding type) {
        return null;
    }

    private PackageBinding computePackageFrom(char[][] constantPoolName) {
        return this.defaultPackage;
    }

    public PackageBinding createPackage(char[][] compoundName) {
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null) {
            packageBinding = new PackageBinding(compoundName[0], this);
        }
        int i = 1;
        int length = compoundName.length;
        while (i < length) {
            ReferenceBinding type = packageBinding.getType0(compoundName[i]);
            if (type != null && type != TheNotFoundType && !(type instanceof UnresolvedReferenceBinding)) {
                return null;
            }
            PackageBinding parent = packageBinding;
            if ((packageBinding = parent.getPackage0(compoundName[i])) == null) {
                packageBinding = new PackageBinding(CharOperation.subarray(compoundName, 0, i + 1), parent, this);
                parent.addPackage(packageBinding);
            }
            ++i;
        }
        return packageBinding;
    }

    public AccessRestriction getAccessRestriction(TypeBinding type) {
        return (AccessRestriction)this.accessRestrictions.get(type);
    }

    public ReferenceBinding getCachedType(char[][] compoundName) {
        if (compoundName.length == 1) {
            if (this.defaultPackage == null) {
                return null;
            }
            return this.defaultPackage.getType0(compoundName[0]);
        }
        PackageBinding packageBinding = this.getPackage0(compoundName[0]);
        if (packageBinding == null) {
            return null;
        }
        int i = 1;
        int packageLength = compoundName.length - 1;
        while (i < packageLength) {
            if ((packageBinding = packageBinding.getPackage0(compoundName[i])) == null) {
                return null;
            }
            ++i;
        }
        return packageBinding.getType0(compoundName[compoundName.length - 1]);
    }

    PackageBinding getPackage0(char[] name) {
        if (CharOperation.equals(name, this.defaultPackage.readableName())) {
            return this.defaultPackage;
        }
        return this.knownPackages.get(name);
    }

    PackageBinding getTopLevelPackage(char[] name) {
        if (CharOperation.equals(name, this.defaultPackage.readableName())) {
            return this.defaultPackage;
        }
        PackageBinding packageBinding = this.getPackage0(name);
        if (packageBinding != null) {
            return packageBinding;
        }
        if (this.nameEnvironment.isPackage(null, name)) {
            packageBinding = new PackageBinding(name, this);
            this.knownPackages.put(name, packageBinding);
            return packageBinding;
        }
        return null;
    }

    boolean isPackage(char[][] compoundName, char[] name) {
        if (compoundName == null || compoundName.length == 0) {
            return this.nameEnvironment.isPackage(null, name);
        }
        return this.nameEnvironment.isPackage(compoundName, name);
    }

    public void reset() {
        this.defaultPackage = new PackageBinding(this);
        this.defaultImports = null;
        this.accessRestrictions = new HashMap(3);
        int i = this.uniqueArrayBindings.length;
        while (--i >= 0) {
            ArrayBinding[] arrayBindings = this.uniqueArrayBindings[i];
            if (arrayBindings == null) continue;
            int j = arrayBindings.length;
            while (--j >= 0) {
                arrayBindings[j] = null;
            }
        }
        i = this.units.length;
        while (--i >= 0) {
            this.units[i] = null;
        }
        this.lastUnitIndex = -1;
        this.lastCompletedUnitIndex = -1;
        this.unitBeingCompleted = null;
        this.acceptedCompilationUnits.clear();
    }

    public void setAccessRestriction(ReferenceBinding type, AccessRestriction accessRestriction) {
        if (accessRestriction == null) {
            return;
        }
        type.modifiers |= 0x40000;
        this.accessRestrictions.put(type, accessRestriction);
    }
}

