/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.flow;

import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.NullInfoRegistry;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public static final FlowContext NotContinuableContext = new FlowContext(null, null);
    public ASTNode associatedNode;
    public FlowContext parent;
    public NullInfoRegistry initsOnFinally;
    boolean deferNullDiagnostic;
    boolean preemptNullDiagnostic;
    public static final int CAN_ONLY_NULL_NON_NULL = 0;
    public static final int CAN_ONLY_NULL = 1;
    public static final int CAN_ONLY_NON_NULL = 2;
    public static final int MAY_NULL = 3;
    public static final int CHECK_MASK = 255;
    public static final int IN_COMPARISON_NULL = 256;
    public static final int IN_COMPARISON_NON_NULL = 512;
    public static final int IN_ASSIGNMENT = 768;
    public static final int IN_INSTANCEOF = 1024;
    public static final int CONTEXT_MASK = -256;

    public FlowContext(FlowContext parent, ASTNode associatedNode) {
        this.parent = parent;
        this.associatedNode = associatedNode;
        if (parent != null) {
            this.deferNullDiagnostic = parent.deferNullDiagnostic || parent.preemptNullDiagnostic;
            this.initsOnFinally = parent.initsOnFinally;
        }
    }

    public FlowContext getTargetContextForBreakLabel(char[] labelName) {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            char[] currentLabelName;
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if ((currentLabelName = current.labelName()) != null && CharOperation.equals(currentLabelName, labelName)) {
                ((LabeledStatement)current.associatedNode).bits |= 0x40;
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] labelName) {
        FlowContext current = this;
        FlowContext lastContinuable = null;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            } else if (current.isContinuable()) {
                lastContinuable = current;
            }
            char[] currentLabelName = current.labelName();
            if (currentLabelName != null && CharOperation.equals(currentLabelName, labelName)) {
                ((LabeledStatement)current.associatedNode).bits |= 0x40;
                if (lastContinuable != null && current.associatedNode.concreteStatement() == lastContinuable.associatedNode) {
                    if (lastNonReturningSubRoutine == null) {
                        return lastContinuable;
                    }
                    return lastNonReturningSubRoutine;
                }
                return NotContinuableContext;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if (current.isBreakable() && current.labelName() == null) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if (current.isContinuable()) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordBreakTo(FlowContext targetContext) {
    }

    public void recordContinueFrom(FlowContext innerFlowContext, FlowInfo flowInfo) {
    }

    protected boolean recordFinalAssignment(VariableBinding variable, Reference finalReference) {
        return true;
    }

    protected void recordNullReference(LocalVariableBinding local, Expression expression, int status) {
    }

    public void recordReturnFrom(UnconditionalFlowInfo flowInfo) {
    }

    public void recordSettingFinal(VariableBinding variable, Reference finalReference, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            FlowContext context = this;
            while (context != null) {
                if (!context.recordFinalAssignment(variable, finalReference)) break;
                context = context.parent;
            }
        }
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding local, Expression reference, int checkType, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0 || flowInfo.isDefinitelyUnknown(local)) {
            return;
        }
        switch (checkType) {
            case 256: 
            case 512: {
                if (flowInfo.isDefinitelyNonNull(local)) {
                    if (checkType == 512) {
                        scope.problemReporter().localVariableRedundantCheckOnNonNull(local, reference);
                    } else {
                        scope.problemReporter().localVariableNonNullComparedToNull(local, reference);
                    }
                    return;
                }
                if (flowInfo.cannotBeDefinitelyNullOrNonNull(local)) {
                    return;
                }
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                if (flowInfo.isDefinitelyNull(local)) {
                    switch (checkType & 0xFFFFFF00) {
                        case 256: {
                            scope.problemReporter().localVariableRedundantCheckOnNull(local, reference);
                            return;
                        }
                        case 512: {
                            scope.problemReporter().localVariableNullComparedToNonNull(local, reference);
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(local, reference);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(local, reference);
                            return;
                        }
                    }
                    break;
                }
                if (!flowInfo.cannotBeDefinitelyNullOrNonNull(local)) break;
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNull(local)) {
                    scope.problemReporter().localVariableNullReference(local, reference);
                    return;
                }
                if (!flowInfo.isPotentiallyNull(local)) break;
                scope.problemReporter().localVariablePotentialNullReference(local, reference);
                return;
            }
        }
        if (this.parent != null) {
            this.parent.recordUsingNullReference(scope, local, reference, checkType, flowInfo);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
    }

    public SubRoutineStatement subroutine() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        FlowContext current = this;
        int parentsCount = 0;
        while ((current = current.parent) != null) {
            ++parentsCount;
        }
        FlowContext[] parents = new FlowContext[parentsCount + 1];
        current = this;
        int index = parentsCount;
        while (index >= 0) {
            parents[index--] = current;
            current = current.parent;
        }
        int i = 0;
        while (i < parentsCount) {
            int j = 0;
            while (j < i) {
                buffer.append('\t');
                ++j;
            }
            buffer.append(parents[i].individualToString()).append('\n');
            ++i;
        }
        buffer.append('*');
        int j = 0;
        while (j < parentsCount + 1) {
            buffer.append('\t');
            ++j;
        }
        buffer.append(this.individualToString()).append('\n');
        return buffer.toString();
    }
}

