/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IFieldReference;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Reference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeConstants;

public class FieldReference
extends Reference
implements InvocationSite,
IFieldReference {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    public TypeBinding typeBinding;
    public long nameSourcePosition;
    public TypeBinding receiverType;

    public FieldReference(char[] source, long pos) {
        this.token = source;
        this.nameSourcePosition = pos;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)(pos & 0xFFFFFFFFL);
        this.bits |= 1;
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        if (runtimeTimeType == null || compileTimeType == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            this.binding.original();
        }
    }

    @Override
    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    @Override
    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    @Override
    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo, boolean isReadAccess) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
    }

    @Override
    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    @Override
    public Constant optimizedBooleanConstant() {
        switch (this.resolvedType.id) {
            case 5: 
            case 33: {
                return Constant.NotAConstant;
            }
        }
        return Constant.NotAConstant;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.receiver.printExpression(0, output).append('.').append(this.token);
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    @Override
    public void setFieldIndex(int index) {
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public boolean isPrototype() {
        return CharOperation.equals(TypeConstants.PROTOTYPE, this.token);
    }

    @Override
    public int getASTType() {
        return 37;
    }

    public char[][] asQualifiedName() {
        ArrayList<char[]> list = new ArrayList<char[]>();
        list.add(this.token);
        FieldReference fieldReference = this;
        while (fieldReference != null) {
            if (fieldReference.receiver instanceof SingleNameReference) {
                list.add(0, ((SingleNameReference)fieldReference.receiver).token);
                fieldReference = null;
                continue;
            }
            if (fieldReference.receiver instanceof FieldReference) {
                fieldReference = (FieldReference)fieldReference.receiver;
                list.add(0, fieldReference.token);
                continue;
            }
            return null;
        }
        return (char[][])list.toArray((T[])new char[list.size()][]);
    }

    public IExpression getReceiver() {
        return this.receiver;
    }

    public char[] getToken() {
        return this.token;
    }

    @Override
    public boolean isTypeReference() {
        return (this.bits & 4) == 4;
    }
}

