/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IArrayAllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;

public class ArrayAllocationExpression
extends Expression
implements IArrayAllocationExpression {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.type.print(0, output);
        int i = 0;
        while (i < this.dimensions.length) {
            if (this.dimensions[i] == null) {
                output.append("[]");
            } else {
                output.append('[');
                this.dimensions[i].printExpression(0, output);
                output.append(']');
            }
            ++i;
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, output);
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int dimensionsLength = this.dimensions.length;
            this.type.traverse(visitor, scope);
            int i = 0;
            while (i < dimensionsLength) {
                if (this.dimensions[i] != null) {
                    this.dimensions[i].traverse(visitor, scope);
                }
                ++i;
            }
            if (this.initializer != null) {
                this.initializer.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 8;
    }
}

