/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.wizards.Messages;
import org.eclipse.dltk.mod.ui.wizards.NewElementWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.vjet.eclipse.internal.ui.wizards.VjoSourceModulePage;

public abstract class VjoSourceModuleWizard
extends NewElementWizard {
    protected VjoSourceModulePage page;
    private ISourceModule module;
    private String modifierIndex = "";

    protected abstract VjoSourceModulePage createVjoSourceModulePage();

    public void addPages() {
        super.addPages();
        this.page = this.createVjoSourceModulePage();
        this.page.init(this.getSelection());
        this.addPage((IWizardPage)this.page);
    }

    public IModelElement getCreatedElement() {
        return this.module;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.modifierIndex = this.page.getModifiers();
        this.module = this.page.createFile(monitor);
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result && this.module != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        EditorUtility.openInEditor((Object)VjoSourceModuleWizard.this.module);
                    }
                    catch (PartInitException e) {
                        DLTKUIPlugin.logErrorMessage((String)MessageFormat.format(Messages.NewSourceModuleWizard_errorInOpenInEditor, VjoSourceModuleWizard.this.module.getElementName()), (Throwable)e);
                    }
                    catch (ModelException e) {
                        DLTKUIPlugin.logErrorMessage((String)MessageFormat.format(Messages.NewSourceModuleWizard_errorInOpenInEditor, VjoSourceModuleWizard.this.module.getElementName()), (Throwable)e);
                    }
                }
            });
        }
        return result;
    }

    public String getModifierIndex() {
        return this.modifierIndex;
    }

    public VjoSourceModulePage getPage() {
        return this.page;
    }
}

