/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.text.completion;

import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.ui.templates.IScriptTemplateIndenter;
import org.eclipse.dltk.mod.ui.templates.NopScriptTemplateIndenter;
import org.eclipse.dltk.mod.utils.TextUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;

public class VjoProposalLabelUtil {
    public static String evaluateIndent(String str, IDocument document, int replaceOffset) {
        if (document == null) {
            return str;
        }
        String[] lines = TextUtils.splitLines((CharSequence)str);
        if (lines.length > 1) {
            String delimeter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            String indent = VjoProposalLabelUtil.calculateIndent(document, replaceOffset);
            IScriptTemplateIndenter indenter = VjoProposalLabelUtil.getIndenter();
            StringBuffer buffer = new StringBuffer(lines[0]);
            int i = 1;
            while (i < lines.length) {
                buffer.append(delimeter);
                indenter.indentLine(buffer, indent, lines[i]);
                ++i;
            }
            return buffer.toString();
        }
        return str;
    }

    protected static String calculateIndent(IDocument document, int offset) {
        block4: {
            try {
                IRegion region = document.getLineInformationOfOffset(offset);
                String indent = document.get(region.getOffset(), offset - region.getOffset());
                int i = 0;
                while (i < indent.length() && StringUtils.isSpaceOrTab((char)indent.charAt(i))) {
                    ++i;
                }
                if (i > 0) {
                    return indent.substring(0, i);
                }
            }
            catch (BadLocationException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        return "";
    }

    public static int translateModifers(int jstModifer) {
        if ((jstModifer & 1) != 0) {
            return 128;
        }
        if ((jstModifer & 4) != 0) {
            return 64;
        }
        if ((jstModifer & 2) != 0) {
            return 32;
        }
        return 0;
    }

    protected static IScriptTemplateIndenter getIndenter() {
        return new NopScriptTemplateIndenter();
    }

    public static int getVjoModifierForImage(JstModifiers modifiers) {
        int result = 0;
        if (modifiers == null) {
            return result;
        }
        if (modifiers.isStatic()) {
            result |= 8;
        }
        if (modifiers.isAbstract()) {
            result |= 1;
        }
        if (modifiers.isFinal()) {
            result |= 2;
        }
        return result;
    }

    public static int getDltkModifyFlag(JstModifiers modifiers) {
        if (modifiers.isPublic()) {
            return 128;
        }
        if (modifiers.isProtected()) {
            return 64;
        }
        if (modifiers.isPrivate()) {
            return 32;
        }
        return 0;
    }

    public static JstModifiers getModifiers(IJstNode node) {
        JstModifiers modifies = null;
        if (node instanceof IJstMethod) {
            IJstMethod method = (IJstMethod)node;
            modifies = method.getModifiers();
        } else if (node instanceof IJstProperty) {
            IJstProperty property = (IJstProperty)node;
            modifies = property.getModifiers();
        } else if (node instanceof IJstType) {
            IJstType type = (IJstType)node;
            modifies = type.getModifiers();
        }
        return modifies;
    }
}

