/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.mod.ui.preferences.PreferenceKey;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRuleSet;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;

public class VjetSeverityPreferenceInitializer {
    private static PreferenceKey[] preferenceKeys = null;

    private static PreferenceKey[] getPreferenceKeys() {
        if (preferenceKeys == null) {
            VjetSeverityPreferenceInitializer.initKeys();
        }
        return preferenceKeys;
    }

    private static void initKeys() {
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        ruleRepo.restoreDefaultPolicies();
        String keyName = "";
        ArrayList<PreferenceKey> list = new ArrayList<PreferenceKey>();
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            for (IVjoSemanticRule rule : ruleSet.getRules()) {
                keyName = String.valueOf(ruleSet.getRuleSetName()) + "." + rule.getRuleName();
                list.add(new PreferenceKey("org.eclipse.vjet.eclipse.ui", keyName));
            }
        }
        preferenceKeys = new PreferenceKey[list.size()];
        preferenceKeys = list.toArray(preferenceKeys);
    }

    private static void initSeriorityPreferenceKeys(Preferences pluginPreferences) {
        VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
        ruleRepo.restoreDefaultPolicies();
        String keyName = "";
        for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
            for (IVjoSemanticRule rule : ruleSet.getRules()) {
                keyName = String.valueOf(ruleSet.getRuleSetName()) + "." + rule.getRuleName();
                pluginPreferences.setDefault(keyName, rule.getGlobalRulePolicy().getProblemSeverity(null).toString());
            }
        }
    }
}

