/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javalaunch.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;

public class EclipseResourceUtils {
    static int tabCount = 0;

    public static File getFile(IFile f) {
        return f.getLocation().toFile();
    }

    public static String getResourceUri(IResource resource) {
        String resourceName = resource.getName();
        IPath parentPath = resource.getParent().getProjectRelativePath();
        String[] segments = parentPath.segments();
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        if (segments.length > 1) {
            int idx = 1;
            while (idx < segments.length) {
                sb.append(segments[idx]);
                sb.append("/");
                ++idx;
            }
        }
        sb.append(resourceName);
        return sb.toString().substring(0, sb.toString().length());
    }

    public static String getResourceClassName(IResource resource) {
        IJavaProject javaProject = EclipseResourceUtils.getJavaProject(resource.getProject());
        if (javaProject != null) {
            String className = EclipseResourceUtils.getQualifiedClassName(resource);
            return className;
        }
        return null;
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (JavaProject.hasJavaNature((IProject)project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static void appendFile(File f, StringBuffer sb) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(f));
        char[] buffer = new char[1000];
        int c = 0;
        while ((c = br.read(buffer)) > 0) {
            sb.append(buffer, 0, c);
        }
    }

    public static List<IClasspathEntry> getClasspathEntry(int type, IClasspathEntry[] classPathEntries) {
        ArrayList<IClasspathEntry> classPathEntryList = new ArrayList<IClasspathEntry>();
        int idx = 0;
        while (idx < classPathEntries.length) {
            IClasspathEntry entry = classPathEntries[idx];
            if (entry.getEntryKind() == type) {
                classPathEntryList.add(entry);
            }
            ++idx;
        }
        return classPathEntryList;
    }

    public static File getSourceRoot(IJavaProject project, IJavaElement e) {
        try {
            IPackageFragment frag = project.findPackageFragment(e.getPath());
            while (!frag.isDefaultPackage()) {
                e = e.getParent();
                frag = project.findPackageFragment(e.getPath());
            }
            File f = e.getResource().getLocation().toFile();
            return f;
        }
        catch (JavaModelException e1) {
            throw new RuntimeException(e1);
        }
    }

    public static boolean isResourceInSourceLocation(IResource resource) {
        boolean resourceIsInSourceLocation = false;
        IProject resourceProject = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)resourceProject);
        if (javaProject != null || !JavaProject.hasJavaNature((IProject)resourceProject)) {
            IPath sourcePath = null;
            try {
                IClasspathEntry[] classPathEntries = javaProject.getRawClasspath();
                List<IClasspathEntry> sourceEntries = EclipseResourceUtils.getClasspathEntry(3, classPathEntries);
                for (IClasspathEntry entry : sourceEntries) {
                    sourcePath = entry.getPath();
                    resourceIsInSourceLocation = EclipseResourceUtils.isResourceInClasspathEntry(resource, sourcePath);
                    if (!resourceIsInSourceLocation) {
                        continue;
                    }
                    break;
                }
            }
            catch (JavaModelException javaModelException) {
                resourceIsInSourceLocation = false;
            }
        }
        return resourceIsInSourceLocation;
    }

    private static boolean isResourceInClasspathEntry(IResource resource, IPath sourcePath) {
        IPath resourcePath = resource.getFullPath();
        boolean resourceIsInSourceLocation = true;
        int idx = 0;
        while (idx < sourcePath.segmentCount()) {
            if (resourcePath.segmentCount() <= idx) {
                resourceIsInSourceLocation = false;
                break;
            }
            if (sourcePath.segments()[idx].compareToIgnoreCase(resourcePath.segments()[idx]) != 0) {
                resourceIsInSourceLocation = false;
                break;
            }
            ++idx;
        }
        return resourceIsInSourceLocation;
    }

    public static String getQualifiedClassName(IResource pResource) {
        String qualifiedClassName = null;
        IProject project = pResource.getProject();
        try {
            IJavaProject proj = JavaCore.create((IProject)project);
            String filePathName = pResource.getLocation().toString();
            if (pResource.getFileExtension().toLowerCase().equals("class")) {
                String outputPath = proj.getOutputLocation().toString();
                String projectPath = project.getLocation().toString();
                outputPath = String.valueOf(projectPath) + outputPath.substring(project.getName().length());
                qualifiedClassName = filePathName.substring(outputPath.length(), filePathName.length() - 6);
                qualifiedClassName = qualifiedClassName.replace('/', '.');
                return qualifiedClassName;
            }
            IPath resourcePath = EclipseResourceUtils.getResourcePackagePath(pResource, proj);
            String resName = pResource.getName();
            String resExtension = pResource.getFileExtension();
            qualifiedClassName = resourcePath.toString();
            qualifiedClassName = qualifiedClassName.replace('/', '.');
            qualifiedClassName = String.valueOf(qualifiedClassName) + "." + resName.substring(0, resName.length() - (resExtension.length() + 1));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return qualifiedClassName;
    }

    public static IResource getResource(URL url) throws URISyntaxException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = workspace.getRoot().findFilesForLocationURI(url.toURI());
        if (files.length == 1) {
            return files[0];
        }
        return null;
    }

    public static void getTransitiveClosureDependencies(IJavaProject javaProject, Map<String, IJavaProject> transitiveClosureProjectList, Map<String, IPath> transitiveLibrarySet) throws JavaModelException {
        IClasspathEntry[] classPathEntries = javaProject.getResolvedClasspath(true);
        if (classPathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (classPathEntry.getEntryKind() == 2) {
                    IResource classPathProject = ResourcesPlugin.getWorkspace().getRoot().findMember(classPathEntry.getPath());
                    if (classPathProject != null && !transitiveClosureProjectList.containsKey(classPathProject.getName())) {
                        IJavaProject subJavaProject = EclipseResourceUtils.getJavaProject(classPathProject);
                        transitiveClosureProjectList.put(classPathProject.getName(), subJavaProject);
                        EclipseResourceUtils.getTransitiveClosureDependencies(subJavaProject, transitiveClosureProjectList, transitiveLibrarySet);
                    }
                } else if (classPathEntry != null && classPathEntry.getEntryKind() == 1 && classPathEntry.getSourceAttachmentPath() != null) {
                    String key = classPathEntry.getSourceAttachmentPath().toString();
                    transitiveLibrarySet.put(key, classPathEntry.getSourceAttachmentPath());
                }
                ++n2;
            }
        }
    }

    public static IJavaProject getJavaProject(IResource resource) {
        if (resource instanceof IProject) {
            return EclipseResourceUtils.getJavaProject((IProject)resource);
        }
        return null;
    }

    public static void getProjectSourcePaths(List<File> sourcePaths, IWorkspaceRoot workspaceRoot, IClasspathEntry[] classPathEntries) {
        if (classPathEntries != null) {
            IClasspathEntry[] iClasspathEntryArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classPathEntry = iClasspathEntryArray[n2];
                if (classPathEntry.getEntryKind() == 3) {
                    File sourceFile;
                    if (classPathEntry.getPath().segmentCount() == 1) {
                        IProject project = workspaceRoot.getProject(classPathEntry.getPath().lastSegment());
                        sourceFile = project.getLocation().toFile();
                    } else {
                        IFile sourceIFile = workspaceRoot.getFile(classPathEntry.getPath());
                        sourceFile = sourceIFile.getLocation().toFile();
                    }
                    assert (sourceFile.exists());
                    sourcePaths.add(sourceFile);
                }
                ++n2;
            }
        }
    }

    public static IProject getWorkspaceProject(String projectName) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject codeGenProject = workspace.getRoot().getProject(projectName);
        if (codeGenProject != null && !codeGenProject.isOpen()) {
            codeGenProject.open(null);
        }
        return codeGenProject;
    }

    public static IFile getEclipseFile(File f) {
        IPath location = Path.fromOSString((String)f.getAbsolutePath());
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] workspaceFiles = workspaceRoot.findFilesForLocation(location);
        if (workspaceFiles.length >= 1) {
            return workspaceFiles[0];
        }
        return workspaceRoot.getFileForLocation(location);
    }

    public static IPath getResourceSourcePath(IResource resource, IJavaProject jProject) {
        IPath sourceFolderPath = EclipseResourceUtils.getResourcePath(resource, jProject);
        if (sourceFolderPath != null) {
            return sourceFolderPath.removeFirstSegments(1);
        }
        return null;
    }

    public static IPath getResourcePackagePath(IResource resource, IJavaProject jProject) {
        IPath resourcePath = EclipseResourceUtils.getResourcePath(resource, jProject);
        if (resourcePath != null) {
            IPath basePath = resource.getFullPath().removeFirstSegments(resourcePath.segmentCount());
            return basePath.removeLastSegments(1);
        }
        return null;
    }

    public static IPath getCommonResourcePackagePath(IResource resource, IJavaProject jProject) {
        IPath resourcePath = EclipseResourceUtils.getResourcePath(resource, jProject);
        if (resourcePath != null) {
            IPath basePath = resource.getFullPath().removeFirstSegments(resourcePath.segmentCount());
            return basePath;
        }
        return null;
    }

    protected static IPath getResourcePath(IResource resource, IJavaProject jProject) {
        if (jProject != null) {
            try {
                IPackageFragmentRoot[] packageRoots = jProject.getPackageFragmentRoots();
                if (packageRoots != null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots;
                    int n = packageRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                        if (packageFragmentRoot.getKind() == 1 && packageFragmentRoot.getPath().isPrefixOf(resource.getFullPath())) {
                            return packageFragmentRoot.getPath();
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String computeProviderText(String esfFileName) {
        String titleName = esfFileName.substring(esfFileName.lastIndexOf("/") + 1, esfFileName.indexOf("."));
        if (titleName.length() > 0) {
            titleName = String.valueOf(titleName.substring(0, 1).toUpperCase()) + titleName.substring(1);
        }
        String result = String.valueOf(esfFileName.substring(0, esfFileName.lastIndexOf("/") + 1)) + titleName + "EsfCtxProvider#getEsfCtx";
        result = result.replace(File.separatorChar, '.');
        result = result.replace('/', '.');
        while (result.startsWith(".")) {
            result = result.substring(1);
        }
        return result;
    }
}

