/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.text.completion;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.mod.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.mod.ui.text.completion.ContentAssistProcessor;
import org.eclipse.dltk.mod.ui.text.completion.ProposalSorterRegistry;
import org.eclipse.dltk.mod.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

public abstract class ScriptCompletionProcessor
extends ContentAssistProcessor {
    private static final String VISIBILITY = "org.eclipse.dltk.mod.core.codeComplete.visibilityCheck";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private IContextInformationValidator fValidator;
    protected final IEditorPart fEditor;

    public ScriptCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(assistant, partition);
        this.fEditor = editor;
    }

    public void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = DLTKCore.getOptions();
        Object value = options.get(VISIBILITY);
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? ENABLED : DISABLED;
            if (!newValue.equals(value)) {
                options.put(VISIBILITY, newValue);
                DLTKCore.setOptions((Hashtable)options);
            }
        }
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    @Override
    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new ScriptParameterListValidator();
        }
        return this.fValidator;
    }

    @Override
    protected List filterAndSortProposals(List proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ProposalSorterRegistry.getDefault().getCurrentSorter().sortProposals(context, proposals);
        return proposals;
    }

    protected abstract String getNatureId();

    protected abstract CompletionProposalLabelProvider getProposalLabelProvider();

    @Override
    protected void setContextInformationMode(ContentAssistInvocationContext context) {
        ((ScriptContentAssistInvocationContext)context).setContextInformationMode(true);
    }

    @Override
    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new ScriptContentAssistInvocationContext(viewer, offset, this.fEditor, this.getNatureId()){

            @Override
            protected CompletionProposalLabelProvider createLabelProvider() {
                return ScriptCompletionProcessor.this.getProposalLabelProvider();
            }
        };
    }

    protected static class ScriptParameterListValidator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        private int initialOffset;

        protected ScriptParameterListValidator() {
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.initialOffset = offset;
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(offset - this.initialOffset) < 5;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

