/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.mod.core.DLTKContributionExtensionManager;
import org.eclipse.dltk.mod.core.IDLTKContributedExtension;
import org.eclipse.dltk.mod.ui.dialogs.PropertyLinkArea;
import org.eclipse.dltk.mod.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.mod.ui.preferences.ComboViewerBlock;
import org.eclipse.dltk.mod.ui.preferences.PreferenceKey;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.dltk.mod.ui.util.SWTFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class ContributedExtensionOptionsBlock
extends AbstractOptionsBlock {
    private Map contribToDescMap = new HashMap();
    private ComboViewerBlock viewer;
    private Composite descriptionPlace;

    public ContributedExtensionOptionsBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    @Override
    public final Control createOptionsBlock(Composite parent) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 4);
        this.createSelectorBlock(composite);
        return composite;
    }

    protected abstract DLTKContributionExtensionManager getExtensionManager();

    protected abstract String getNatureId();

    protected abstract String getPreferenceLinkMessage();

    protected abstract PreferenceKey getSavedContributionKey();

    protected Composite createDescription(Composite parent, IDLTKContributedExtension contrib) {
        Composite composite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 4);
        String desc = contrib.getDescription();
        if (desc == null) {
            desc = "";
        }
        SWTFactory.createLabel(composite, desc, 1);
        String prefPageId = contrib.getPreferencePageId();
        String propPageId = contrib.getPropertyPageId();
        if (this.isProjectPreferencePage() && this.hasValidId(propPageId)) {
            new PropertyLinkArea(composite, 0, propPageId, (IAdaptable)this.fProject, this.getPreferenceLinkMessage(), this.getPreferenceContainer());
        }
        if (!this.isProjectPreferencePage() && this.hasValidId(prefPageId)) {
            new PreferenceLinkArea(composite, 0, prefPageId, this.getPreferenceLinkMessage(), this.getPreferenceContainer(), null);
        }
        return composite;
    }

    protected void createSelectorBlock(Composite composite) {
        int groupColumns = this.getSelectorGroupColumns();
        Composite group = this.createSelectorGroup(composite, groupColumns);
        SWTFactory.createLabel(group, this.getSelectorNameLabel(), 1);
        this.viewer = this.createComboViewerBlock(group);
        this.descriptionPlace = SWTFactory.createComposite(group, group.getFont(), 1, groupColumns, 4);
        this.descriptionPlace.setLayout((Layout)new StackLayout());
    }

    protected ComboViewerBlock createComboViewerBlock(Composite group) {
        GridData gd = new GridData(4, 4, true, true);
        return new ComboViewerBlock(group, gd){

            @Override
            protected String getObjectName(Object element) {
                IDLTKContributedExtension item = (IDLTKContributedExtension)element;
                if (item.getName() != null && item.getName().length() != 0) {
                    return item.getName();
                }
                return item.getClass().getName();
            }

            @Override
            protected void selectedObjectChanged(Object element) {
                ContributedExtensionOptionsBlock.this.updateSelection((IDLTKContributedExtension)element);
            }

            @Override
            protected String getObjectId(Object element) {
                return ((IDLTKContributedExtension)element).getId();
            }

            @Override
            protected Object getDefaultObject() {
                return ContributedExtensionOptionsBlock.this.getExtensionManager().getPriorityContribution(ContributedExtensionOptionsBlock.this.getProject(), ContributedExtensionOptionsBlock.this.getNatureId());
            }

            @Override
            protected String getSavedObjectId() {
                return ContributedExtensionOptionsBlock.this.getValue(ContributedExtensionOptionsBlock.this.getSavedContributionKey());
            }

            @Override
            protected Object getObjectById(String id) {
                return ContributedExtensionOptionsBlock.this.getExtensionManager().getContributionById(id);
            }
        };
    }

    protected int getSelectorGroupColumns() {
        return 1;
    }

    protected Composite createSelectorGroup(Composite composite, int groupColumns) {
        return SWTFactory.createGroup(composite, this.getSelectorGroupLabel(), groupColumns, 1, 768);
    }

    @Override
    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected abstract String getSelectorGroupLabel();

    protected abstract String getSelectorNameLabel();

    @Override
    protected void initialize() {
        super.initialize();
        Object[] contributions = this.getExtensionManager().getContributions(this.getNatureId());
        int i = 0;
        while (i < contributions.length) {
            IDLTKContributedExtension contrib = contributions[i];
            this.contribToDescMap.put(contrib.getId(), this.createDescription(this.descriptionPlace, contrib));
            ++i;
        }
        this.viewer.initialize(contributions);
    }

    @Override
    public void performDefaults() {
        super.performDefaults();
        this.viewer.performDefaults();
    }

    protected final void updateSelection(IDLTKContributedExtension contrib) {
        String id = contrib.getId();
        this.setValue(this.getSavedContributionKey(), id);
        Composite composite = (Composite)this.contribToDescMap.get(id);
        ((StackLayout)this.descriptionPlace.getLayout()).topControl = composite;
        this.descriptionPlace.layout();
        this.selectionChanged(contrib);
    }

    protected void selectionChanged(IDLTKContributedExtension extension) {
    }

    protected IDLTKContributedExtension getSelectedExtension() {
        return (IDLTKContributedExtension)this.viewer.getSelectedObject();
    }

    private boolean hasValidId(String id) {
        return id != null && !"".equals(id);
    }
}

