/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.text.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.ICodeAssist;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.mod.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.mod.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IWorkingCopyManager;
import org.eclipse.dltk.mod.ui.text.completion.HTMLPrinter;
import org.eclipse.dltk.mod.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.osgi.framework.Bundle;

public abstract class AbstractScriptEditorTextHover
implements IScriptEditorTextHover,
ITextHoverExtension {
    private static String fgCSSStyles;
    private IEditorPart fEditor;
    private IPreferenceStore fStore;

    @Override
    public void setPreferenceStore(IPreferenceStore store) {
        this.fStore = store;
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fStore;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return ScriptWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String nature = null;
        ISourceModule inputModelElement = EditorUtility.getEditorInputModelElement(this.fEditor, false);
        if (inputModelElement == null) {
            return null;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)inputModelElement);
        if (toolkit == null) {
            return null;
        }
        nature = toolkit.getNatureId();
        if (nature == null) {
            return null;
        }
        ICodeAssist resolve = this.getCodeAssist();
        if (resolve != null) {
            IModelElement[] result;
            block12: {
                String content;
                block11: {
                    try {
                        content = null;
                        try {
                            content = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
                        }
                        catch (BadLocationException badLocationException) {}
                        result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (result != null) break block11;
                        return null;
                    }
                    catch (ModelException modelException) {
                        return null;
                    }
                }
                int nResults = result.length;
                if (nResults != 0) break block12;
                if (content != null) {
                    return this.getHoverInfo(nature, content);
                }
                return null;
            }
            return this.getHoverInfo(nature, result);
        }
        return null;
    }

    protected String getHoverInfo(String nature, IModelElement[] modelElements) {
        return null;
    }

    protected String getHoverInfo(String nature, String content) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    protected static String getStyleSheet() {
        String css;
        Bundle bundle;
        URL url;
        if (fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)DLTKUIPlugin.getPluginId())).getEntry("/DocumentationHoverStyleSheet.css")) != null) {
            try {
                url = FileLocator.toFileURL((URL)url);
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgCSSStyles = buffer.toString();
            }
            catch (IOException ex) {
                DLTKUIPlugin.log(ex);
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.dltk.mod.ui.documentationFont")[0];
            css = HTMLPrinter.convertTopLevelFont(css, fontData);
        }
        return css;
    }
}

