/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.search;

import java.util.StringTokenizer;
import org.eclipse.dltk.mod.internal.ui.search.DLTKElementMatch;
import org.eclipse.dltk.mod.internal.ui.search.DLTKSearchQuery;
import org.eclipse.dltk.mod.internal.ui.search.ImportFilter;
import org.eclipse.dltk.mod.internal.ui.search.Non_PublicFilter;
import org.eclipse.dltk.mod.internal.ui.search.Non_StaticFilter;
import org.eclipse.dltk.mod.internal.ui.search.PotentialFilter;
import org.eclipse.dltk.mod.internal.ui.search.PublicFilter;
import org.eclipse.dltk.mod.internal.ui.search.ReadFilter;
import org.eclipse.dltk.mod.internal.ui.search.ScriptdocFilter;
import org.eclipse.dltk.mod.internal.ui.search.StaticFilter;
import org.eclipse.dltk.mod.internal.ui.search.WriteFilter;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;

abstract class MatchFilter {
    private static final String SETTINGS_LAST_USED_FILTERS = "filters_last_used";
    private static final MatchFilter POTENTIAL_FILTER = new PotentialFilter();
    private static final MatchFilter IMPORT_FILTER = new ImportFilter();
    private static final MatchFilter SCRIPTDOC_FILTER = new ScriptdocFilter();
    private static final MatchFilter PUBLIC_FILTER = new PublicFilter();
    private static final MatchFilter NON_PUBLIC_FILTER = new Non_PublicFilter();
    private static final MatchFilter STATIC_FILTER = new StaticFilter();
    private static final MatchFilter NON_STATIC_FILTER = new Non_StaticFilter();
    private static final MatchFilter READ_FILTER = new ReadFilter();
    private static final MatchFilter WRITE_FILTER = new WriteFilter();
    private static final MatchFilter[] ALL_FILTERS = new MatchFilter[]{IMPORT_FILTER, SCRIPTDOC_FILTER, PUBLIC_FILTER, NON_PUBLIC_FILTER, STATIC_FILTER, NON_STATIC_FILTER};

    MatchFilter() {
    }

    public static MatchFilter[] getLastUsedFilters() {
        String string = DLTKUIPlugin.getDefault().getDialogSettings().get(SETTINGS_LAST_USED_FILTERS);
        if (string != null && string.length() > 0) {
            return MatchFilter.decodeFiltersString(string);
        }
        return MatchFilter.getDefaultFilters();
    }

    public static void setLastUsedFilters(MatchFilter[] filters) {
        String encoded = MatchFilter.encodeFilters(filters);
        DLTKUIPlugin.getDefault().getDialogSettings().put(SETTINGS_LAST_USED_FILTERS, encoded);
    }

    public static MatchFilter[] getDefaultFilters() {
        return new MatchFilter[]{POTENTIAL_FILTER};
    }

    private static String encodeFilters(MatchFilter[] enabledFilters) {
        StringBuffer buf = new StringBuffer();
        buf.append(enabledFilters.length);
        int i = 0;
        while (i < enabledFilters.length) {
            buf.append(';');
            buf.append(enabledFilters[i].getID());
            ++i;
        }
        return buf.toString();
    }

    private static MatchFilter[] decodeFiltersString(String encodedString) {
        StringTokenizer tokenizer = new StringTokenizer(encodedString, String.valueOf(';'));
        int count = Integer.valueOf(tokenizer.nextToken());
        MatchFilter[] res = new MatchFilter[count];
        int i = 0;
        while (i < count) {
            res[i] = MatchFilter.findMatchFilter(tokenizer.nextToken());
            ++i;
        }
        return res;
    }

    public abstract boolean isApplicable(DLTKSearchQuery var1);

    public abstract boolean filters(DLTKElementMatch var1);

    public abstract String getName();

    public abstract String getActionLabel();

    public abstract String getDescription();

    public abstract String getID();

    public static MatchFilter[] allFilters() {
        return new MatchFilter[0];
    }

    private static MatchFilter findMatchFilter(String id) {
        int i = 0;
        while (i < ALL_FILTERS.length) {
            if (ALL_FILTERS[i].getID().equals(id)) {
                return ALL_FILTERS[i];
            }
            ++i;
        }
        return POTENTIAL_FILTER;
    }
}

