/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.refactoring.reorg;

import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.dltk.mod.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.dltk.mod.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.dltk.mod.internal.ui.refactoring.QualifiedNameComponent;
import org.eclipse.dltk.mod.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.mod.internal.ui.refactoring.TextInputWizardPage;
import org.eclipse.dltk.mod.internal.ui.util.RowLayouter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class RenameInputWizardPage
extends TextInputWizardPage {
    private String fHelpContextID;
    private Button fUpdateReferences;
    private Button fUpdateTextualMatches;
    private Button fUpdateQualifiedNames;
    private Button fLeaveDelegateCheckBox;
    private Button fDeprecateDelegateCheckBox;
    private QualifiedNameComponent fQualifiedNameComponent;
    private static final String UPDATE_TEXTUAL_MATCHES = "updateTextualMatches";
    private static final String UPDATE_QUALIFIED_NAMES = "updateQualifiedNames";

    public RenameInputWizardPage(String description, String contextHelpId, boolean isLastUserPage, String initialValue) {
        super(description, isLastUserPage, initialValue);
        this.fHelpContextID = contextHelpId;
    }

    public void createControl(Composite parent) {
        Composite superComposite = new Composite(parent, 0);
        this.setControl((Control)superComposite);
        this.initializeDialogUnits((Control)superComposite);
        superComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite(superComposite, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        RowLayouter layouter = new RowLayouter(2);
        Label label = new Label(composite, 0);
        label.setText(this.getLabelText());
        Text text = this.createTextInputField(composite);
        text.selectAll();
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(25);
        text.setLayoutData((Object)gd);
        layouter.perform((Control)label, (Control)text, 1);
        Label separator = new Label(composite, 0);
        GridData gridData = new GridData(4, 4, false, false);
        gridData.heightHint = 2;
        separator.setLayoutData((Object)gridData);
        int indent = this.convertWidthInCharsToPixels(2);
        this.addOptionalUpdateReferencesCheckbox(composite, layouter);
        this.addAdditionalOptions(composite, layouter);
        this.addOptionalUpdateTextualMatches(composite, layouter);
        this.addOptionalUpdateQualifiedNameComponent(composite, layouter, indent);
        this.addOptionalLeaveDelegateCheckbox(composite, layouter);
        this.addOptionalDeprecateDelegateCheckbox(composite, layouter, indent);
        this.updateForcePreview();
        Dialog.applyDialogFont((Control)superComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.fHelpContextID);
    }

    protected void addAdditionalOptions(Composite composite, RowLayouter layouter) {
    }

    @Override
    public void setVisible(boolean visible) {
        String newName;
        INameUpdating nameUpdating;
        if (visible && (nameUpdating = (INameUpdating)this.getRefactoring().getAdapter(INameUpdating.class)) != null && (newName = this.getNewName(nameUpdating)) != null && newName.length() > 0 && !newName.equals(this.getInitialValue())) {
            Text textField = this.getTextField();
            textField.setText(newName);
            textField.setSelection(0, newName.length());
        }
        super.setVisible(visible);
    }

    protected String getNewName(INameUpdating nameUpdating) {
        return nameUpdating.getNewElementName();
    }

    protected boolean saveSettings() {
        if (this.getContainer() instanceof Dialog) {
            return ((Dialog)this.getContainer()).getReturnCode() == 0;
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.saveSettings()) {
            this.saveBooleanSetting(UPDATE_TEXTUAL_MATCHES, this.fUpdateTextualMatches);
            this.saveBooleanSetting(UPDATE_QUALIFIED_NAMES, this.fUpdateQualifiedNames);
            if (this.fQualifiedNameComponent != null) {
                this.fQualifiedNameComponent.savePatterns(this.getRefactoringSettings());
            }
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
        }
        super.dispose();
    }

    private void addOptionalUpdateReferencesCheckbox(Composite result, RowLayouter layouter) {
        final IReferenceUpdating ref = (IReferenceUpdating)this.getRefactoring().getAdapter(IReferenceUpdating.class);
        if (ref == null || !ref.canEnableUpdateReferences()) {
            return;
        }
        String title = RefactoringMessages.RenameInputWizardPage_update_references;
        boolean defaultValue = true;
        this.fUpdateReferences = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        ref.setUpdateReferences(this.fUpdateReferences.getSelection());
        this.fUpdateReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ref.setUpdateReferences(RenameInputWizardPage.this.fUpdateReferences.getSelection());
            }
        });
    }

    private void addOptionalUpdateTextualMatches(Composite result, RowLayouter layouter) {
        final ITextUpdating refactoring = (ITextUpdating)this.getRefactoring().getAdapter(ITextUpdating.class);
        if (refactoring == null || !refactoring.canEnableTextUpdating()) {
            return;
        }
        String title = RefactoringMessages.RenameInputWizardPage_update_textual_matches;
        boolean defaultValue = this.getBooleanSetting(UPDATE_TEXTUAL_MATCHES, refactoring.getUpdateTextualMatches());
        this.fUpdateTextualMatches = RenameInputWizardPage.createCheckbox(result, title, defaultValue, layouter);
        refactoring.setUpdateTextualMatches(this.fUpdateTextualMatches.getSelection());
        this.fUpdateTextualMatches.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setUpdateTextualMatches(RenameInputWizardPage.this.fUpdateTextualMatches.getSelection());
                RenameInputWizardPage.this.updateForcePreview();
            }
        });
    }

    private void addOptionalUpdateQualifiedNameComponent(Composite parent, RowLayouter layouter, int marginWidth) {
        final IQualifiedNameUpdating ref = (IQualifiedNameUpdating)this.getRefactoring().getAdapter(IQualifiedNameUpdating.class);
        if (ref == null || !ref.canEnableQualifiedNameUpdating()) {
            return;
        }
        this.fUpdateQualifiedNames = new Button(parent, 32);
        int indent = marginWidth + this.fUpdateQualifiedNames.computeSize((int)-1, (int)-1).x;
        this.fUpdateQualifiedNames.setText(RefactoringMessages.RenameInputWizardPage_update_qualified_names);
        layouter.perform((Control)this.fUpdateQualifiedNames);
        this.fQualifiedNameComponent = new QualifiedNameComponent(parent, 0, ref, this.getRefactoringSettings());
        layouter.perform((Control)this.fQualifiedNameComponent);
        GridData gd = (GridData)this.fQualifiedNameComponent.getLayoutData();
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = indent;
        boolean defaultSelection = this.getBooleanSetting(UPDATE_QUALIFIED_NAMES, ref.getUpdateQualifiedNames());
        this.fUpdateQualifiedNames.setSelection(defaultSelection);
        this.updateQulifiedNameUpdating(ref, defaultSelection);
        this.fUpdateQualifiedNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.widget).getSelection();
                RenameInputWizardPage.this.updateQulifiedNameUpdating(ref, enabled);
            }
        });
    }

    private void updateQulifiedNameUpdating(IQualifiedNameUpdating ref, boolean enabled) {
        this.fQualifiedNameComponent.setEnabled(enabled);
        ref.setUpdateQualifiedNames(enabled);
        this.updateForcePreview();
    }

    private void addOptionalLeaveDelegateCheckbox(Composite result, RowLayouter layouter) {
        final IDelegateUpdating refactoring = (IDelegateUpdating)this.getRefactoring().getAdapter(IDelegateUpdating.class);
        if (refactoring == null || !refactoring.canEnableDelegateUpdating()) {
            return;
        }
        this.fLeaveDelegateCheckBox = RenameInputWizardPage.createCheckbox(result, refactoring.getDelegateUpdatingTitle(false), DelegateUIHelper.loadLeaveDelegateSetting(refactoring), layouter);
        refactoring.setDelegateUpdating(this.fLeaveDelegateCheckBox.getSelection());
        this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setDelegateUpdating(RenameInputWizardPage.this.fLeaveDelegateCheckBox.getSelection());
            }
        });
    }

    private void addOptionalDeprecateDelegateCheckbox(Composite result, RowLayouter layouter, int marginWidth) {
        final IDelegateUpdating refactoring = (IDelegateUpdating)this.getRefactoring().getAdapter(IDelegateUpdating.class);
        if (refactoring == null || !refactoring.canEnableDelegateUpdating()) {
            return;
        }
        this.fDeprecateDelegateCheckBox = new Button(result, 32);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalIndent = marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
        this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
        this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
        this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(refactoring));
        layouter.perform((Control)this.fDeprecateDelegateCheckBox);
        refactoring.setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
        this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                refactoring.setDeprecateDelegates(RenameInputWizardPage.this.fDeprecateDelegateCheckBox.getSelection());
            }
        });
        if (this.fLeaveDelegateCheckBox != null) {
            this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
            this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RenameInputWizardPage.this.fDeprecateDelegateCheckBox.setEnabled(RenameInputWizardPage.this.fLeaveDelegateCheckBox.getSelection());
                }
            });
        }
    }

    protected void updateLeaveDelegateCheckbox(int delegateCount) {
        if (this.fLeaveDelegateCheckBox == null) {
            return;
        }
        IDelegateUpdating refactoring = (IDelegateUpdating)this.getRefactoring().getAdapter(IDelegateUpdating.class);
        this.fLeaveDelegateCheckBox.setEnabled(delegateCount > 0);
        this.fLeaveDelegateCheckBox.setText(refactoring.getDelegateUpdatingTitle(delegateCount > 1));
        if (delegateCount == 0) {
            this.fLeaveDelegateCheckBox.setSelection(false);
            refactoring.setDelegateUpdating(false);
        }
    }

    protected String getLabelText() {
        return RefactoringMessages.RenameInputWizardPage_new_name;
    }

    protected boolean getBooleanSetting(String key, boolean defaultValue) {
        String update = this.getRefactoringSettings().get(key);
        if (update != null) {
            return Boolean.valueOf(update);
        }
        return defaultValue;
    }

    protected void saveBooleanSetting(String key, Button checkBox) {
        if (checkBox != null) {
            this.getRefactoringSettings().put(key, checkBox.getSelection());
        }
    }

    private static Button createCheckbox(Composite parent, String title, boolean value, RowLayouter layouter) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(title);
        checkBox.setSelection(value);
        layouter.perform((Control)checkBox);
        return checkBox;
    }

    private void updateForcePreview() {
        boolean forcePreview = false;
        Refactoring refactoring = this.getRefactoring();
        ITextUpdating tu = (ITextUpdating)refactoring.getAdapter(ITextUpdating.class);
        IQualifiedNameUpdating qu = (IQualifiedNameUpdating)refactoring.getAdapter(IQualifiedNameUpdating.class);
        if (tu != null) {
            forcePreview = tu.getUpdateTextualMatches();
        }
        if (qu != null) {
            forcePreview |= qu.getUpdateQualifiedNames();
        }
        this.getRefactoringWizard().setForcePreviewReview(forcePreview);
    }
}

