/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.preferences;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.internal.ui.util.CoreUtility;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.preferences.PreferenceKey;
import org.eclipse.dltk.mod.ui.util.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class OptionsConfigurationBlock {
    private static final String REBUILD_COUNT_KEY = "preferences_build_requested";
    protected IStatusChangeListener fContext;
    protected final IProject fProject;
    protected final PreferenceKey[] fAllKeys;
    private IScopeContext[] fLookupOrder;
    private Shell fShell;
    private final IWorkingCopyManager fManager;
    private IWorkbenchPreferenceContainer fContainer;
    private Map fDisabledProjectSettings;
    private int fRebuildCount;

    public OptionsConfigurationBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        this.fContext = context;
        this.fProject = project;
        this.fAllKeys = allKeys;
        this.fContainer = container;
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), new InstanceScope(), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.initPreferenceKey();
        this.testIfOptionsComplete(allKeys);
        if (this.fProject == null || this.hasProjectSpecificOptions(this.fProject)) {
            this.fDisabledProjectSettings = null;
        } else {
            this.fDisabledProjectSettings = new IdentityHashMap();
            int i = 0;
            while (i < allKeys.length) {
                PreferenceKey curr = allKeys[i];
                this.fDisabledProjectSettings.put(curr, curr.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++i;
            }
        }
        this.fRebuildCount = this.getRebuildCount();
    }

    protected final IWorkbenchPreferenceContainer getPreferenceContainer() {
        return this.fContainer;
    }

    protected static PreferenceKey getKey(String plugin, String key) {
        return new PreferenceKey(plugin, key);
    }

    public void initPreferenceKey() {
    }

    public void testIfOptionsComplete(PreferenceKey[] allKeys) {
        int i = 0;
        while (i < allKeys.length) {
            if (allKeys[i].getStoredValue(this.fLookupOrder, false, this.fManager) == null) {
                DLTKUIPlugin.logErrorMessage("preference option missing: " + allKeys[i] + " (" + this.getClass().getName() + ')');
            }
            ++i;
        }
    }

    private int getRebuildCount() {
        return this.fManager.getWorkingCopy(new DefaultScope().getNode("org.eclipse.dltk.mod.ui")).getInt(REBUILD_COUNT_KEY, 0);
    }

    private void incrementRebuildCount() {
        ++this.fRebuildCount;
        this.fManager.getWorkingCopy(new DefaultScope().getNode("org.eclipse.dltk.mod.ui")).putInt(REBUILD_COUNT_KEY, this.fRebuildCount);
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            PreferenceKey[] allKeys = this.fAllKeys;
            int i = 0;
            while (i < allKeys.length) {
                if (allKeys[i].getStoredValue((IScopeContext)projectContext, this.fManager) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected boolean checkValue(PreferenceKey key, String value) {
        return value.equals(this.getValue(key));
    }

    protected String getValue(PreferenceKey key) {
        if (this.fDisabledProjectSettings != null) {
            return (String)this.fDisabledProjectSettings.get(key);
        }
        return key.getStoredValue(this.fLookupOrder, false, this.fManager);
    }

    protected boolean getBooleanValue(PreferenceKey key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected String setValue(PreferenceKey key, String value) {
        if (this.fDisabledProjectSettings != null) {
            return this.fDisabledProjectSettings.put(key, value);
        }
        String oldValue = this.getValue(key);
        key.setStoredValue(this.fLookupOrder[0], value, this.fManager);
        return oldValue;
    }

    protected String setValue(PreferenceKey key, boolean value) {
        return this.setValue(key, String.valueOf(value));
    }

    private boolean getChanges(IScopeContext currContext, List changedSettings) {
        boolean completeSettings = this.fProject != null && this.fDisabledProjectSettings == null;
        boolean needsBuild = false;
        int i = 0;
        while (i < this.fAllKeys.length) {
            block9: {
                try {
                    PreferenceKey key = this.fAllKeys[i];
                    String oldVal = key.getStoredValue(currContext, null);
                    String val = key.getStoredValue(currContext, this.fManager);
                    if (val == null) {
                        if (oldVal != null) {
                            changedSettings.add(key);
                            needsBuild |= !oldVal.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                        } else if (completeSettings) {
                            key.setStoredValue(currContext, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                            changedSettings.add(key);
                        }
                    } else if (!val.equals(oldVal)) {
                        changedSettings.add(key);
                        needsBuild |= oldVal != null || !val.equals(key.getStoredValue(this.fLookupOrder, true, this.fManager));
                    }
                }
                catch (IllegalStateException e) {
                    if (!DLTKCore.DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return needsBuild;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean hasProjectSpecificOption;
        boolean bl = hasProjectSpecificOption = this.fDisabledProjectSettings == null;
        if (enable != hasProjectSpecificOption && this.fProject != null) {
            if (enable) {
                int i = 0;
                while (i < this.fAllKeys.length) {
                    PreferenceKey curr = this.fAllKeys[i];
                    String val = (String)this.fDisabledProjectSettings.get(curr);
                    curr.setStoredValue(this.fLookupOrder[0], val, this.fManager);
                    ++i;
                }
                this.fDisabledProjectSettings = null;
            } else {
                this.fDisabledProjectSettings = new IdentityHashMap();
                int i = 0;
                while (i < this.fAllKeys.length) {
                    PreferenceKey curr = this.fAllKeys[i];
                    String oldSetting = curr.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fDisabledProjectSettings.put(curr, oldSetting);
                    curr.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++i;
                }
            }
        }
    }

    public boolean areSettingsEnabled() {
        return this.fDisabledProjectSettings == null || this.fProject == null;
    }

    public boolean performOk() {
        return this.processChanges(this.fContainer);
    }

    public boolean performApply() {
        return this.processChanges(null);
    }

    protected boolean ruleChanged() {
        IScopeContext currContext = this.fLookupOrder[0];
        ArrayList changedOptions = new ArrayList();
        this.getChanges(currContext, changedOptions);
        return !changedOptions.isEmpty();
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        String[] strings;
        int count;
        IScopeContext currContext = this.fLookupOrder[0];
        ArrayList changedOptions = new ArrayList();
        boolean needsBuild = this.getChanges(currContext, changedOptions);
        if (changedOptions.isEmpty()) {
            return true;
        }
        if (needsBuild && (count = this.getRebuildCount()) > this.fRebuildCount) {
            needsBuild = false;
            this.fRebuildCount = count;
        }
        boolean doBuild = false;
        if (needsBuild && (strings = this.getFullBuildDialogStrings(this.fProject == null)) != null) {
            MessageDialog dialog = new MessageDialog(this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 0) {
                doBuild = true;
            } else if (res != 1) {
                return false;
            }
        }
        try {
            this.fManager.applyChanges();
            this.changesSaved();
        }
        catch (BackingStoreException e) {
            DLTKUIPlugin.log(e);
            return false;
        }
        if (container != null) {
            if (doBuild) {
                this.incrementRebuildCount();
                container.registerUpdateJob(CoreUtility.getBuildJob(this.fProject));
            }
        } else if (doBuild) {
            CoreUtility.getBuildJob(this.fProject).schedule();
        }
        return true;
    }

    protected void changesSaved() {
    }

    public void performDefaults() {
        int i = 0;
        while (i < this.fAllKeys.length) {
            PreferenceKey curr = this.fAllKeys[i];
            String origValue = curr.getStoredValue(this.fLookupOrder, true, this.fManager);
            this.setValue(curr, origValue);
            ++i;
        }
    }

    protected void updateControls() {
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    public void dispose() {
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                OptionsConfigurationBlock.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    protected static class ControlData {
        private PreferenceKey fKey;
        private String[] fValues;

        public ControlData(PreferenceKey key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public PreferenceKey getKey() {
            return this.fKey;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.fValues[index];
        }

        public String getValue(int index) {
            return this.fValues[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.fValues.length) {
                    if (value.equals(this.fValues[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.fValues.length - 1;
        }
    }
}

