/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.ui.actions;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.mod.internal.ui.editor.ExternalStorageEditorInput;
import org.eclipse.dltk.mod.ui.DLTKUILanguageManager;
import org.eclipse.dltk.mod.ui.DLTKUIPlugin;
import org.eclipse.dltk.mod.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenStorageWithMenu
extends ContributionItem {
    private IWorkbenchPage page;
    private IAdaptable storage;
    private IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    private static Hashtable imageCache = new Hashtable(11);
    public static final String ID = "org.eclipse.ui.OpenStorageWithMenu";
    private static final int MATCH_BOTH = 3;
    private static final Comparator comparer = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object arg0, Object arg1) {
            try {
                String s1 = ((IEditorDescriptor)arg0).getLabel();
                String s2 = ((IEditorDescriptor)arg1).getLabel();
                return this.collator.compare(s1, s2);
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                return 0;
            }
        }
    };

    public OpenStorageWithMenu(IWorkbenchPage page) {
        this(page, null);
    }

    public OpenStorageWithMenu(IWorkbenchPage page, IAdaptable storage) {
        super(ID);
        this.page = page;
        this.storage = storage;
    }

    private Image getImage(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = this.getImageDescriptor(editorDesc);
        if (imageDesc == null) {
            return null;
        }
        Image image = (Image)imageCache.get(imageDesc);
        if (image == null) {
            image = imageDesc.createImage();
            imageCache.put(imageDesc, image);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(IEditorDescriptor editorDesc) {
        ImageDescriptor imageDesc = null;
        imageDesc = editorDesc == null ? this.registry.getImageDescriptor(this.getStorage().getName()) : editorDesc.getImageDescriptor();
        if (imageDesc == null && editorDesc.getId().equals("org.eclipse.ui.systemExternalEditor")) {
            imageDesc = this.registry.getSystemExternalEditorImageDescriptor(this.getStorage().getName());
        }
        return imageDesc;
    }

    private void createMenuItem(Menu menu, final IEditorDescriptor descriptor, IEditorDescriptor preferredEditor) {
        final MenuItem menuItem = new MenuItem(menu, 16);
        boolean isPreferred = preferredEditor != null && descriptor.getId().equals(preferredEditor.getId());
        menuItem.setSelection(isPreferred);
        menuItem.setText(descriptor.getLabel());
        Image image = this.getImage(descriptor);
        if (image != null) {
            menuItem.setImage(image);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        OpenStorageWithMenu.this.openEditor(descriptor);
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }

    private IModelElement getModelElement() {
        if (this.storage instanceof IModelElement) {
            return (IModelElement)this.storage;
        }
        return null;
    }

    IEditorDescriptor getDefaultEditor() {
        IDLTKUILanguageToolkit toolkit;
        String editorId;
        IEditorDescriptor desc = null;
        IModelElement elem = this.getModelElement();
        if (elem != null && (editorId = (toolkit = DLTKUILanguageManager.getLanguageToolkit(elem)).getEditorId(elem)) != null) {
            desc = this.registry.findEditor(editorId);
        }
        if (desc != null) {
            return desc;
        }
        IStorage storage = this.getStorage();
        if (storage == null) {
            return this.registry.getDefaultEditor(storage.getName());
        }
        return null;
    }

    public void fill(Menu menu, int index) {
        IStorage storage = this.getStorage();
        if (storage == null) {
            return;
        }
        IEditorDescriptor defaultEditor = this.registry.findEditor("org.eclipse.ui.DefaultTextEditor");
        IEditorDescriptor preferredEditor = this.getDefaultEditor();
        IEditorDescriptor[] editors = this.registry.getEditors(storage.getName());
        Collections.sort(Arrays.asList(editors), comparer);
        boolean defaultFound = false;
        ArrayList<IEditorDescriptor> alreadyMapped = new ArrayList<IEditorDescriptor>();
        if (preferredEditor != null) {
            this.createMenuItem(menu, preferredEditor, preferredEditor);
            if (defaultEditor != null && preferredEditor.getId().equals(defaultEditor.getId())) {
                defaultFound = true;
            }
            alreadyMapped.add(preferredEditor);
        }
        int i = 0;
        while (i < editors.length) {
            IEditorDescriptor editor = editors[i];
            if (!alreadyMapped.contains(editor)) {
                this.createMenuItem(menu, editor, preferredEditor);
                if (defaultEditor != null && editor.getId().equals(defaultEditor.getId())) {
                    defaultFound = true;
                }
                alreadyMapped.add(editor);
            }
            ++i;
        }
        if (editors.length > 0) {
            new MenuItem(menu, 2);
        }
        if (!defaultFound && defaultEditor != null) {
            this.createMenuItem(menu, defaultEditor, preferredEditor);
        }
        this.createDefaultMenuItem(menu, storage);
    }

    private IStorage getStorage() {
        if (this.storage instanceof IStorage) {
            return (IStorage)this.storage;
        }
        IStorage resource = (IStorage)this.storage.getAdapter(IStorage.class);
        if (resource instanceof IStorage) {
            return resource;
        }
        return null;
    }

    public boolean isDynamic() {
        return true;
    }

    private void openEditor(IEditorDescriptor editor) {
        IStorage storage = this.getStorage();
        if (storage == null) {
            return;
        }
        try {
            String editorId = editor == null ? "org.eclipse.ui.systemExternalEditor" : editor.getId();
            this.page.openEditor((IEditorInput)new ExternalStorageEditorInput(storage), editorId, true, 3);
            this.registry.setDefaultEditor(storage.getName(), editorId);
        }
        catch (PartInitException e) {
            DLTKUIPlugin.log(e);
        }
    }

    private void createDefaultMenuItem(Menu menu, final IStorage storage) {
        final IEditorDescriptor desc = this.getDefaultEditor();
        if (desc == null) {
            return;
        }
        final MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setSelection(desc == null);
        menuItem.setText(ActionMessages.DefaultEditorDescription_name);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        if (!menuItem.getSelection()) break;
                        try {
                            OpenStorageWithMenu.this.page.openEditor((IEditorInput)new ExternalStorageEditorInput(storage), desc.getId(), true, 3);
                            break;
                        }
                        catch (PartInitException e) {
                            DLTKUIPlugin.log(e);
                        }
                    }
                }
            }
        };
        menuItem.addListener(13, listener);
    }
}

